@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExperimentArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.State
import com.pulumi.azurenative.network.kotlin.inputs.ExperimentEndpointArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExperimentEndpointArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the properties of an Experiment
 * Azure REST API version: 2019-11-01. Prior API version in Azure Native 1.x: 2019-11-01.
 * ## Example Usage
 * ### Creates an Experiment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var experiment = new AzureNative.Network.Experiment("experiment", new()
 *     {
 *         Description = "this is my first experiment!",
 *         EnabledState = "Enabled",
 *         EndpointA = new AzureNative.Network.Inputs.ExperimentEndpointArgs
 *         {
 *             Endpoint = "endpointA.net",
 *             Name = "endpoint A",
 *         },
 *         EndpointB = new AzureNative.Network.Inputs.ExperimentEndpointArgs
 *         {
 *             Endpoint = "endpointB.net",
 *             Name = "endpoint B",
 *         },
 *         ExperimentName = "MyExperiment",
 *         ProfileName = "MyProfile",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExperiment(ctx, "experiment", &network.ExperimentArgs{
 * 			Description:  pulumi.String("this is my first experiment!"),
 * 			EnabledState: pulumi.String("Enabled"),
 * 			EndpointA: &network.ExperimentEndpointArgs{
 * 				Endpoint: pulumi.String("endpointA.net"),
 * 				Name:     pulumi.String("endpoint A"),
 * 			},
 * 			EndpointB: &network.ExperimentEndpointArgs{
 * 				Endpoint: pulumi.String("endpointB.net"),
 * 				Name:     pulumi.String("endpoint B"),
 * 			},
 * 			ExperimentName:    pulumi.String("MyExperiment"),
 * 			ProfileName:       pulumi.String("MyProfile"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Experiment;
 * import com.pulumi.azurenative.network.ExperimentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var experiment = new Experiment("experiment", ExperimentArgs.builder()
 *             .description("this is my first experiment!")
 *             .enabledState("Enabled")
 *             .endpointA(Map.ofEntries(
 *                 Map.entry("endpoint", "endpointA.net"),
 *                 Map.entry("name", "endpoint A")
 *             ))
 *             .endpointB(Map.ofEntries(
 *                 Map.entry("endpoint", "endpointB.net"),
 *                 Map.entry("name", "endpoint B")
 *             ))
 *             .experimentName("MyExperiment")
 *             .profileName("MyProfile")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Experiment MyExperiment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/NetworkExperimentProfiles/{profileName}/Experiments/{experimentName}
 * ```
 * @property description The description of the details or intents of the Experiment
 * @property enabledState The state of the Experiment
 * @property endpointA The endpoint A of an experiment
 * @property endpointB The endpoint B of an experiment
 * @property experimentName The Experiment identifier associated with the Experiment
 * @property location Resource location.
 * @property profileName The Profile identifier associated with the Tenant and Partner
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property tags Resource tags.
 */
public data class ExperimentArgs(
    public val description: Output<String>? = null,
    public val enabledState: Output<Either<String, State>>? = null,
    public val endpointA: Output<ExperimentEndpointArgs>? = null,
    public val endpointB: Output<ExperimentEndpointArgs>? = null,
    public val experimentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExperimentArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExperimentArgs =
        com.pulumi.azurenative.network.ExperimentArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointA(endpointA?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpointB(endpointB?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExperimentArgs].
 */
@PulumiTagMarker
public class ExperimentArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var enabledState: Output<Either<String, State>>? = null

    private var endpointA: Output<ExperimentEndpointArgs>? = null

    private var endpointB: Output<ExperimentEndpointArgs>? = null

    private var experimentName: Output<String>? = null

    private var location: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the details or intents of the Experiment
     */
    @JvmName("cbgohpfgixwrifbu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("yljgjdyggywqifwa")
    public suspend fun enabledState(`value`: Output<Either<String, State>>) {
        this.enabledState = value
    }

    /**
     * @param value The endpoint A of an experiment
     */
    @JvmName("utvbomqmiieyilbi")
    public suspend fun endpointA(`value`: Output<ExperimentEndpointArgs>) {
        this.endpointA = value
    }

    /**
     * @param value The endpoint B of an experiment
     */
    @JvmName("jstcapjlrgxvolml")
    public suspend fun endpointB(`value`: Output<ExperimentEndpointArgs>) {
        this.endpointB = value
    }

    /**
     * @param value The Experiment identifier associated with the Experiment
     */
    @JvmName("loxvrddncbaoqnow")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("bwaijtiykcqahryj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Profile identifier associated with the Tenant and Partner
     */
    @JvmName("lyybhbhopmbthlag")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("cfitfcgvqhpwnxou")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bchebqybhubsixva")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the details or intents of the Experiment
     */
    @JvmName("xafsdvlfhddokecd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("hvngenrqeblumawr")
    public suspend fun enabledState(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("qolhnthnrdfrojmx")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value The state of the Experiment
     */
    @JvmName("cmvbtnakeeckfgdg")
    public fun enabledState(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value The endpoint A of an experiment
     */
    @JvmName("xqbaehpnogkowuge")
    public suspend fun endpointA(`value`: ExperimentEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointA = mapped
    }

    /**
     * @param argument The endpoint A of an experiment
     */
    @JvmName("tmtamclsaaxljodv")
    public suspend fun endpointA(argument: suspend ExperimentEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointA = mapped
    }

    /**
     * @param value The endpoint B of an experiment
     */
    @JvmName("caapjdcexrijpqoh")
    public suspend fun endpointB(`value`: ExperimentEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointB = mapped
    }

    /**
     * @param argument The endpoint B of an experiment
     */
    @JvmName("qscnverwgvwokvbe")
    public suspend fun endpointB(argument: suspend ExperimentEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointB = mapped
    }

    /**
     * @param value The Experiment identifier associated with the Experiment
     */
    @JvmName("ryhwmfdtuptyiavi")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("wtryxmtiyntbqwed")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Profile identifier associated with the Tenant and Partner
     */
    @JvmName("vgtvxslofymmbcvt")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("bfjnlxilqamqqcpg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fgnuyrmbnwytvnac")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("reollvxvrrkcqwxm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ExperimentArgs = ExperimentArgs(
        description = description,
        enabledState = enabledState,
        endpointA = endpointA,
        endpointB = endpointB,
        experimentName = experimentName,
        location = location,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
