@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ExpressRouteConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitPeeringIdArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExpressRouteCircuitPeeringIdArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RoutingConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.RoutingConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ExpressRouteConnection resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### ExpressRouteConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteConnection = new AzureNative.Network.ExpressRouteConnection("expressRouteConnection", new()
 *     {
 *         AuthorizationKey = "authorizationKey",
 *         ConnectionName = "connectionName",
 *         ExpressRouteCircuitPeering = new AzureNative.Network.Inputs.ExpressRouteCircuitPeeringIdArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/circuitName/peerings/AzurePrivatePeering",
 *         },
 *         ExpressRouteGatewayName = "gateway-2",
 *         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteGateways/gateway-2/expressRouteConnections/connectionName",
 *         Name = "connectionName",
 *         ResourceGroupName = "resourceGroupName",
 *         RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *         {
 *             AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *             },
 *             InboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1",
 *             },
 *             OutboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2",
 *             },
 *             PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *             {
 *                 Ids = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3",
 *                     },
 *                 },
 *                 Labels = new[]
 *                 {
 *                     "label1",
 *                     "label2",
 *                 },
 *             },
 *         },
 *         RoutingWeight = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewExpressRouteConnection(ctx, "expressRouteConnection", &network.ExpressRouteConnectionArgs{
 * AuthorizationKey: pulumi.String("authorizationKey"),
 * ConnectionName: pulumi.String("connectionName"),
 * ExpressRouteCircuitPeering: &network.ExpressRouteCircuitPeeringIdArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/circuitName/peerings/AzurePrivatePeering"),
 * },
 * ExpressRouteGatewayName: pulumi.String("gateway-2"),
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteGateways/gateway-2/expressRouteConnections/connectionName"),
 * Name: pulumi.String("connectionName"),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * RoutingConfiguration: network.RoutingConfigurationResponse{
 * AssociatedRouteTable: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * InboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1"),
 * },
 * OutboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2"),
 * },
 * PropagatedRouteTables: interface{}{
 * Ids: network.SubResourceArray{
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3"),
 * },
 * },
 * Labels: pulumi.StringArray{
 * pulumi.String("label1"),
 * pulumi.String("label2"),
 * },
 * },
 * },
 * RoutingWeight: pulumi.Int(2),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteConnection;
 * import com.pulumi.azurenative.network.ExpressRouteConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteConnection = new ExpressRouteConnection("expressRouteConnection", ExpressRouteConnectionArgs.builder()
 *             .authorizationKey("authorizationKey")
 *             .connectionName("connectionName")
 *             .expressRouteCircuitPeering(Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/circuitName/peerings/AzurePrivatePeering"))
 *             .expressRouteGatewayName("gateway-2")
 *             .id("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteGateways/gateway-2/expressRouteConnections/connectionName")
 *             .name("connectionName")
 *             .resourceGroupName("resourceGroupName")
 *             .routingConfiguration(Map.ofEntries(
 *                 Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1")),
 *                 Map.entry("inboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1")),
 *                 Map.entry("outboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2")),
 *                 Map.entry("propagatedRouteTables", Map.ofEntries(
 *                     Map.entry("ids",
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3")),
 *                     Map.entry("labels",
 *                         "label1",
 *                         "label2")
 *                 ))
 *             ))
 *             .routingWeight(2)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteConnection connectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}
 * ```
 * @property authorizationKey Authorization key to establish the connection.
 * @property connectionName The name of the connection subresource.
 * @property enableInternetSecurity Enable internet security.
 * @property enablePrivateLinkFastPath Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
 * @property expressRouteCircuitPeering The ExpressRoute circuit peering.
 * @property expressRouteGatewayBypass Enable FastPath to vWan Firewall hub.
 * @property expressRouteGatewayName The name of the ExpressRoute gateway.
 * @property id Resource ID.
 * @property name The name of the resource.
 * @property resourceGroupName The name of the resource group.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property routingWeight The routing weight associated to the connection.
 */
public data class ExpressRouteConnectionArgs(
    public val authorizationKey: Output<String>? = null,
    public val connectionName: Output<String>? = null,
    public val enableInternetSecurity: Output<Boolean>? = null,
    public val enablePrivateLinkFastPath: Output<Boolean>? = null,
    public val expressRouteCircuitPeering: Output<ExpressRouteCircuitPeeringIdArgs>? = null,
    public val expressRouteGatewayBypass: Output<Boolean>? = null,
    public val expressRouteGatewayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingConfiguration: Output<RoutingConfigurationArgs>? = null,
    public val routingWeight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ExpressRouteConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ExpressRouteConnectionArgs =
        com.pulumi.azurenative.network.ExpressRouteConnectionArgs.builder()
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .enableInternetSecurity(enableInternetSecurity?.applyValue({ args0 -> args0 }))
            .enablePrivateLinkFastPath(enablePrivateLinkFastPath?.applyValue({ args0 -> args0 }))
            .expressRouteCircuitPeering(
                expressRouteCircuitPeering?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expressRouteGatewayBypass(expressRouteGatewayBypass?.applyValue({ args0 -> args0 }))
            .expressRouteGatewayName(expressRouteGatewayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingConfiguration(
                routingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteConnectionArgs].
 */
@PulumiTagMarker
public class ExpressRouteConnectionArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var connectionName: Output<String>? = null

    private var enableInternetSecurity: Output<Boolean>? = null

    private var enablePrivateLinkFastPath: Output<Boolean>? = null

    private var expressRouteCircuitPeering: Output<ExpressRouteCircuitPeeringIdArgs>? = null

    private var expressRouteGatewayBypass: Output<Boolean>? = null

    private var expressRouteGatewayName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingConfiguration: Output<RoutingConfigurationArgs>? = null

    private var routingWeight: Output<Int>? = null

    /**
     * @param value Authorization key to establish the connection.
     */
    @JvmName("jbdjkvbwlkyyltpf")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The name of the connection subresource.
     */
    @JvmName("wvjaycbwsfswsydw")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("lfgokowfnrnuopvn")
    public suspend fun enableInternetSecurity(`value`: Output<Boolean>) {
        this.enableInternetSecurity = value
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("vcxuoiqmahrhetoh")
    public suspend fun enablePrivateLinkFastPath(`value`: Output<Boolean>) {
        this.enablePrivateLinkFastPath = value
    }

    /**
     * @param value The ExpressRoute circuit peering.
     */
    @JvmName("xmborxusphrarvqc")
    public suspend fun expressRouteCircuitPeering(`value`: Output<ExpressRouteCircuitPeeringIdArgs>) {
        this.expressRouteCircuitPeering = value
    }

    /**
     * @param value Enable FastPath to vWan Firewall hub.
     */
    @JvmName("bwkdwjuwslgwtakw")
    public suspend fun expressRouteGatewayBypass(`value`: Output<Boolean>) {
        this.expressRouteGatewayBypass = value
    }

    /**
     * @param value The name of the ExpressRoute gateway.
     */
    @JvmName("xhocdwgvrunjjuuh")
    public suspend fun expressRouteGatewayName(`value`: Output<String>) {
        this.expressRouteGatewayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("aytintergidfvicb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ujvohjldfhlxvyaw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pfwodcgkmalpluys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("bqqfnjqumkrpmrus")
    public suspend fun routingConfiguration(`value`: Output<RoutingConfigurationArgs>) {
        this.routingConfiguration = value
    }

    /**
     * @param value The routing weight associated to the connection.
     */
    @JvmName("igffwacaxlwdycot")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value Authorization key to establish the connection.
     */
    @JvmName("fxcambbewkuqnhsa")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The name of the connection subresource.
     */
    @JvmName("pmalioxpknfpkktd")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("vvfpmsgffbdpgphy")
    public suspend fun enableInternetSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetSecurity = mapped
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("qreolcbalanpajwf")
    public suspend fun enablePrivateLinkFastPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateLinkFastPath = mapped
    }

    /**
     * @param value The ExpressRoute circuit peering.
     */
    @JvmName("mswmoarahtesqrub")
    public suspend fun expressRouteCircuitPeering(`value`: ExpressRouteCircuitPeeringIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param argument The ExpressRoute circuit peering.
     */
    @JvmName("eraqlhkkdplsdyxk")
    public suspend
    fun expressRouteCircuitPeering(argument: suspend ExpressRouteCircuitPeeringIdArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitPeeringIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param value Enable FastPath to vWan Firewall hub.
     */
    @JvmName("iapgectawfaikayt")
    public suspend fun expressRouteGatewayBypass(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGatewayBypass = mapped
    }

    /**
     * @param value The name of the ExpressRoute gateway.
     */
    @JvmName("mxjwdmqdhexokhxy")
    public suspend fun expressRouteGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGatewayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iujlvutmoklllmmk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wjxmimijmpymankj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jremwgmxkqmoyycl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("kabdaufgevjjcumd")
    public suspend fun routingConfiguration(`value`: RoutingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfiguration = mapped
    }

    /**
     * @param argument The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("ngiwemtqhenciaff")
    public suspend
    fun routingConfiguration(argument: suspend RoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfiguration = mapped
    }

    /**
     * @param value The routing weight associated to the connection.
     */
    @JvmName("kspkdcgomprqijog")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    internal fun build(): ExpressRouteConnectionArgs = ExpressRouteConnectionArgs(
        authorizationKey = authorizationKey,
        connectionName = connectionName,
        enableInternetSecurity = enableInternetSecurity,
        enablePrivateLinkFastPath = enablePrivateLinkFastPath,
        expressRouteCircuitPeering = expressRouteCircuitPeering,
        expressRouteGatewayBypass = expressRouteGatewayBypass,
        expressRouteGatewayName = expressRouteGatewayName,
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
        routingConfiguration = routingConfiguration,
        routingWeight = routingWeight,
    )
}
