@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteLinkResponse.Companion.toKotlin as expressRouteLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [ExpressRoutePort].
 */
@PulumiTagMarker
public class ExpressRoutePortResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRoutePortArgs = ExpressRoutePortArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRoutePortArgsBuilder.() -> Unit) {
        val builder = ExpressRoutePortArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExpressRoutePort {
        val builtJavaResource = com.pulumi.azurenative.network.ExpressRoutePort(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ExpressRoutePort(builtJavaResource)
    }
}

/**
 * ExpressRoutePort resource definition.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### ExpressRoutePortCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRoutePort = new AzureNative.Network.ExpressRoutePort("expressRoutePort", new()
 *     {
 *         BandwidthInGbps = 100,
 *         BillingType = "UnlimitedData",
 *         Encapsulation = "QinQ",
 *         ExpressRoutePortName = "portName",
 *         Location = "westus",
 *         PeeringLocation = "peeringLocationName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRoutePort(ctx, "expressRoutePort", &network.ExpressRoutePortArgs{
 * 			BandwidthInGbps:      pulumi.Int(100),
 * 			BillingType:          pulumi.String("UnlimitedData"),
 * 			Encapsulation:        pulumi.String("QinQ"),
 * 			ExpressRoutePortName: pulumi.String("portName"),
 * 			Location:             pulumi.String("westus"),
 * 			PeeringLocation:      pulumi.String("peeringLocationName"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRoutePort;
 * import com.pulumi.azurenative.network.ExpressRoutePortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRoutePort = new ExpressRoutePort("expressRoutePort", ExpressRoutePortArgs.builder()
 *             .bandwidthInGbps(100)
 *             .billingType("UnlimitedData")
 *             .encapsulation("QinQ")
 *             .expressRoutePortName("portName")
 *             .location("westus")
 *             .peeringLocation("peeringLocationName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### ExpressRoutePortUpdateLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRoutePort = new AzureNative.Network.ExpressRoutePort("expressRoutePort", new()
 *     {
 *         BandwidthInGbps = 100,
 *         BillingType = "UnlimitedData",
 *         Encapsulation = "QinQ",
 *         ExpressRoutePortName = "portName",
 *         Links = new[]
 *         {
 *             new AzureNative.Network.Inputs.ExpressRouteLinkArgs
 *             {
 *                 AdminState = "Enabled",
 *                 Name = "link1",
 *             },
 *         },
 *         Location = "westus",
 *         PeeringLocation = "peeringLocationName",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewExpressRoutePort(ctx, "expressRoutePort", &network.ExpressRoutePortArgs{
 * 			BandwidthInGbps:      pulumi.Int(100),
 * 			BillingType:          pulumi.String("UnlimitedData"),
 * 			Encapsulation:        pulumi.String("QinQ"),
 * 			ExpressRoutePortName: pulumi.String("portName"),
 * 			Links: []network.ExpressRouteLinkArgs{
 * 				{
 * 					AdminState: pulumi.String("Enabled"),
 * 					Name:       pulumi.String("link1"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			PeeringLocation:   pulumi.String("peeringLocationName"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRoutePort;
 * import com.pulumi.azurenative.network.ExpressRoutePortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRoutePort = new ExpressRoutePort("expressRoutePort", ExpressRoutePortArgs.builder()
 *             .bandwidthInGbps(100)
 *             .billingType("UnlimitedData")
 *             .encapsulation("QinQ")
 *             .expressRoutePortName("portName")
 *             .links(Map.ofEntries(
 *                 Map.entry("adminState", "Enabled"),
 *                 Map.entry("name", "link1")
 *             ))
 *             .location("westus")
 *             .peeringLocation("peeringLocationName")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRoutePort portName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ExpressRoutePorts/{expressRoutePortName}
 * ```
 */
public class ExpressRoutePort internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRoutePort,
) : KotlinCustomResource(javaResource, ExpressRoutePortMapper) {
    /**
     * Date of the physical port allocation to be used in Letter of Authorization.
     */
    public val allocationDate: Output<String>
        get() = javaResource.allocationDate().applyValue({ args0 -> args0 })

    /**
     * Bandwidth of procured ports in Gbps.
     */
    public val bandwidthInGbps: Output<Int>?
        get() = javaResource.bandwidthInGbps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing type of the ExpressRoutePort resource.
     */
    public val billingType: Output<String>?
        get() = javaResource.billingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Reference the ExpressRoute circuit(s) that are provisioned on this ExpressRoutePort resource.
     */
    public val circuits: Output<List<SubResourceResponse>>
        get() = javaResource.circuits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            })
        })

    /**
     * Encapsulation method on physical ports.
     */
    public val encapsulation: Output<String>?
        get() = javaResource.encapsulation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Ether type of the physical port.
     */
    public val etherType: Output<String>
        get() = javaResource.etherType().applyValue({ args0 -> args0 })

    /**
     * The identity of ExpressRoutePort, if configured.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The set of physical links of the ExpressRoutePort resource.
     */
    public val links: Output<List<ExpressRouteLinkResponse>>?
        get() = javaResource.links().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> expressRouteLinkResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum transmission unit of the physical port pair(s).
     */
    public val mtu: Output<String>
        get() = javaResource.mtu().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the peering location that the ExpressRoutePort is mapped to physically.
     */
    public val peeringLocation: Output<String>?
        get() = javaResource.peeringLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Aggregate Gbps of associated circuit bandwidths.
     */
    public val provisionedBandwidthInGbps: Output<Double>
        get() = javaResource.provisionedBandwidthInGbps().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the express route port resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the express route port resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExpressRoutePortMapper : ResourceMapper<ExpressRoutePort> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRoutePort::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRoutePort = ExpressRoutePort(
        javaResource as
            com.pulumi.azurenative.network.ExpressRoutePort,
    )
}

/**
 * @see [ExpressRoutePort].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRoutePort].
 */
public suspend fun expressRoutePort(
    name: String,
    block: suspend ExpressRoutePortResourceBuilder.() -> Unit,
): ExpressRoutePort {
    val builder = ExpressRoutePortResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRoutePort].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRoutePort(name: String): ExpressRoutePort {
    val builder = ExpressRoutePortResourceBuilder()
    builder.name(name)
    return builder.build()
}
