@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FirewallPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallThreatIntelMode
import com.pulumi.azurenative.network.kotlin.inputs.DnsSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.DnsSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExplicitProxyArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExplicitProxyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyInsightsArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyInsightsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyIntrusionDetectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyIntrusionDetectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySNATArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySNATArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySQLArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySQLArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicySkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyThreatIntelWhitelistArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyThreatIntelWhitelistArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyTransportSecurityArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyTransportSecurityArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * FirewallPolicy Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2020-04-01, 2021-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create FirewallPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicy = new AzureNative.Network.FirewallPolicy("firewallPolicy", new()
 *     {
 *         DnsSettings = new AzureNative.Network.Inputs.DnsSettingsArgs
 *         {
 *             EnableProxy = true,
 *             RequireProxyForNetworkRules = false,
 *             Servers = new[]
 *             {
 *                 "30.3.4.5",
 *             },
 *         },
 *         ExplicitProxy = new AzureNative.Network.Inputs.ExplicitProxyArgs
 *         {
 *             EnableExplicitProxy = true,
 *             EnablePacFile = true,
 *             HttpPort = 8087,
 *             HttpsPort = 8087,
 *             PacFile = "https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D",
 *             PacFilePort = 8087,
 *         },
 *         FirewallPolicyName = "firewallPolicy",
 *         Insights = new AzureNative.Network.Inputs.FirewallPolicyInsightsArgs
 *         {
 *             IsEnabled = true,
 *             LogAnalyticsResources = new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsResourcesArgs
 *             {
 *                 DefaultWorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace",
 *                 },
 *                 Workspaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "westus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.FirewallPolicyLogAnalyticsWorkspaceArgs
 *                     {
 *                         Region = "eastus",
 *                         WorkspaceId = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2",
 *                         },
 *                     },
 *                 },
 *             },
 *             RetentionDays = 100,
 *         },
 *         IntrusionDetection = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionArgs
 *         {
 *             Configuration = new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionConfigurationArgs
 *             {
 *                 BypassTrafficSettings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs
 *                     {
 *                         Description = "Rule 1",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "5.6.7.8",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         Name = "bypassRule1",
 *                         Protocol = "TCP",
 *                         SourceAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                     },
 *                 },
 *                 SignatureOverrides = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs
 *                     {
 *                         Id = "2525004",
 *                         Mode = "Deny",
 *                     },
 *                 },
 *             },
 *             Mode = "Alert",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.FirewallPolicySkuArgs
 *         {
 *             Tier = "Premium",
 *         },
 *         Snat = new AzureNative.Network.Inputs.FirewallPolicySNATArgs
 *         {
 *             PrivateRanges = new[]
 *             {
 *                 "IANAPrivateRanges",
 *             },
 *         },
 *         Sql = new AzureNative.Network.Inputs.FirewallPolicySQLArgs
 *         {
 *             AllowSqlRedirect = true,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         ThreatIntelWhitelist = new AzureNative.Network.Inputs.FirewallPolicyThreatIntelWhitelistArgs
 *         {
 *             Fqdns = new[]
 *             {
 *                 "*.microsoft.com",
 *             },
 *             IpAddresses = new[]
 *             {
 *                 "20.3.4.5",
 *             },
 *         },
 *         TransportSecurity = new AzureNative.Network.Inputs.FirewallPolicyTransportSecurityArgs
 *         {
 *             CertificateAuthority = new AzureNative.Network.Inputs.FirewallPolicyCertificateAuthorityArgs
 *             {
 *                 KeyVaultSecretId = "https://kv/secret",
 *                 Name = "clientcert",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewFirewallPolicy(ctx, "firewallPolicy", &network.FirewallPolicyArgs{
 * DnsSettings: &network.DnsSettingsArgs{
 * EnableProxy: pulumi.Bool(true),
 * RequireProxyForNetworkRules: pulumi.Bool(false),
 * Servers: pulumi.StringArray{
 * pulumi.String("30.3.4.5"),
 * },
 * },
 * ExplicitProxy: &network.ExplicitProxyArgs{
 * EnableExplicitProxy: pulumi.Bool(true),
 * EnablePacFile: pulumi.Bool(true),
 * HttpPort: pulumi.Int(8087),
 * HttpsPort: pulumi.Int(8087),
 * PacFile: pulumi.String("https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D"),
 * PacFilePort: pulumi.Int(8087),
 * },
 * FirewallPolicyName: pulumi.String("firewallPolicy"),
 * Insights: network.FirewallPolicyInsightsResponse{
 * IsEnabled: pulumi.Bool(true),
 * LogAnalyticsResources: interface{}{
 * DefaultWorkspaceId: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace"),
 * },
 * Workspaces: network.FirewallPolicyLogAnalyticsWorkspaceArray{
 * interface{}{
 * Region: pulumi.String("westus"),
 * WorkspaceId: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1"),
 * },
 * },
 * interface{}{
 * Region: pulumi.String("eastus"),
 * WorkspaceId: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2"),
 * },
 * },
 * },
 * },
 * RetentionDays: pulumi.Int(100),
 * },
 * IntrusionDetection: network.FirewallPolicyIntrusionDetectionResponse{
 * Configuration: interface{}{
 * BypassTrafficSettings: network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArray{
 * &network.FirewallPolicyIntrusionDetectionBypassTrafficSpecificationsArgs{
 * Description: pulumi.String("Rule 1"),
 * DestinationAddresses: pulumi.StringArray{
 * pulumi.String("5.6.7.8"),
 * },
 * DestinationPorts: pulumi.StringArray{
 * pulumi.String("*"),
 * },
 * Name: pulumi.String("bypassRule1"),
 * Protocol: pulumi.String("TCP"),
 * SourceAddresses: pulumi.StringArray{
 * pulumi.String("1.2.3.4"),
 * },
 * },
 * },
 * SignatureOverrides: network.FirewallPolicyIntrusionDetectionSignatureSpecificationArray{
 * &network.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs{
 * Id: pulumi.String("2525004"),
 * Mode: pulumi.String("Deny"),
 * },
 * },
 * },
 * Mode: pulumi.String("Alert"),
 * },
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.FirewallPolicySkuArgs{
 * Tier: pulumi.String("Premium"),
 * },
 * Snat: &network.FirewallPolicySNATArgs{
 * PrivateRanges: pulumi.StringArray{
 * pulumi.String("IANAPrivateRanges"),
 * },
 * },
 * Sql: &network.FirewallPolicySQLArgs{
 * AllowSqlRedirect: pulumi.Bool(true),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * ThreatIntelMode: pulumi.String("Alert"),
 * ThreatIntelWhitelist: &network.FirewallPolicyThreatIntelWhitelistArgs{
 * Fqdns: pulumi.StringArray{
 * pulumi.String("*.microsoft.com"),
 * },
 * IpAddresses: pulumi.StringArray{
 * pulumi.String("20.3.4.5"),
 * },
 * },
 * TransportSecurity: network.FirewallPolicyTransportSecurityResponse{
 * CertificateAuthority: &network.FirewallPolicyCertificateAuthorityArgs{
 * KeyVaultSecretId: pulumi.String("https://kv/secret"),
 * Name: pulumi.String("clientcert"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicy;
 * import com.pulumi.azurenative.network.FirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicy = new FirewallPolicy("firewallPolicy", FirewallPolicyArgs.builder()
 *             .dnsSettings(Map.ofEntries(
 *                 Map.entry("enableProxy", true),
 *                 Map.entry("requireProxyForNetworkRules", false),
 *                 Map.entry("servers", "30.3.4.5")
 *             ))
 *             .explicitProxy(Map.ofEntries(
 *                 Map.entry("enableExplicitProxy", true),
 *                 Map.entry("enablePacFile", true),
 *                 Map.entry("httpPort", 8087),
 *                 Map.entry("httpsPort", 8087),
 *                 Map.entry("pacFile", "https://tinawstorage.file.core.windows.net/?sv=2020-02-10&ss=bfqt&srt=sco&sp=rwdlacuptfx&se=2021-06-04T07:01:12Z&st=2021-06-03T23:01:12Z&sip=68.65.171.11&spr=https&sig=Plsa0RRVpGbY0IETZZOT6znOHcSro71LLTTbzquYPgs%3D"),
 *                 Map.entry("pacFilePort", 8087)
 *             ))
 *             .firewallPolicyName("firewallPolicy")
 *             .insights(Map.ofEntries(
 *                 Map.entry("isEnabled", true),
 *                 Map.entry("logAnalyticsResources", Map.ofEntries(
 *                     Map.entry("defaultWorkspaceId", Map.of("id", "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/defaultWorkspace")),
 *                     Map.entry("workspaces",
 *                         Map.ofEntries(
 *                             Map.entry("region", "westus"),
 *                             Map.entry("workspaceId", Map.of("id", "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace1"))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("region", "eastus"),
 *                             Map.entry("workspaceId", Map.of("id", "/subscriptions/subid/resourcegroups/rg1/providers/microsoft.operationalinsights/workspaces/workspace2"))
 *                         ))
 *                 )),
 *                 Map.entry("retentionDays", 100)
 *             ))
 *             .intrusionDetection(Map.ofEntries(
 *                 Map.entry("configuration", Map.ofEntries(
 *                     Map.entry("bypassTrafficSettings", Map.ofEntries(
 *                         Map.entry("description", "Rule 1"),
 *                         Map.entry("destinationAddresses", "5.6.7.8"),
 *                         Map.entry("destinationPorts", "*"),
 *                         Map.entry("name", "bypassRule1"),
 *                         Map.entry("protocol", "TCP"),
 *                         Map.entry("sourceAddresses", "1.2.3.4")
 *                     )),
 *                     Map.entry("signatureOverrides", Map.ofEntries(
 *                         Map.entry("id", "2525004"),
 *                         Map.entry("mode", "Deny")
 *                     ))
 *                 )),
 *                 Map.entry("mode", "Alert")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("tier", "Premium"))
 *             .snat(Map.of("privateRanges", "IANAPrivateRanges"))
 *             .sql(Map.of("allowSqlRedirect", true))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .threatIntelWhitelist(Map.ofEntries(
 *                 Map.entry("fqdns", "*.microsoft.com"),
 *                 Map.entry("ipAddresses", "20.3.4.5")
 *             ))
 *             .transportSecurity(Map.of("certificateAuthority", Map.ofEntries(
 *                 Map.entry("keyVaultSecretId", "https://kv/secret"),
 *                 Map.entry("name", "clientcert")
 *             )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicy firewallPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}
 * ```
 * @property basePolicy The parent firewall policy from which rules are inherited.
 * @property dnsSettings DNS Proxy Settings definition.
 * @property explicitProxy Explicit Proxy Settings definition.
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property id Resource ID.
 * @property identity The identity of the firewall policy.
 * @property insights Insights on Firewall Policy.
 * @property intrusionDetection The configuration for Intrusion detection.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property sku The Firewall Policy SKU.
 * @property snat The private IP addresses/IP ranges to which traffic will not be SNAT.
 * @property sql SQL Settings definition.
 * @property tags Resource tags.
 * @property threatIntelMode The operation mode for Threat Intelligence.
 * @property threatIntelWhitelist ThreatIntel Whitelist for Firewall Policy.
 * @property transportSecurity TLS Configuration definition.
 */
public data class FirewallPolicyArgs(
    public val basePolicy: Output<SubResourceArgs>? = null,
    public val dnsSettings: Output<DnsSettingsArgs>? = null,
    public val explicitProxy: Output<ExplicitProxyArgs>? = null,
    public val firewallPolicyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val insights: Output<FirewallPolicyInsightsArgs>? = null,
    public val intrusionDetection: Output<FirewallPolicyIntrusionDetectionArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<FirewallPolicySkuArgs>? = null,
    public val snat: Output<FirewallPolicySNATArgs>? = null,
    public val sql: Output<FirewallPolicySQLArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val threatIntelMode: Output<Either<String, AzureFirewallThreatIntelMode>>? = null,
    public val threatIntelWhitelist: Output<FirewallPolicyThreatIntelWhitelistArgs>? = null,
    public val transportSecurity: Output<FirewallPolicyTransportSecurityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FirewallPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FirewallPolicyArgs =
        com.pulumi.azurenative.network.FirewallPolicyArgs.builder()
            .basePolicy(basePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .explicitProxy(explicitProxy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .firewallPolicyName(firewallPolicyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .insights(insights?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intrusionDetection(
                intrusionDetection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snat(snat?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sql(sql?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .threatIntelMode(
                threatIntelMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threatIntelWhitelist(
                threatIntelWhitelist?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .transportSecurity(
                transportSecurity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyArgs].
 */
@PulumiTagMarker
public class FirewallPolicyArgsBuilder internal constructor() {
    private var basePolicy: Output<SubResourceArgs>? = null

    private var dnsSettings: Output<DnsSettingsArgs>? = null

    private var explicitProxy: Output<ExplicitProxyArgs>? = null

    private var firewallPolicyName: Output<String>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var insights: Output<FirewallPolicyInsightsArgs>? = null

    private var intrusionDetection: Output<FirewallPolicyIntrusionDetectionArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<FirewallPolicySkuArgs>? = null

    private var snat: Output<FirewallPolicySNATArgs>? = null

    private var sql: Output<FirewallPolicySQLArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var threatIntelMode: Output<Either<String, AzureFirewallThreatIntelMode>>? = null

    private var threatIntelWhitelist: Output<FirewallPolicyThreatIntelWhitelistArgs>? = null

    private var transportSecurity: Output<FirewallPolicyTransportSecurityArgs>? = null

    /**
     * @param value The parent firewall policy from which rules are inherited.
     */
    @JvmName("smevmpiemopgtpkr")
    public suspend fun basePolicy(`value`: Output<SubResourceArgs>) {
        this.basePolicy = value
    }

    /**
     * @param value DNS Proxy Settings definition.
     */
    @JvmName("ofvifpmfojciowtg")
    public suspend fun dnsSettings(`value`: Output<DnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value Explicit Proxy Settings definition.
     */
    @JvmName("nefwbhangivhvtvn")
    public suspend fun explicitProxy(`value`: Output<ExplicitProxyArgs>) {
        this.explicitProxy = value
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("oblhvruhvgdaidfb")
    public suspend fun firewallPolicyName(`value`: Output<String>) {
        this.firewallPolicyName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yryvkoayyvgidsol")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The identity of the firewall policy.
     */
    @JvmName("btebxoejgqirvkcs")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Insights on Firewall Policy.
     */
    @JvmName("pmuhjcxeicywihuk")
    public suspend fun insights(`value`: Output<FirewallPolicyInsightsArgs>) {
        this.insights = value
    }

    /**
     * @param value The configuration for Intrusion detection.
     */
    @JvmName("soomfnekqhjxcrsq")
    public suspend fun intrusionDetection(`value`: Output<FirewallPolicyIntrusionDetectionArgs>) {
        this.intrusionDetection = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tqloqmmdjhajtqih")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bhdnlaesefohgqdm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Firewall Policy SKU.
     */
    @JvmName("oscsqbmkpufjorfn")
    public suspend fun sku(`value`: Output<FirewallPolicySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JvmName("haierxaxmkmnwvfr")
    public suspend fun snat(`value`: Output<FirewallPolicySNATArgs>) {
        this.snat = value
    }

    /**
     * @param value SQL Settings definition.
     */
    @JvmName("vkpklnhgablldiym")
    public suspend fun sql(`value`: Output<FirewallPolicySQLArgs>) {
        this.sql = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wnsjmmkacovnlwwi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("dpuuppnjoyacmbyw")
    public suspend
    fun threatIntelMode(`value`: Output<Either<String, AzureFirewallThreatIntelMode>>) {
        this.threatIntelMode = value
    }

    /**
     * @param value ThreatIntel Whitelist for Firewall Policy.
     */
    @JvmName("xlgnkdktbgyfegcm")
    public suspend fun threatIntelWhitelist(`value`: Output<FirewallPolicyThreatIntelWhitelistArgs>) {
        this.threatIntelWhitelist = value
    }

    /**
     * @param value TLS Configuration definition.
     */
    @JvmName("kihfxashexjtmsqg")
    public suspend fun transportSecurity(`value`: Output<FirewallPolicyTransportSecurityArgs>) {
        this.transportSecurity = value
    }

    /**
     * @param value The parent firewall policy from which rules are inherited.
     */
    @JvmName("fckjmvtfgtkqsigx")
    public suspend fun basePolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basePolicy = mapped
    }

    /**
     * @param argument The parent firewall policy from which rules are inherited.
     */
    @JvmName("amuxmolmgtlenetp")
    public suspend fun basePolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.basePolicy = mapped
    }

    /**
     * @param value DNS Proxy Settings definition.
     */
    @JvmName("wbplacgdjwwgvwpb")
    public suspend fun dnsSettings(`value`: DnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument DNS Proxy Settings definition.
     */
    @JvmName("qvshijlfopkxxymt")
    public suspend fun dnsSettings(argument: suspend DnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DnsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value Explicit Proxy Settings definition.
     */
    @JvmName("adxcyorogvgppysg")
    public suspend fun explicitProxy(`value`: ExplicitProxyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.explicitProxy = mapped
    }

    /**
     * @param argument Explicit Proxy Settings definition.
     */
    @JvmName("gsxnjfuvnucclbht")
    public suspend fun explicitProxy(argument: suspend ExplicitProxyArgsBuilder.() -> Unit) {
        val toBeMapped = ExplicitProxyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.explicitProxy = mapped
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("agenxftdsaxcpydg")
    public suspend fun firewallPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xmhasmngfugwfpoi")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The identity of the firewall policy.
     */
    @JvmName("jyaccpbrqtpwxshb")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the firewall policy.
     */
    @JvmName("ofwwhliylnmoeovd")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Insights on Firewall Policy.
     */
    @JvmName("gotcjbhvaplqatva")
    public suspend fun insights(`value`: FirewallPolicyInsightsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insights = mapped
    }

    /**
     * @param argument Insights on Firewall Policy.
     */
    @JvmName("lqauyfdqencllcad")
    public suspend fun insights(argument: suspend FirewallPolicyInsightsArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyInsightsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.insights = mapped
    }

    /**
     * @param value The configuration for Intrusion detection.
     */
    @JvmName("uvpivkmvakghwwdm")
    public suspend fun intrusionDetection(`value`: FirewallPolicyIntrusionDetectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intrusionDetection = mapped
    }

    /**
     * @param argument The configuration for Intrusion detection.
     */
    @JvmName("kxntqpmxfdidljlj")
    public suspend
    fun intrusionDetection(argument: suspend FirewallPolicyIntrusionDetectionArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyIntrusionDetectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.intrusionDetection = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("iioyceyqyjistjbv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yybsstqoeyooxupf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Firewall Policy SKU.
     */
    @JvmName("nroonocsjglmuuuq")
    public suspend fun sku(`value`: FirewallPolicySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The Firewall Policy SKU.
     */
    @JvmName("rglwfjjydrsyxemr")
    public suspend fun sku(argument: suspend FirewallPolicySkuArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JvmName("twhfmmlgdcamxsgc")
    public suspend fun snat(`value`: FirewallPolicySNATArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snat = mapped
    }

    /**
     * @param argument The private IP addresses/IP ranges to which traffic will not be SNAT.
     */
    @JvmName("chtxjauisauymfjk")
    public suspend fun snat(argument: suspend FirewallPolicySNATArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicySNATArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snat = mapped
    }

    /**
     * @param value SQL Settings definition.
     */
    @JvmName("ocpkgnecgckewkxr")
    public suspend fun sql(`value`: FirewallPolicySQLArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sql = mapped
    }

    /**
     * @param argument SQL Settings definition.
     */
    @JvmName("aibeoxpdhgupddst")
    public suspend fun sql(argument: suspend FirewallPolicySQLArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicySQLArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sql = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("riwyvdtonwtijtck")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ictyfbdcyosxfdun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("rwygjgjsbayocpcf")
    public suspend fun threatIntelMode(`value`: Either<String, AzureFirewallThreatIntelMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("vcohpkfiaygnxeyr")
    public fun threatIntelMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallThreatIntelMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("tfuhiocoinmfbkfb")
    public fun threatIntelMode(`value`: AzureFirewallThreatIntelMode) {
        val toBeMapped = Either.ofRight<String, AzureFirewallThreatIntelMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value ThreatIntel Whitelist for Firewall Policy.
     */
    @JvmName("ahmiqdlirlpiwgxt")
    public suspend fun threatIntelWhitelist(`value`: FirewallPolicyThreatIntelWhitelistArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelWhitelist = mapped
    }

    /**
     * @param argument ThreatIntel Whitelist for Firewall Policy.
     */
    @JvmName("siucsfvpvgapjdar")
    public suspend
    fun threatIntelWhitelist(argument: suspend FirewallPolicyThreatIntelWhitelistArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyThreatIntelWhitelistArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.threatIntelWhitelist = mapped
    }

    /**
     * @param value TLS Configuration definition.
     */
    @JvmName("gxpxficopioprebm")
    public suspend fun transportSecurity(`value`: FirewallPolicyTransportSecurityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportSecurity = mapped
    }

    /**
     * @param argument TLS Configuration definition.
     */
    @JvmName("vdorovrlhtiqhigr")
    public suspend
    fun transportSecurity(argument: suspend FirewallPolicyTransportSecurityArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyTransportSecurityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transportSecurity = mapped
    }

    internal fun build(): FirewallPolicyArgs = FirewallPolicyArgs(
        basePolicy = basePolicy,
        dnsSettings = dnsSettings,
        explicitProxy = explicitProxy,
        firewallPolicyName = firewallPolicyName,
        id = id,
        identity = identity,
        insights = insights,
        intrusionDetection = intrusionDetection,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        snat = snat,
        sql = sql,
        tags = tags,
        threatIntelMode = threatIntelMode,
        threatIntelWhitelist = threatIntelWhitelist,
        transportSecurity = transportSecurity,
    )
}
