@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyFilterRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.FirewallPolicyNatRuleArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rule Group resource.
 * Azure REST API version: 2020-04-01. Prior API version in Azure Native 1.x: 2020-04-01.
 * ## Example Usage
 * ### Create FirewallPolicyRuleGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleGroup = new AzureNative.Network.FirewallPolicyRuleGroup("firewallPolicyRuleGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleGroupName = "ruleGroup1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "Example-Filter-Rule",
 *                 RuleConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleConditionArgs
 *                     {
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         Name = "network-condition1",
 *                         RuleConditionType = "NetworkRuleCondition",
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.1.25.0/24",
 *                         },
 *                     },
 *                 },
 *                 RuleType = "FirewallPolicyFilterRule",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleGroup(ctx, "firewallPolicyRuleGroup", &network.FirewallPolicyRuleGroupArgs{
 * 			FirewallPolicyName: pulumi.String("firewallPolicy"),
 * 			Priority:           pulumi.Int(110),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleGroupName:      pulumi.String("ruleGroup1"),
 * 			Rules: pulumi.Array{
 * 				network.FirewallPolicyFilterRule{
 * 					Action: network.FirewallPolicyFilterRuleAction{
 * 						Type: "Deny",
 * 					},
 * 					Name: "Example-Filter-Rule",
 * 					RuleConditions: []interface{}{
 * 						network.NetworkRuleCondition{
 * 							DestinationAddresses: []string{
 * 								"*",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleConditionNetworkProtocol{
 * 								"TCP",
 * 							},
 * 							Name:              "network-condition1",
 * 							RuleConditionType: "NetworkRuleCondition",
 * 							SourceAddresses: []string{
 * 								"10.1.25.0/24",
 * 							},
 * 						},
 * 					},
 * 					RuleType: "FirewallPolicyFilterRule",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleGroup = new FirewallPolicyRuleGroup("firewallPolicyRuleGroup", FirewallPolicyRuleGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleGroupName("ruleGroup1")
 *             .rules(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "Example-Filter-Rule"),
 *                 Map.entry("ruleConditions", Map.ofEntries(
 *                     Map.entry("destinationAddresses", "*"),
 *                     Map.entry("destinationPorts", "*"),
 *                     Map.entry("ipProtocols", "TCP"),
 *                     Map.entry("name", "network-condition1"),
 *                     Map.entry("ruleConditionType", "NetworkRuleCondition"),
 *                     Map.entry("sourceAddresses", "10.1.25.0/24")
 *                 )),
 *                 Map.entry("ruleType", "FirewallPolicyFilterRule")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create FirewallPolicyRuleGroup With IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallPolicyRuleGroup = new AzureNative.Network.FirewallPolicyRuleGroup("firewallPolicyRuleGroup", new()
 *     {
 *         FirewallPolicyName = "firewallPolicy",
 *         Priority = 110,
 *         ResourceGroupName = "rg1",
 *         RuleGroupName = "ruleGroup1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.FirewallPolicyFilterRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.FirewallPolicyFilterRuleActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "Example-Filter-Rule",
 *                 RuleConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.NetworkRuleConditionArgs
 *                     {
 *                         DestinationIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "*",
 *                         },
 *                         IpProtocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         Name = "network-condition1",
 *                         RuleConditionType = "NetworkRuleCondition",
 *                         SourceIpGroups = new[]
 *                         {
 *                             "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 *                         },
 *                     },
 *                 },
 *                 RuleType = "FirewallPolicyFilterRule",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFirewallPolicyRuleGroup(ctx, "firewallPolicyRuleGroup", &network.FirewallPolicyRuleGroupArgs{
 * 			FirewallPolicyName: pulumi.String("firewallPolicy"),
 * 			Priority:           pulumi.Int(110),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			RuleGroupName:      pulumi.String("ruleGroup1"),
 * 			Rules: pulumi.Array{
 * 				network.FirewallPolicyFilterRule{
 * 					Action: network.FirewallPolicyFilterRuleAction{
 * 						Type: "Deny",
 * 					},
 * 					Name: "Example-Filter-Rule",
 * 					RuleConditions: []interface{}{
 * 						network.NetworkRuleCondition{
 * 							DestinationIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2",
 * 							},
 * 							DestinationPorts: []string{
 * 								"*",
 * 							},
 * 							IpProtocols: []network.FirewallPolicyRuleConditionNetworkProtocol{
 * 								"TCP",
 * 							},
 * 							Name:              "network-condition1",
 * 							RuleConditionType: "NetworkRuleCondition",
 * 							SourceIpGroups: []string{
 * 								"/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1",
 * 							},
 * 						},
 * 					},
 * 					RuleType: "FirewallPolicyFilterRule",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroup;
 * import com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallPolicyRuleGroup = new FirewallPolicyRuleGroup("firewallPolicyRuleGroup", FirewallPolicyRuleGroupArgs.builder()
 *             .firewallPolicyName("firewallPolicy")
 *             .priority(110)
 *             .resourceGroupName("rg1")
 *             .ruleGroupName("ruleGroup1")
 *             .rules(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "Example-Filter-Rule"),
 *                 Map.entry("ruleConditions", Map.ofEntries(
 *                     Map.entry("destinationIpGroups", "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups2"),
 *                     Map.entry("destinationPorts", "*"),
 *                     Map.entry("ipProtocols", "TCP"),
 *                     Map.entry("name", "network-condition1"),
 *                     Map.entry("ruleConditionType", "NetworkRuleCondition"),
 *                     Map.entry("sourceIpGroups", "/subscriptions/subid/providers/Microsoft.Network/resourceGroup/rg1/ipGroups/ipGroups1")
 *                 )),
 *                 Map.entry("ruleType", "FirewallPolicyFilterRule")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FirewallPolicyRuleGroup ruleGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}/ruleGroups/{ruleGroupName}
 * ```
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority Priority of the Firewall Policy Rule Group resource.
 * @property resourceGroupName The name of the resource group.
 * @property ruleGroupName The name of the FirewallPolicyRuleGroup.
 * @property rules Group of Firewall Policy rules.
 */
public data class FirewallPolicyRuleGroupArgs(
    public val firewallPolicyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleGroupName: Output<String>? = null,
    public val rules: Output<List<Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs =
        com.pulumi.azurenative.network.FirewallPolicyRuleGroupArgs.builder()
            .firewallPolicyName(firewallPolicyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleGroupName(ruleGroupName?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyRuleGroupArgs].
 */
@PulumiTagMarker
public class FirewallPolicyRuleGroupArgsBuilder internal constructor() {
    private var firewallPolicyName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleGroupName: Output<String>? = null

    private var rules: Output<List<Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>>>? =
        null

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("ficbinlrieknkdlb")
    public suspend fun firewallPolicyName(`value`: Output<String>) {
        this.firewallPolicyName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wmuksupjegiddwuv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("yprxiseosrnnrpyf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule Group resource.
     */
    @JvmName("kocllradmgjgqjlj")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("foqfvgyucuhkpwbn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the FirewallPolicyRuleGroup.
     */
    @JvmName("xhvfnvehxwatrbau")
    public suspend fun ruleGroupName(`value`: Output<String>) {
        this.ruleGroupName = value
    }

    /**
     * @param value Group of Firewall Policy rules.
     */
    @JvmName("drxnjruhraaxpekw")
    public suspend
    fun rules(`value`: Output<List<Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>>>) {
        this.rules = value
    }

    @JvmName("grporxkiqirgwbab")
    public suspend fun rules(
        vararg
        values: Output<Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>>,
    ) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Group of Firewall Policy rules.
     */
    @JvmName("novtxdiyvgtqhryx")
    public suspend
    fun rules(values: List<Output<Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("pvrtqwdvdmwerwio")
    public suspend fun firewallPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("hjjeqmjxrlfxcgtw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("kmsjubsmgjvuwrqs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule Group resource.
     */
    @JvmName("unxrynjenhxkexjf")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qbmjrswuflffqsfe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the FirewallPolicyRuleGroup.
     */
    @JvmName("xswmblsrdkiwodqi")
    public suspend fun ruleGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroupName = mapped
    }

    /**
     * @param value Group of Firewall Policy rules.
     */
    @JvmName("ahooftkctabbwmpa")
    public suspend
    fun rules(`value`: List<Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param values Group of Firewall Policy rules.
     */
    @JvmName("kcohtpetcctbkjqy")
    public suspend fun rules(
        vararg
        values: Either<FirewallPolicyFilterRuleArgs, FirewallPolicyNatRuleArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): FirewallPolicyRuleGroupArgs = FirewallPolicyRuleGroupArgs(
        firewallPolicyName = firewallPolicyName,
        id = id,
        name = name,
        priority = priority,
        resourceGroupName = resourceGroupName,
        ruleGroupName = ruleGroupName,
        rules = rules,
    )
}
