@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.network.kotlin.outputs.TargetDnsServerResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.TargetDnsServerResponse.Companion.toKotlin as targetDnsServerResponseToKotlin

/**
 * Builder for [ForwardingRule].
 */
@PulumiTagMarker
public class ForwardingRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ForwardingRuleArgs = ForwardingRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ForwardingRuleArgsBuilder.() -> Unit) {
        val builder = ForwardingRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ForwardingRule {
        val builtJavaResource = com.pulumi.azurenative.network.ForwardingRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ForwardingRule(builtJavaResource)
    }
}

/**
 * Describes a forwarding rule within a DNS forwarding ruleset.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert forwarding rule in a DNS forwarding ruleset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var forwardingRule = new AzureNative.Network.ForwardingRule("forwardingRule", new()
 *     {
 *         DnsForwardingRulesetName = "sampleDnsForwardingRuleset",
 *         DomainName = "contoso.com.",
 *         ForwardingRuleName = "sampleForwardingRule",
 *         ForwardingRuleState = "Enabled",
 *         Metadata =
 *         {
 *             { "additionalProp1", "value1" },
 *         },
 *         ResourceGroupName = "sampleResourceGroup",
 *         TargetDnsServers = new[]
 *         {
 *             new AzureNative.Network.Inputs.TargetDnsServerArgs
 *             {
 *                 IpAddress = "10.0.0.1",
 *                 Port = 53,
 *             },
 *             new AzureNative.Network.Inputs.TargetDnsServerArgs
 *             {
 *                 IpAddress = "10.0.0.2",
 *                 Port = 53,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewForwardingRule(ctx, "forwardingRule", &network.ForwardingRuleArgs{
 * 			DnsForwardingRulesetName: pulumi.String("sampleDnsForwardingRuleset"),
 * 			DomainName:               pulumi.String("contoso.com."),
 * 			ForwardingRuleName:       pulumi.String("sampleForwardingRule"),
 * 			ForwardingRuleState:      pulumi.String("Enabled"),
 * 			Metadata: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("value1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			TargetDnsServers: []network.TargetDnsServerArgs{
 * 				{
 * 					IpAddress: pulumi.String("10.0.0.1"),
 * 					Port:      pulumi.Int(53),
 * 				},
 * 				{
 * 					IpAddress: pulumi.String("10.0.0.2"),
 * 					Port:      pulumi.Int(53),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ForwardingRule;
 * import com.pulumi.azurenative.network.ForwardingRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var forwardingRule = new ForwardingRule("forwardingRule", ForwardingRuleArgs.builder()
 *             .dnsForwardingRulesetName("sampleDnsForwardingRuleset")
 *             .domainName("contoso.com.")
 *             .forwardingRuleName("sampleForwardingRule")
 *             .forwardingRuleState("Enabled")
 *             .metadata(Map.of("additionalProp1", "value1"))
 *             .resourceGroupName("sampleResourceGroup")
 *             .targetDnsServers(
 *                 Map.ofEntries(
 *                     Map.entry("ipAddress", "10.0.0.1"),
 *                     Map.entry("port", 53)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("ipAddress", "10.0.0.2"),
 *                     Map.entry("port", 53)
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ForwardingRule sampleForwardingRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}
 * ```
 */
public class ForwardingRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ForwardingRule,
) : KotlinCustomResource(javaResource, ForwardingRuleMapper) {
    /**
     * The domain name for the forwarding rule.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * ETag of the forwarding rule.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The state of forwarding rule.
     */
    public val forwardingRuleState: Output<String>?
        get() = javaResource.forwardingRuleState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata attached to the forwarding rule.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current provisioning state of the forwarding rule. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * DNS servers to forward the DNS query to.
     */
    public val targetDnsServers: Output<List<TargetDnsServerResponse>>
        get() = javaResource.targetDnsServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> targetDnsServerResponseToKotlin(args0) })
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ForwardingRuleMapper : ResourceMapper<ForwardingRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ForwardingRule::class == javaResource::class

    override fun map(javaResource: Resource): ForwardingRule = ForwardingRule(
        javaResource as
            com.pulumi.azurenative.network.ForwardingRule,
    )
}

/**
 * @see [ForwardingRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ForwardingRule].
 */
public suspend fun forwardingRule(
    name: String,
    block: suspend ForwardingRuleResourceBuilder.() -> Unit,
): ForwardingRule {
    val builder = ForwardingRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ForwardingRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun forwardingRule(name: String): ForwardingRule {
    val builder = ForwardingRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
