@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.BackendPoolResponse
import com.pulumi.azurenative.network.kotlin.outputs.BackendPoolsSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.HealthProbeSettingsModelResponse
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancingSettingsModelResponse
import com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.RulesEngineResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.BackendPoolResponse.Companion.toKotlin as backendPoolResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.BackendPoolsSettingsResponse.Companion.toKotlin as backendPoolsSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointResponse.Companion.toKotlin as frontendEndpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.HealthProbeSettingsModelResponse.Companion.toKotlin as healthProbeSettingsModelResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.LoadBalancingSettingsModelResponse.Companion.toKotlin as loadBalancingSettingsModelResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleResponse.Companion.toKotlin as routingRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RulesEngineResponse.Companion.toKotlin as rulesEngineResponseToKotlin

/**
 * Builder for [FrontDoor].
 */
@PulumiTagMarker
public class FrontDoorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FrontDoorArgs = FrontDoorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FrontDoorArgsBuilder.() -> Unit) {
        val builder = FrontDoorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FrontDoor {
        val builtJavaResource = com.pulumi.azurenative.network.FrontDoor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FrontDoor(builtJavaResource)
    }
}

/**
 * Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how traffic is sent there.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update specific Front Door
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var frontDoor = new AzureNative.Network.FrontDoor("frontDoor", new()
 *     {
 *         BackendPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendPoolArgs
 *             {
 *                 Backends = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "w3.contoso.com",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 2,
 *                         Weight = 1,
 *                     },
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "contoso.com.website-us-west-2.othercloud.net",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 1,
 *                         PrivateLinkApprovalMessage = "Please approve the connection request for this Private Link",
 *                         PrivateLinkLocation = "eastus",
 *                         PrivateLinkResourceId = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1",
 *                         Weight = 2,
 *                     },
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "10.0.1.5",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 1,
 *                         PrivateLinkAlias = "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice",
 *                         PrivateLinkApprovalMessage = "Please approve this request to connect to the Private Link",
 *                         Weight = 1,
 *                     },
 *                 },
 *                 HealthProbeSettings = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1",
 *                 },
 *                 LoadBalancingSettings = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1",
 *                 },
 *                 Name = "backendPool1",
 *             },
 *         },
 *         BackendPoolsSettings = new AzureNative.Network.Inputs.BackendPoolsSettingsArgs
 *         {
 *             EnforceCertificateNameCheck = "Enabled",
 *             SendRecvTimeoutSeconds = 60,
 *         },
 *         EnabledState = "Enabled",
 *         FrontDoorName = "frontDoor1",
 *         FrontendEndpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendEndpointArgs
 *             {
 *                 HostName = "www.contoso.com",
 *                 Name = "frontendEndpoint1",
 *                 SessionAffinityEnabledState = "Enabled",
 *                 SessionAffinityTtlSeconds = 60,
 *                 WebApplicationFirewallPolicyLink = new AzureNative.Network.Inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.FrontendEndpointArgs
 *             {
 *                 HostName = "frontDoor1.azurefd.net",
 *                 Name = "default",
 *             },
 *         },
 *         HealthProbeSettings = new[]
 *         {
 *             new AzureNative.Network.Inputs.HealthProbeSettingsModelArgs
 *             {
 *                 EnabledState = "Enabled",
 *                 HealthProbeMethod = "HEAD",
 *                 IntervalInSeconds = 120,
 *                 Name = "healthProbeSettings1",
 *                 Path = "/",
 *                 Protocol = "Http",
 *             },
 *         },
 *         LoadBalancingSettings = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingSettingsModelArgs
 *             {
 *                 Name = "loadBalancingSettings1",
 *                 SampleSize = 4,
 *                 SuccessfulSamplesRequired = 2,
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RoutingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RoutingRuleArgs
 *             {
 *                 AcceptedProtocols = new[]
 *                 {
 *                     "Http",
 *                 },
 *                 EnabledState = "Enabled",
 *                 FrontendEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default",
 *                     },
 *                 },
 *                 Name = "routingRule1",
 *                 PatternsToMatch = new[]
 *                 {
 *                     "/*",
 *                 },
 *                 RouteConfiguration = new AzureNative.Network.Inputs.ForwardingConfigurationArgs
 *                 {
 *                     BackendPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 *                     },
 *                     OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 *                 },
 *                 RulesEngine = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1",
 *                 },
 *                 WebApplicationFirewallPolicyLink = new AzureNative.Network.Inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFrontDoor(ctx, "frontDoor", &network.FrontDoorArgs{
 * 			BackendPools: []network.BackendPoolArgs{
 * 				{
 * 					Backends: network.BackendArray{
 * 						{
 * 							Address:   pulumi.String("w3.contoso.com"),
 * 							HttpPort:  pulumi.Int(80),
 * 							HttpsPort: pulumi.Int(443),
 * 							Priority:  pulumi.Int(2),
 * 							Weight:    pulumi.Int(1),
 * 						},
 * 						{
 * 							Address:                    pulumi.String("contoso.com.website-us-west-2.othercloud.net"),
 * 							HttpPort:                   pulumi.Int(80),
 * 							HttpsPort:                  pulumi.Int(443),
 * 							Priority:                   pulumi.Int(1),
 * 							PrivateLinkApprovalMessage: pulumi.String("Please approve the connection request for this Private Link"),
 * 							PrivateLinkLocation:        pulumi.String("eastus"),
 * 							PrivateLinkResourceId:      pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 * 							Weight:                     pulumi.Int(2),
 * 						},
 * 						{
 * 							Address:                    pulumi.String("10.0.1.5"),
 * 							HttpPort:                   pulumi.Int(80),
 * 							HttpsPort:                  pulumi.Int(443),
 * 							Priority:                   pulumi.Int(1),
 * 							PrivateLinkAlias:           pulumi.String("APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice"),
 * 							PrivateLinkApprovalMessage: pulumi.String("Please approve this request to connect to the Private Link"),
 * 							Weight:                     pulumi.Int(1),
 * 						},
 * 					},
 * 					HealthProbeSettings: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1"),
 * 					},
 * 					LoadBalancingSettings: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1"),
 * 					},
 * 					Name: pulumi.String("backendPool1"),
 * 				},
 * 			},
 * 			BackendPoolsSettings: &network.BackendPoolsSettingsArgs{
 * 				EnforceCertificateNameCheck: pulumi.String("Enabled"),
 * 				SendRecvTimeoutSeconds:      pulumi.Int(60),
 * 			},
 * 			EnabledState:  pulumi.String("Enabled"),
 * 			FrontDoorName: pulumi.String("frontDoor1"),
 * 			FrontendEndpoints: []network.FrontendEndpointArgs{
 * 				{
 * 					HostName:                    pulumi.String("www.contoso.com"),
 * 					Name:                        pulumi.String("frontendEndpoint1"),
 * 					SessionAffinityEnabledState: pulumi.String("Enabled"),
 * 					SessionAffinityTtlSeconds:   pulumi.Int(60),
 * 					WebApplicationFirewallPolicyLink: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"),
 * 					},
 * 				},
 * 				{
 * 					HostName: pulumi.String("frontDoor1.azurefd.net"),
 * 					Name:     pulumi.String("default"),
 * 				},
 * 			},
 * 			HealthProbeSettings: []network.HealthProbeSettingsModelArgs{
 * 				{
 * 					EnabledState:      pulumi.String("Enabled"),
 * 					HealthProbeMethod: pulumi.String("HEAD"),
 * 					IntervalInSeconds: pulumi.Int(120),
 * 					Name:              pulumi.String("healthProbeSettings1"),
 * 					Path:              pulumi.String("/"),
 * 					Protocol:          pulumi.String("Http"),
 * 				},
 * 			},
 * 			LoadBalancingSettings: []network.LoadBalancingSettingsModelArgs{
 * 				{
 * 					Name:                      pulumi.String("loadBalancingSettings1"),
 * 					SampleSize:                pulumi.Int(4),
 * 					SuccessfulSamplesRequired: pulumi.Int(2),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RoutingRules: []network.RoutingRuleArgs{
 * 				{
 * 					AcceptedProtocols: pulumi.StringArray{
 * 						pulumi.String("Http"),
 * 					},
 * 					EnabledState: pulumi.String("Enabled"),
 * 					FrontendEndpoints: network.SubResourceArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1"),
 * 						},
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default"),
 * 						},
 * 					},
 * 					Name: pulumi.String("routingRule1"),
 * 					PatternsToMatch: pulumi.StringArray{
 * 						pulumi.String("/*"),
 * 					},
 * 					RouteConfiguration: {
 * 						BackendPool: {
 * 							Id: "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 * 						},
 * 						OdataType: "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 * 					},
 * 					RulesEngine: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1"),
 * 					},
 * 					WebApplicationFirewallPolicyLink: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FrontDoor;
 * import com.pulumi.azurenative.network.FrontDoorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontDoor = new FrontDoor("frontDoor", FrontDoorArgs.builder()
 *             .backendPools(Map.ofEntries(
 *                 Map.entry("backends",
 *                     Map.ofEntries(
 *                         Map.entry("address", "w3.contoso.com"),
 *                         Map.entry("httpPort", 80),
 *                         Map.entry("httpsPort", 443),
 *                         Map.entry("priority", 2),
 *                         Map.entry("weight", 1)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("address", "contoso.com.website-us-west-2.othercloud.net"),
 *                         Map.entry("httpPort", 80),
 *                         Map.entry("httpsPort", 443),
 *                         Map.entry("priority", 1),
 *                         Map.entry("privateLinkApprovalMessage", "Please approve the connection request for this Private Link"),
 *                         Map.entry("privateLinkLocation", "eastus"),
 *                         Map.entry("privateLinkResourceId", "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 *                         Map.entry("weight", 2)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("address", "10.0.1.5"),
 *                         Map.entry("httpPort", 80),
 *                         Map.entry("httpsPort", 443),
 *                         Map.entry("priority", 1),
 *                         Map.entry("privateLinkAlias", "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice"),
 *                         Map.entry("privateLinkApprovalMessage", "Please approve this request to connect to the Private Link"),
 *                         Map.entry("weight", 1)
 *                     )),
 *                 Map.entry("healthProbeSettings", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1")),
 *                 Map.entry("loadBalancingSettings", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1")),
 *                 Map.entry("name", "backendPool1")
 *             ))
 *             .backendPoolsSettings(Map.ofEntries(
 *                 Map.entry("enforceCertificateNameCheck", "Enabled"),
 *                 Map.entry("sendRecvTimeoutSeconds", 60)
 *             ))
 *             .enabledState("Enabled")
 *             .frontDoorName("frontDoor1")
 *             .frontendEndpoints(
 *                 Map.ofEntries(
 *                     Map.entry("hostName", "www.contoso.com"),
 *                     Map.entry("name", "frontendEndpoint1"),
 *                     Map.entry("sessionAffinityEnabledState", "Enabled"),
 *                     Map.entry("sessionAffinityTtlSeconds", 60),
 *                     Map.entry("webApplicationFirewallPolicyLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("hostName", "frontDoor1.azurefd.net"),
 *                     Map.entry("name", "default")
 *                 ))
 *             .healthProbeSettings(Map.ofEntries(
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("healthProbeMethod", "HEAD"),
 *                 Map.entry("intervalInSeconds", 120),
 *                 Map.entry("name", "healthProbeSettings1"),
 *                 Map.entry("path", "/"),
 *                 Map.entry("protocol", "Http")
 *             ))
 *             .loadBalancingSettings(Map.ofEntries(
 *                 Map.entry("name", "loadBalancingSettings1"),
 *                 Map.entry("sampleSize", 4),
 *                 Map.entry("successfulSamplesRequired", 2)
 *             ))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routingRules(Map.ofEntries(
 *                 Map.entry("acceptedProtocols", "Http"),
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("frontendEndpoints",
 *                     Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1"),
 *                     Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default")),
 *                 Map.entry("name", "routingRule1"),
 *                 Map.entry("patternsToMatch", "/*"),
 *                 Map.entry("routeConfiguration", Map.ofEntries(
 *                     Map.entry("backendPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1")),
 *                     Map.entry("odataType", "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration")
 *                 )),
 *                 Map.entry("rulesEngine", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1")),
 *                 Map.entry("webApplicationFirewallPolicyLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"))
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FrontDoor frontDoor1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}
 * ```
 * */*/*/
 */
public class FrontDoor internal constructor(
    override val javaResource: com.pulumi.azurenative.network.FrontDoor,
) : KotlinCustomResource(javaResource, FrontDoorMapper) {
    /**
     * Backend pools available to routing rules.
     */
    public val backendPools: Output<List<BackendPoolResponse>>?
        get() = javaResource.backendPools().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> backendPoolResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Settings for all backendPools
     */
    public val backendPoolsSettings: Output<BackendPoolsSettingsResponse>?
        get() = javaResource.backendPoolsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> backendPoolsSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The host that each frontendEndpoint must CNAME to.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    public val enabledState: Output<String>?
        get() = javaResource.enabledState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-Value pair representing additional properties for frontdoor.
     */
    public val extendedProperties: Output<Map<String, String>>
        get() = javaResource.extendedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A friendly name for the frontDoor
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Id of the frontdoor.
     */
    public val frontdoorId: Output<String>
        get() = javaResource.frontdoorId().applyValue({ args0 -> args0 })

    /**
     * Frontend endpoints available to routing rules.
     */
    public val frontendEndpoints: Output<List<FrontendEndpointResponse>>?
        get() = javaResource.frontendEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        frontendEndpointResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Health probe settings associated with this Front Door instance.
     */
    public val healthProbeSettings: Output<List<HealthProbeSettingsModelResponse>>?
        get() = javaResource.healthProbeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        healthProbeSettingsModelResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Load balancing settings associated with this Front Door instance.
     */
    public val loadBalancingSettings: Output<List<LoadBalancingSettingsModelResponse>>?
        get() = javaResource.loadBalancingSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        loadBalancingSettingsModelResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Front Door.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource status of the Front Door.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Routing rules associated with this Front Door.
     */
    public val routingRules: Output<List<RoutingRuleResponse>>?
        get() = javaResource.routingRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> routingRuleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Rules Engine Configurations available to routing rules.
     */
    public val rulesEngines: Output<List<RulesEngineResponse>>
        get() = javaResource.rulesEngines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    rulesEngineResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FrontDoorMapper : ResourceMapper<FrontDoor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.FrontDoor::class == javaResource::class

    override fun map(javaResource: Resource): FrontDoor = FrontDoor(
        javaResource as
            com.pulumi.azurenative.network.FrontDoor,
    )
}

/**
 * @see [FrontDoor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FrontDoor].
 */
public suspend fun frontDoor(name: String, block: suspend FrontDoorResourceBuilder.() -> Unit):
    FrontDoor {
    val builder = FrontDoorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FrontDoor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun frontDoor(name: String): FrontDoor {
    val builder = FrontDoorResourceBuilder()
    builder.name(name)
    return builder.build()
}
