@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.FrontDoorArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FrontDoorEnabledState
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolsSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.BackendPoolsSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FrontendEndpointArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontendEndpointArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.HealthProbeSettingsModelArgs
import com.pulumi.azurenative.network.kotlin.inputs.HealthProbeSettingsModelArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingSettingsModelArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingSettingsModelArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RoutingRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.RoutingRuleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Front Door represents a collection of backend endpoints to route traffic to along with rules that specify how traffic is sent there.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update specific Front Door
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var frontDoor = new AzureNative.Network.FrontDoor("frontDoor", new()
 *     {
 *         BackendPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendPoolArgs
 *             {
 *                 Backends = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "w3.contoso.com",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 2,
 *                         Weight = 1,
 *                     },
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "contoso.com.website-us-west-2.othercloud.net",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 1,
 *                         PrivateLinkApprovalMessage = "Please approve the connection request for this Private Link",
 *                         PrivateLinkLocation = "eastus",
 *                         PrivateLinkResourceId = "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1",
 *                         Weight = 2,
 *                     },
 *                     new AzureNative.Network.Inputs.BackendArgs
 *                     {
 *                         Address = "10.0.1.5",
 *                         HttpPort = 80,
 *                         HttpsPort = 443,
 *                         Priority = 1,
 *                         PrivateLinkAlias = "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice",
 *                         PrivateLinkApprovalMessage = "Please approve this request to connect to the Private Link",
 *                         Weight = 1,
 *                     },
 *                 },
 *                 HealthProbeSettings = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1",
 *                 },
 *                 LoadBalancingSettings = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1",
 *                 },
 *                 Name = "backendPool1",
 *             },
 *         },
 *         BackendPoolsSettings = new AzureNative.Network.Inputs.BackendPoolsSettingsArgs
 *         {
 *             EnforceCertificateNameCheck = "Enabled",
 *             SendRecvTimeoutSeconds = 60,
 *         },
 *         EnabledState = "Enabled",
 *         FrontDoorName = "frontDoor1",
 *         FrontendEndpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendEndpointArgs
 *             {
 *                 HostName = "www.contoso.com",
 *                 Name = "frontendEndpoint1",
 *                 SessionAffinityEnabledState = "Enabled",
 *                 SessionAffinityTtlSeconds = 60,
 *                 WebApplicationFirewallPolicyLink = new AzureNative.Network.Inputs.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.FrontendEndpointArgs
 *             {
 *                 HostName = "frontDoor1.azurefd.net",
 *                 Name = "default",
 *             },
 *         },
 *         HealthProbeSettings = new[]
 *         {
 *             new AzureNative.Network.Inputs.HealthProbeSettingsModelArgs
 *             {
 *                 EnabledState = "Enabled",
 *                 HealthProbeMethod = "HEAD",
 *                 IntervalInSeconds = 120,
 *                 Name = "healthProbeSettings1",
 *                 Path = "/",
 *                 Protocol = "Http",
 *             },
 *         },
 *         LoadBalancingSettings = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingSettingsModelArgs
 *             {
 *                 Name = "loadBalancingSettings1",
 *                 SampleSize = 4,
 *                 SuccessfulSamplesRequired = 2,
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         RoutingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RoutingRuleArgs
 *             {
 *                 AcceptedProtocols = new[]
 *                 {
 *                     "Http",
 *                 },
 *                 EnabledState = "Enabled",
 *                 FrontendEndpoints = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default",
 *                     },
 *                 },
 *                 Name = "routingRule1",
 *                 PatternsToMatch = new[]
 *                 {
 *                     "/*",
 *                 },
 *                 RouteConfiguration = new AzureNative.Network.Inputs.ForwardingConfigurationArgs
 *                 {
 *                     BackendPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 *                     },
 *                     OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 *                 },
 *                 RulesEngine = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1",
 *                 },
 *                 WebApplicationFirewallPolicyLink = new AzureNative.Network.Inputs.RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1",
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewFrontDoor(ctx, "frontDoor", &network.FrontDoorArgs{
 * 			BackendPools: []network.BackendPoolArgs{
 * 				{
 * 					Backends: network.BackendArray{
 * 						{
 * 							Address:   pulumi.String("w3.contoso.com"),
 * 							HttpPort:  pulumi.Int(80),
 * 							HttpsPort: pulumi.Int(443),
 * 							Priority:  pulumi.Int(2),
 * 							Weight:    pulumi.Int(1),
 * 						},
 * 						{
 * 							Address:                    pulumi.String("contoso.com.website-us-west-2.othercloud.net"),
 * 							HttpPort:                   pulumi.Int(80),
 * 							HttpsPort:                  pulumi.Int(443),
 * 							Priority:                   pulumi.Int(1),
 * 							PrivateLinkApprovalMessage: pulumi.String("Please approve the connection request for this Private Link"),
 * 							PrivateLinkLocation:        pulumi.String("eastus"),
 * 							PrivateLinkResourceId:      pulumi.String("/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 * 							Weight:                     pulumi.Int(2),
 * 						},
 * 						{
 * 							Address:                    pulumi.String("10.0.1.5"),
 * 							HttpPort:                   pulumi.Int(80),
 * 							HttpsPort:                  pulumi.Int(443),
 * 							Priority:                   pulumi.Int(1),
 * 							PrivateLinkAlias:           pulumi.String("APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice"),
 * 							PrivateLinkApprovalMessage: pulumi.String("Please approve this request to connect to the Private Link"),
 * 							Weight:                     pulumi.Int(1),
 * 						},
 * 					},
 * 					HealthProbeSettings: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1"),
 * 					},
 * 					LoadBalancingSettings: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1"),
 * 					},
 * 					Name: pulumi.String("backendPool1"),
 * 				},
 * 			},
 * 			BackendPoolsSettings: &network.BackendPoolsSettingsArgs{
 * 				EnforceCertificateNameCheck: pulumi.String("Enabled"),
 * 				SendRecvTimeoutSeconds:      pulumi.Int(60),
 * 			},
 * 			EnabledState:  pulumi.String("Enabled"),
 * 			FrontDoorName: pulumi.String("frontDoor1"),
 * 			FrontendEndpoints: []network.FrontendEndpointArgs{
 * 				{
 * 					HostName:                    pulumi.String("www.contoso.com"),
 * 					Name:                        pulumi.String("frontendEndpoint1"),
 * 					SessionAffinityEnabledState: pulumi.String("Enabled"),
 * 					SessionAffinityTtlSeconds:   pulumi.Int(60),
 * 					WebApplicationFirewallPolicyLink: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"),
 * 					},
 * 				},
 * 				{
 * 					HostName: pulumi.String("frontDoor1.azurefd.net"),
 * 					Name:     pulumi.String("default"),
 * 				},
 * 			},
 * 			HealthProbeSettings: []network.HealthProbeSettingsModelArgs{
 * 				{
 * 					EnabledState:      pulumi.String("Enabled"),
 * 					HealthProbeMethod: pulumi.String("HEAD"),
 * 					IntervalInSeconds: pulumi.Int(120),
 * 					Name:              pulumi.String("healthProbeSettings1"),
 * 					Path:              pulumi.String("/"),
 * 					Protocol:          pulumi.String("Http"),
 * 				},
 * 			},
 * 			LoadBalancingSettings: []network.LoadBalancingSettingsModelArgs{
 * 				{
 * 					Name:                      pulumi.String("loadBalancingSettings1"),
 * 					SampleSize:                pulumi.Int(4),
 * 					SuccessfulSamplesRequired: pulumi.Int(2),
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RoutingRules: []network.RoutingRuleArgs{
 * 				{
 * 					AcceptedProtocols: pulumi.StringArray{
 * 						pulumi.String("Http"),
 * 					},
 * 					EnabledState: pulumi.String("Enabled"),
 * 					FrontendEndpoints: network.SubResourceArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1"),
 * 						},
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default"),
 * 						},
 * 					},
 * 					Name: pulumi.String("routingRule1"),
 * 					PatternsToMatch: pulumi.StringArray{
 * 						pulumi.String("/*"),
 * 					},
 * 					RouteConfiguration: {
 * 						BackendPool: {
 * 							Id: "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 * 						},
 * 						OdataType: "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 * 					},
 * 					RulesEngine: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1"),
 * 					},
 * 					WebApplicationFirewallPolicyLink: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.FrontDoor;
 * import com.pulumi.azurenative.network.FrontDoorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var frontDoor = new FrontDoor("frontDoor", FrontDoorArgs.builder()
 *             .backendPools(Map.ofEntries(
 *                 Map.entry("backends",
 *                     Map.ofEntries(
 *                         Map.entry("address", "w3.contoso.com"),
 *                         Map.entry("httpPort", 80),
 *                         Map.entry("httpsPort", 443),
 *                         Map.entry("priority", 2),
 *                         Map.entry("weight", 1)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("address", "contoso.com.website-us-west-2.othercloud.net"),
 *                         Map.entry("httpPort", 80),
 *                         Map.entry("httpsPort", 443),
 *                         Map.entry("priority", 1),
 *                         Map.entry("privateLinkApprovalMessage", "Please approve the connection request for this Private Link"),
 *                         Map.entry("privateLinkLocation", "eastus"),
 *                         Map.entry("privateLinkResourceId", "/subscriptions/subid/resourcegroups/rg1/providers/Microsoft.Network/privateLinkServices/pls1"),
 *                         Map.entry("weight", 2)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("address", "10.0.1.5"),
 *                         Map.entry("httpPort", 80),
 *                         Map.entry("httpsPort", 443),
 *                         Map.entry("priority", 1),
 *                         Map.entry("privateLinkAlias", "APPSERVER.d84e61f0-0870-4d24-9746-7438fa0019d1.westus2.azure.privatelinkservice"),
 *                         Map.entry("privateLinkApprovalMessage", "Please approve this request to connect to the Private Link"),
 *                         Map.entry("weight", 1)
 *                     )),
 *                 Map.entry("healthProbeSettings", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/healthProbeSettings/healthProbeSettings1")),
 *                 Map.entry("loadBalancingSettings", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/loadBalancingSettings/loadBalancingSettings1")),
 *                 Map.entry("name", "backendPool1")
 *             ))
 *             .backendPoolsSettings(Map.ofEntries(
 *                 Map.entry("enforceCertificateNameCheck", "Enabled"),
 *                 Map.entry("sendRecvTimeoutSeconds", 60)
 *             ))
 *             .enabledState("Enabled")
 *             .frontDoorName("frontDoor1")
 *             .frontendEndpoints(
 *                 Map.ofEntries(
 *                     Map.entry("hostName", "www.contoso.com"),
 *                     Map.entry("name", "frontendEndpoint1"),
 *                     Map.entry("sessionAffinityEnabledState", "Enabled"),
 *                     Map.entry("sessionAffinityTtlSeconds", 60),
 *                     Map.entry("webApplicationFirewallPolicyLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("hostName", "frontDoor1.azurefd.net"),
 *                     Map.entry("name", "default")
 *                 ))
 *             .healthProbeSettings(Map.ofEntries(
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("healthProbeMethod", "HEAD"),
 *                 Map.entry("intervalInSeconds", 120),
 *                 Map.entry("name", "healthProbeSettings1"),
 *                 Map.entry("path", "/"),
 *                 Map.entry("protocol", "Http")
 *             ))
 *             .loadBalancingSettings(Map.ofEntries(
 *                 Map.entry("name", "loadBalancingSettings1"),
 *                 Map.entry("sampleSize", 4),
 *                 Map.entry("successfulSamplesRequired", 2)
 *             ))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .routingRules(Map.ofEntries(
 *                 Map.entry("acceptedProtocols", "Http"),
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("frontendEndpoints",
 *                     Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/frontendEndpoint1"),
 *                     Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/frontendEndpoints/default")),
 *                 Map.entry("name", "routingRule1"),
 *                 Map.entry("patternsToMatch", "/*"),
 *                 Map.entry("routeConfiguration", Map.ofEntries(
 *                     Map.entry("backendPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1")),
 *                     Map.entry("odataType", "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration")
 *                 )),
 *                 Map.entry("rulesEngine", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/rulesEngines/rulesEngine1")),
 *                 Map.entry("webApplicationFirewallPolicyLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/policy1"))
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:FrontDoor frontDoor1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}
 * ```
 * @property backendPools Backend pools available to routing rules.
 * @property backendPoolsSettings Settings for all backendPools
 * @property enabledState Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
 * @property friendlyName A friendly name for the frontDoor
 * @property frontDoorName Name of the Front Door which is globally unique.
 * @property frontendEndpoints Frontend endpoints available to routing rules.
 * @property healthProbeSettings Health probe settings associated with this Front Door instance.
 * @property loadBalancingSettings Load balancing settings associated with this Front Door instance.
 * @property location Resource location.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property routingRules Routing rules associated with this Front Door.
 * @property tags Resource tags.
 * */*/*/
 */
public data class FrontDoorArgs(
    public val backendPools: Output<List<BackendPoolArgs>>? = null,
    public val backendPoolsSettings: Output<BackendPoolsSettingsArgs>? = null,
    public val enabledState: Output<Either<String, FrontDoorEnabledState>>? = null,
    public val friendlyName: Output<String>? = null,
    public val frontDoorName: Output<String>? = null,
    public val frontendEndpoints: Output<List<FrontendEndpointArgs>>? = null,
    public val healthProbeSettings: Output<List<HealthProbeSettingsModelArgs>>? = null,
    public val loadBalancingSettings: Output<List<LoadBalancingSettingsModelArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingRules: Output<List<RoutingRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.FrontDoorArgs> {
    override fun toJava(): com.pulumi.azurenative.network.FrontDoorArgs =
        com.pulumi.azurenative.network.FrontDoorArgs.builder()
            .backendPools(
                backendPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .backendPoolsSettings(
                backendPoolsSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .frontDoorName(frontDoorName?.applyValue({ args0 -> args0 }))
            .frontendEndpoints(
                frontendEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .healthProbeSettings(
                healthProbeSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancingSettings(
                loadBalancingSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingRules(
                routingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FrontDoorArgs].
 */
@PulumiTagMarker
public class FrontDoorArgsBuilder internal constructor() {
    private var backendPools: Output<List<BackendPoolArgs>>? = null

    private var backendPoolsSettings: Output<BackendPoolsSettingsArgs>? = null

    private var enabledState: Output<Either<String, FrontDoorEnabledState>>? = null

    private var friendlyName: Output<String>? = null

    private var frontDoorName: Output<String>? = null

    private var frontendEndpoints: Output<List<FrontendEndpointArgs>>? = null

    private var healthProbeSettings: Output<List<HealthProbeSettingsModelArgs>>? = null

    private var loadBalancingSettings: Output<List<LoadBalancingSettingsModelArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingRules: Output<List<RoutingRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Backend pools available to routing rules.
     */
    @JvmName("edraqliknouuhcvb")
    public suspend fun backendPools(`value`: Output<List<BackendPoolArgs>>) {
        this.backendPools = value
    }

    @JvmName("rjwxdkbqdcboujcx")
    public suspend fun backendPools(vararg values: Output<BackendPoolArgs>) {
        this.backendPools = Output.all(values.asList())
    }

    /**
     * @param values Backend pools available to routing rules.
     */
    @JvmName("aubhgpwrhvfapgit")
    public suspend fun backendPools(values: List<Output<BackendPoolArgs>>) {
        this.backendPools = Output.all(values)
    }

    /**
     * @param value Settings for all backendPools
     */
    @JvmName("yljhtvfkjnqnysfp")
    public suspend fun backendPoolsSettings(`value`: Output<BackendPoolsSettingsArgs>) {
        this.backendPoolsSettings = value
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("eaccdkrfhitikbgo")
    public suspend fun enabledState(`value`: Output<Either<String, FrontDoorEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value A friendly name for the frontDoor
     */
    @JvmName("etfsipqfpmtaidad")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("rgnxplbxwuavdyhv")
    public suspend fun frontDoorName(`value`: Output<String>) {
        this.frontDoorName = value
    }

    /**
     * @param value Frontend endpoints available to routing rules.
     */
    @JvmName("lyhfxyttvqqtskcq")
    public suspend fun frontendEndpoints(`value`: Output<List<FrontendEndpointArgs>>) {
        this.frontendEndpoints = value
    }

    @JvmName("rqgtxycbpfsyseis")
    public suspend fun frontendEndpoints(vararg values: Output<FrontendEndpointArgs>) {
        this.frontendEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Frontend endpoints available to routing rules.
     */
    @JvmName("ojsrysrcomgwixkm")
    public suspend fun frontendEndpoints(values: List<Output<FrontendEndpointArgs>>) {
        this.frontendEndpoints = Output.all(values)
    }

    /**
     * @param value Health probe settings associated with this Front Door instance.
     */
    @JvmName("styiqpbrqaavowgm")
    public suspend fun healthProbeSettings(`value`: Output<List<HealthProbeSettingsModelArgs>>) {
        this.healthProbeSettings = value
    }

    @JvmName("owpscewxqmvrydke")
    public suspend fun healthProbeSettings(vararg values: Output<HealthProbeSettingsModelArgs>) {
        this.healthProbeSettings = Output.all(values.asList())
    }

    /**
     * @param values Health probe settings associated with this Front Door instance.
     */
    @JvmName("apoyakjwconmawpt")
    public suspend fun healthProbeSettings(values: List<Output<HealthProbeSettingsModelArgs>>) {
        this.healthProbeSettings = Output.all(values)
    }

    /**
     * @param value Load balancing settings associated with this Front Door instance.
     */
    @JvmName("jcbebfpwweylohje")
    public suspend fun loadBalancingSettings(`value`: Output<List<LoadBalancingSettingsModelArgs>>) {
        this.loadBalancingSettings = value
    }

    @JvmName("kiyxoathbjqthqsr")
    public suspend fun loadBalancingSettings(vararg values: Output<LoadBalancingSettingsModelArgs>) {
        this.loadBalancingSettings = Output.all(values.asList())
    }

    /**
     * @param values Load balancing settings associated with this Front Door instance.
     */
    @JvmName("oulvnprurthgcbjf")
    public suspend fun loadBalancingSettings(values: List<Output<LoadBalancingSettingsModelArgs>>) {
        this.loadBalancingSettings = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("fkwxlcjdwxjwmxye")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("trtudnvllarvvjin")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Routing rules associated with this Front Door.
     */
    @JvmName("bjspbulbpctrunfq")
    public suspend fun routingRules(`value`: Output<List<RoutingRuleArgs>>) {
        this.routingRules = value
    }

    @JvmName("yrumcnhchyrrmksx")
    public suspend fun routingRules(vararg values: Output<RoutingRuleArgs>) {
        this.routingRules = Output.all(values.asList())
    }

    /**
     * @param values Routing rules associated with this Front Door.
     */
    @JvmName("xxcivycecdkkredg")
    public suspend fun routingRules(values: List<Output<RoutingRuleArgs>>) {
        this.routingRules = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ultintstbiiuxofo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Backend pools available to routing rules.
     */
    @JvmName("kggjdwlqbybhiveu")
    public suspend fun backendPools(`value`: List<BackendPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPools = mapped
    }

    /**
     * @param argument Backend pools available to routing rules.
     */
    @JvmName("bgwdesenwaqcbkya")
    public suspend fun backendPools(argument: List<suspend BackendPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BackendPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backendPools = mapped
    }

    /**
     * @param argument Backend pools available to routing rules.
     */
    @JvmName("lgafvdatwbopxnkk")
    public suspend fun backendPools(vararg argument: suspend BackendPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BackendPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.backendPools = mapped
    }

    /**
     * @param argument Backend pools available to routing rules.
     */
    @JvmName("jvkmptmktrwslkvn")
    public suspend fun backendPools(argument: suspend BackendPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BackendPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backendPools = mapped
    }

    /**
     * @param values Backend pools available to routing rules.
     */
    @JvmName("mxtwdfqipsgsofdg")
    public suspend fun backendPools(vararg values: BackendPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendPools = mapped
    }

    /**
     * @param value Settings for all backendPools
     */
    @JvmName("emtyfcxqawqimuso")
    public suspend fun backendPoolsSettings(`value`: BackendPoolsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendPoolsSettings = mapped
    }

    /**
     * @param argument Settings for all backendPools
     */
    @JvmName("korvrrhgjxividtm")
    public suspend
    fun backendPoolsSettings(argument: suspend BackendPoolsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BackendPoolsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendPoolsSettings = mapped
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("ixbgljigypiptoum")
    public suspend fun enabledState(`value`: Either<String, FrontDoorEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("lhcnahfogndxcryb")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FrontDoorEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Operational status of the Front Door load balancer. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("kaulgbviottfjhww")
    public fun enabledState(`value`: FrontDoorEnabledState) {
        val toBeMapped = Either.ofRight<String, FrontDoorEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value A friendly name for the frontDoor
     */
    @JvmName("qladjfivptehfwgx")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("xqdgehmtarktrxfi")
    public suspend fun frontDoorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontDoorName = mapped
    }

    /**
     * @param value Frontend endpoints available to routing rules.
     */
    @JvmName("rdyralfboiigxkcn")
    public suspend fun frontendEndpoints(`value`: List<FrontendEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints available to routing rules.
     */
    @JvmName("ilcxypqualgxqlcs")
    public suspend
    fun frontendEndpoints(argument: List<suspend FrontendEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints available to routing rules.
     */
    @JvmName("hbsinlcvoltsiwbp")
    public suspend fun frontendEndpoints(
        vararg
        argument: suspend FrontendEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontendEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param argument Frontend endpoints available to routing rules.
     */
    @JvmName("cpvgjdmqsctafoex")
    public suspend fun frontendEndpoints(argument: suspend FrontendEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrontendEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.frontendEndpoints = mapped
    }

    /**
     * @param values Frontend endpoints available to routing rules.
     */
    @JvmName("nncyovfdijsvfvre")
    public suspend fun frontendEndpoints(vararg values: FrontendEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendEndpoints = mapped
    }

    /**
     * @param value Health probe settings associated with this Front Door instance.
     */
    @JvmName("afgotiqaimalcyuo")
    public suspend fun healthProbeSettings(`value`: List<HealthProbeSettingsModelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings associated with this Front Door instance.
     */
    @JvmName("befykhxtxqfeyyob")
    public suspend
    fun healthProbeSettings(argument: List<suspend HealthProbeSettingsModelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HealthProbeSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings associated with this Front Door instance.
     */
    @JvmName("xegnmmkxtijxpiij")
    public suspend fun healthProbeSettings(
        vararg
        argument: suspend HealthProbeSettingsModelArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HealthProbeSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param argument Health probe settings associated with this Front Door instance.
     */
    @JvmName("dtueisicgheuucxf")
    public suspend
    fun healthProbeSettings(argument: suspend HealthProbeSettingsModelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HealthProbeSettingsModelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.healthProbeSettings = mapped
    }

    /**
     * @param values Health probe settings associated with this Front Door instance.
     */
    @JvmName("pbtcllrpqsykrswl")
    public suspend fun healthProbeSettings(vararg values: HealthProbeSettingsModelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthProbeSettings = mapped
    }

    /**
     * @param value Load balancing settings associated with this Front Door instance.
     */
    @JvmName("yivigltrbpwggcrm")
    public suspend fun loadBalancingSettings(`value`: List<LoadBalancingSettingsModelArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings associated with this Front Door instance.
     */
    @JvmName("svnfvbdcjprywmiq")
    public suspend
    fun loadBalancingSettings(argument: List<suspend LoadBalancingSettingsModelArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancingSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings associated with this Front Door instance.
     */
    @JvmName("irmvlghvxdmbyryg")
    public suspend fun loadBalancingSettings(
        vararg
        argument: suspend LoadBalancingSettingsModelArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancingSettingsModelArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param argument Load balancing settings associated with this Front Door instance.
     */
    @JvmName("yuctkraeaibudfpp")
    public suspend
    fun loadBalancingSettings(argument: suspend LoadBalancingSettingsModelArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancingSettingsModelArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancingSettings = mapped
    }

    /**
     * @param values Load balancing settings associated with this Front Door instance.
     */
    @JvmName("fheestcqifvavexv")
    public suspend fun loadBalancingSettings(vararg values: LoadBalancingSettingsModelArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancingSettings = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("syfdidynartcsjwy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("womdjeefccbtsotu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Routing rules associated with this Front Door.
     */
    @JvmName("lbhkjtkwouuhpbjh")
    public suspend fun routingRules(`value`: List<RoutingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules associated with this Front Door.
     */
    @JvmName("bihhsxiwjsivaodk")
    public suspend fun routingRules(argument: List<suspend RoutingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RoutingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules associated with this Front Door.
     */
    @JvmName("ekmodqtrfcdywukv")
    public suspend fun routingRules(vararg argument: suspend RoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RoutingRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param argument Routing rules associated with this Front Door.
     */
    @JvmName("readklgdvkryfedg")
    public suspend fun routingRules(argument: suspend RoutingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoutingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routingRules = mapped
    }

    /**
     * @param values Routing rules associated with this Front Door.
     */
    @JvmName("fiicvbbguphklykh")
    public suspend fun routingRules(vararg values: RoutingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ohcfnqmvpkqdsxdh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("arfqrhutjqipgtse")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FrontDoorArgs = FrontDoorArgs(
        backendPools = backendPools,
        backendPoolsSettings = backendPoolsSettings,
        enabledState = enabledState,
        friendlyName = friendlyName,
        frontDoorName = frontDoorName,
        frontendEndpoints = frontendEndpoints,
        healthProbeSettings = healthProbeSettings,
        loadBalancingSettings = loadBalancingSettings,
        location = location,
        resourceGroupName = resourceGroupName,
        routingRules = routingRules,
        tags = tags,
    )
}
