@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.HubRouteResponse
import com.pulumi.azurenative.network.kotlin.outputs.HubRouteResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [HubRouteTable].
 */
@PulumiTagMarker
public class HubRouteTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HubRouteTableArgs = HubRouteTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HubRouteTableArgsBuilder.() -> Unit) {
        val builder = HubRouteTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HubRouteTable {
        val builtJavaResource = com.pulumi.azurenative.network.HubRouteTable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HubRouteTable(builtJavaResource)
    }
}

/**
 * RouteTable resource in a virtual hub.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### RouteTablePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hubRouteTable = new AzureNative.Network.HubRouteTable("hubRouteTable", new()
 *     {
 *         Labels = new[]
 *         {
 *             "label1",
 *             "label2",
 *         },
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "hubRouteTable1",
 *         Routes = new[]
 *         {
 *             new AzureNative.Network.Inputs.HubRouteArgs
 *             {
 *                 DestinationType = "CIDR",
 *                 Destinations = new[]
 *                 {
 *                     "10.0.0.0/8",
 *                     "20.0.0.0/8",
 *                     "30.0.0.0/8",
 *                 },
 *                 Name = "route1",
 *                 NextHop = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azureFirewall1",
 *                 NextHopType = "ResourceId",
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewHubRouteTable(ctx, "hubRouteTable", &network.HubRouteTableArgs{
 * 			Labels: pulumi.StringArray{
 * 				pulumi.String("label1"),
 * 				pulumi.String("label2"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteTableName:    pulumi.String("hubRouteTable1"),
 * 			Routes: []network.HubRouteArgs{
 * 				{
 * 					DestinationType: pulumi.String("CIDR"),
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("10.0.0.0/8"),
 * 						pulumi.String("20.0.0.0/8"),
 * 						pulumi.String("30.0.0.0/8"),
 * 					},
 * 					Name:        pulumi.String("route1"),
 * 					NextHop:     pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azureFirewall1"),
 * 					NextHopType: pulumi.String("ResourceId"),
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.HubRouteTable;
 * import com.pulumi.azurenative.network.HubRouteTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hubRouteTable = new HubRouteTable("hubRouteTable", HubRouteTableArgs.builder()
 *             .labels(
 *                 "label1",
 *                 "label2")
 *             .resourceGroupName("rg1")
 *             .routeTableName("hubRouteTable1")
 *             .routes(Map.ofEntries(
 *                 Map.entry("destinationType", "CIDR"),
 *                 Map.entry("destinations",
 *                     "10.0.0.0/8",
 *                     "20.0.0.0/8",
 *                     "30.0.0.0/8"),
 *                 Map.entry("name", "route1"),
 *                 Map.entry("nextHop", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azureFirewall1"),
 *                 Map.entry("nextHopType", "ResourceId")
 *             ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:HubRouteTable hubRouteTable1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubRouteTables/{routeTableName}
 * ```
 */
public class HubRouteTable internal constructor(
    override val javaResource: com.pulumi.azurenative.network.HubRouteTable,
) : KotlinCustomResource(javaResource, HubRouteTableMapper) {
    /**
     * List of all connections associated with this route table.
     */
    public val associatedConnections: Output<List<String>>
        get() = javaResource.associatedConnections().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * List of labels associated with this route table.
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of all connections that advertise to this route table.
     */
    public val propagatingConnections: Output<List<String>>
        get() = javaResource.propagatingConnections().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The provisioning state of the RouteTable resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of all routes.
     */
    public val routes: Output<List<HubRouteResponse>>?
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HubRouteTableMapper : ResourceMapper<HubRouteTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.HubRouteTable::class == javaResource::class

    override fun map(javaResource: Resource): HubRouteTable = HubRouteTable(
        javaResource as
            com.pulumi.azurenative.network.HubRouteTable,
    )
}

/**
 * @see [HubRouteTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HubRouteTable].
 */
public suspend fun hubRouteTable(
    name: String,
    block: suspend HubRouteTableResourceBuilder.() -> Unit,
): HubRouteTable {
    val builder = HubRouteTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HubRouteTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hubRouteTable(name: String): HubRouteTable {
    val builder = HubRouteTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
