@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.HubVirtualNetworkConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RoutingConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.RoutingConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * HubVirtualNetworkConnection Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### HubVirtualNetworkConnectionPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hubVirtualNetworkConnection = new AzureNative.Network.HubVirtualNetworkConnection("hubVirtualNetworkConnection", new()
 *     {
 *         ConnectionName = "connection1",
 *         EnableInternetSecurity = false,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/SpokeVnet1",
 *         },
 *         ResourceGroupName = "rg1",
 *         RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *         {
 *             AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *             },
 *             InboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1",
 *             },
 *             OutboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2",
 *             },
 *             PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *             {
 *                 Ids = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                 },
 *                 Labels = new[]
 *                 {
 *                     "label1",
 *                     "label2",
 *                 },
 *             },
 *             VnetRoutes = new AzureNative.Network.Inputs.VnetRouteArgs
 *             {
 *                 StaticRoutes = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.StaticRouteArgs
 *                     {
 *                         AddressPrefixes = new[]
 *                         {
 *                             "10.1.0.0/16",
 *                             "10.2.0.0/16",
 *                         },
 *                         Name = "route1",
 *                         NextHopIpAddress = "10.0.0.68",
 *                     },
 *                     new AzureNative.Network.Inputs.StaticRouteArgs
 *                     {
 *                         AddressPrefixes = new[]
 *                         {
 *                             "10.3.0.0/16",
 *                             "10.4.0.0/16",
 *                         },
 *                         Name = "route2",
 *                         NextHopIpAddress = "10.0.0.65",
 *                     },
 *                 },
 *                 StaticRoutesConfig = new AzureNative.Network.Inputs.StaticRoutesConfigArgs
 *                 {
 *                     VnetLocalRouteOverrideCriteria = "Equal",
 *                 },
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewHubVirtualNetworkConnection(ctx, "hubVirtualNetworkConnection", &network.HubVirtualNetworkConnectionArgs{
 * ConnectionName: pulumi.String("connection1"),
 * EnableInternetSecurity: pulumi.Bool(false),
 * RemoteVirtualNetwork: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/SpokeVnet1"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * RoutingConfiguration: network.RoutingConfigurationResponse{
 * AssociatedRouteTable: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * },
 * InboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1"),
 * },
 * OutboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2"),
 * },
 * PropagatedRouteTables: interface{}{
 * Ids: network.SubResourceArray{
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * },
 * },
 * Labels: pulumi.StringArray{
 * pulumi.String("label1"),
 * pulumi.String("label2"),
 * },
 * },
 * VnetRoutes: interface{}{
 * StaticRoutes: network.StaticRouteArray{
 * &network.StaticRouteArgs{
 * AddressPrefixes: pulumi.StringArray{
 * pulumi.String("10.1.0.0/16"),
 * pulumi.String("10.2.0.0/16"),
 * },
 * Name: pulumi.String("route1"),
 * NextHopIpAddress: pulumi.String("10.0.0.68"),
 * },
 * &network.StaticRouteArgs{
 * AddressPrefixes: pulumi.StringArray{
 * pulumi.String("10.3.0.0/16"),
 * pulumi.String("10.4.0.0/16"),
 * },
 * Name: pulumi.String("route2"),
 * NextHopIpAddress: pulumi.String("10.0.0.65"),
 * },
 * },
 * StaticRoutesConfig: &network.StaticRoutesConfigArgs{
 * VnetLocalRouteOverrideCriteria: pulumi.String("Equal"),
 * },
 * },
 * },
 * VirtualHubName: pulumi.String("virtualHub1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.HubVirtualNetworkConnection;
 * import com.pulumi.azurenative.network.HubVirtualNetworkConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hubVirtualNetworkConnection = new HubVirtualNetworkConnection("hubVirtualNetworkConnection", HubVirtualNetworkConnectionArgs.builder()
 *             .connectionName("connection1")
 *             .enableInternetSecurity(false)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/SpokeVnet1"))
 *             .resourceGroupName("rg1")
 *             .routingConfiguration(Map.ofEntries(
 *                 Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1")),
 *                 Map.entry("inboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1")),
 *                 Map.entry("outboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2")),
 *                 Map.entry("propagatedRouteTables", Map.ofEntries(
 *                     Map.entry("ids", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1")),
 *                     Map.entry("labels",
 *                         "label1",
 *                         "label2")
 *                 )),
 *                 Map.entry("vnetRoutes", Map.ofEntries(
 *                     Map.entry("staticRoutes",
 *                         Map.ofEntries(
 *                             Map.entry("addressPrefixes",
 *                                 "10.1.0.0/16",
 *                                 "10.2.0.0/16"),
 *                             Map.entry("name", "route1"),
 *                             Map.entry("nextHopIpAddress", "10.0.0.68")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("addressPrefixes",
 *                                 "10.3.0.0/16",
 *                                 "10.4.0.0/16"),
 *                             Map.entry("name", "route2"),
 *                             Map.entry("nextHopIpAddress", "10.0.0.65")
 *                         )),
 *                     Map.entry("staticRoutesConfig", Map.of("vnetLocalRouteOverrideCriteria", "Equal"))
 *                 ))
 *             ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:HubVirtualNetworkConnection connection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/hubVirtualNetworkConnections/{connectionName}
 * ```
 * @property allowHubToRemoteVnetTransit Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
 * @property allowRemoteVnetToUseHubVnetGateways Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
 * @property connectionName The name of the HubVirtualNetworkConnection.
 * @property enableInternetSecurity Enable internet security.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property remoteVirtualNetwork Reference to the remote virtual network.
 * @property resourceGroupName The resource group name of the HubVirtualNetworkConnection.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class HubVirtualNetworkConnectionArgs(
    public val allowHubToRemoteVnetTransit: Output<Boolean>? = null,
    public val allowRemoteVnetToUseHubVnetGateways: Output<Boolean>? = null,
    public val connectionName: Output<String>? = null,
    public val enableInternetSecurity: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val remoteVirtualNetwork: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingConfiguration: Output<RoutingConfigurationArgs>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.HubVirtualNetworkConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.HubVirtualNetworkConnectionArgs =
        com.pulumi.azurenative.network.HubVirtualNetworkConnectionArgs.builder()
            .allowHubToRemoteVnetTransit(allowHubToRemoteVnetTransit?.applyValue({ args0 -> args0 }))
            .allowRemoteVnetToUseHubVnetGateways(
                allowRemoteVnetToUseHubVnetGateways?.applyValue({ args0 ->
                    args0
                }),
            )
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .enableInternetSecurity(enableInternetSecurity?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .remoteVirtualNetwork(
                remoteVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingConfiguration(
                routingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubVirtualNetworkConnectionArgs].
 */
@PulumiTagMarker
public class HubVirtualNetworkConnectionArgsBuilder internal constructor() {
    private var allowHubToRemoteVnetTransit: Output<Boolean>? = null

    private var allowRemoteVnetToUseHubVnetGateways: Output<Boolean>? = null

    private var connectionName: Output<String>? = null

    private var enableInternetSecurity: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var remoteVirtualNetwork: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingConfiguration: Output<RoutingConfigurationArgs>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
     */
    @JvmName("kssijnltgetoddgi")
    public suspend fun allowHubToRemoteVnetTransit(`value`: Output<Boolean>) {
        this.allowHubToRemoteVnetTransit = value
    }

    /**
     * @param value Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
     */
    @JvmName("neqrvrwfwyekuwqx")
    public suspend fun allowRemoteVnetToUseHubVnetGateways(`value`: Output<Boolean>) {
        this.allowRemoteVnetToUseHubVnetGateways = value
    }

    /**
     * @param value The name of the HubVirtualNetworkConnection.
     */
    @JvmName("qifxpuuoidjlcbec")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("eaidnxpeapdwvntg")
    public suspend fun enableInternetSecurity(`value`: Output<Boolean>) {
        this.enableInternetSecurity = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yyyddjkatqagkjwa")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("vilfxsholtxmghqn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to the remote virtual network.
     */
    @JvmName("ahgglyhygfhmtone")
    public suspend fun remoteVirtualNetwork(`value`: Output<SubResourceArgs>) {
        this.remoteVirtualNetwork = value
    }

    /**
     * @param value The resource group name of the HubVirtualNetworkConnection.
     */
    @JvmName("irwashmsvqmfygop")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("jyxufnxradamybhf")
    public suspend fun routingConfiguration(`value`: Output<RoutingConfigurationArgs>) {
        this.routingConfiguration = value
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("moknkfobvtulxwru")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value Deprecated: VirtualHub to RemoteVnet transit to enabled or not.
     */
    @JvmName("irwajotomvxlojpc")
    public suspend fun allowHubToRemoteVnetTransit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHubToRemoteVnetTransit = mapped
    }

    /**
     * @param value Deprecated: Allow RemoteVnet to use Virtual Hub's gateways.
     */
    @JvmName("ccuufipvpwnacfgw")
    public suspend fun allowRemoteVnetToUseHubVnetGateways(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRemoteVnetToUseHubVnetGateways = mapped
    }

    /**
     * @param value The name of the HubVirtualNetworkConnection.
     */
    @JvmName("hfpxaqsxoqjmcywo")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("inippjdxyeerljbq")
    public suspend fun enableInternetSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetSecurity = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("srwrwkkripjrlfcu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qibykoqqwqyrierd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to the remote virtual network.
     */
    @JvmName("qyurcxfvtqkeeqqp")
    public suspend fun remoteVirtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param argument Reference to the remote virtual network.
     */
    @JvmName("gyjdrgynfbmhjywo")
    public suspend fun remoteVirtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param value The resource group name of the HubVirtualNetworkConnection.
     */
    @JvmName("xrvumiwyeoslidhf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("xotqthfxvgytujcp")
    public suspend fun routingConfiguration(`value`: RoutingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfiguration = mapped
    }

    /**
     * @param argument The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("bxbegsoeqgqpnriy")
    public suspend
    fun routingConfiguration(argument: suspend RoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfiguration = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("ljrxtjpiytlugdnw")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): HubVirtualNetworkConnectionArgs = HubVirtualNetworkConnectionArgs(
        allowHubToRemoteVnetTransit = allowHubToRemoteVnetTransit,
        allowRemoteVnetToUseHubVnetGateways = allowRemoteVnetToUseHubVnetGateways,
        connectionName = connectionName,
        enableInternetSecurity = enableInternetSecurity,
        id = id,
        name = name,
        remoteVirtualNetwork = remoteVirtualNetwork,
        resourceGroupName = resourceGroupName,
        routingConfiguration = routingConfiguration,
        virtualHubName = virtualHubName,
    )
}
