@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IpAllocation].
 */
@PulumiTagMarker
public class IpAllocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpAllocationArgs = IpAllocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpAllocationArgsBuilder.() -> Unit) {
        val builder = IpAllocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IpAllocation {
        val builtJavaResource = com.pulumi.azurenative.network.IpAllocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpAllocation(builtJavaResource)
    }
}

/**
 * IpAllocation resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create IpAllocation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipAllocation = new AzureNative.Network.IpAllocation("ipAllocation", new()
 *     {
 *         AllocationTags =
 *         {
 *             { "VNetID", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1" },
 *         },
 *         IpAllocationName = "test-ipallocation",
 *         Location = "centraluseuap",
 *         Prefix = "3.2.5.0/24",
 *         ResourceGroupName = "rg1",
 *         Type = "Hypernet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewIpAllocation(ctx, "ipAllocation", &network.IpAllocationArgs{
 * 			AllocationTags: pulumi.StringMap{
 * 				"VNetID": pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1"),
 * 			},
 * 			IpAllocationName:  pulumi.String("test-ipallocation"),
 * 			Location:          pulumi.String("centraluseuap"),
 * 			Prefix:            pulumi.String("3.2.5.0/24"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Type:              pulumi.String("Hypernet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.IpAllocation;
 * import com.pulumi.azurenative.network.IpAllocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipAllocation = new IpAllocation("ipAllocation", IpAllocationArgs.builder()
 *             .allocationTags(Map.of("VNetID", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/HypernetVnet1"))
 *             .ipAllocationName("test-ipallocation")
 *             .location("centraluseuap")
 *             .prefix("3.2.5.0/24")
 *             .resourceGroupName("rg1")
 *             .type("Hypernet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:IpAllocation test-ipallocation /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/IpAllocations/{ipAllocationName}
 * ```
 */
public class IpAllocation internal constructor(
    override val javaResource: com.pulumi.azurenative.network.IpAllocation,
) : KotlinCustomResource(javaResource, IpAllocationMapper) {
    /**
     * IpAllocation tags.
     */
    public val allocationTags: Output<Map<String, String>>?
        get() = javaResource.allocationTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The IPAM allocation ID.
     */
    public val ipamAllocationId: Output<String>?
        get() = javaResource.ipamAllocationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The address prefix for the IpAllocation.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The address prefix length for the IpAllocation.
     */
    public val prefixLength: Output<Int>?
        get() = javaResource.prefixLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The address prefix Type for the IpAllocation.
     */
    public val prefixType: Output<String>?
        get() = javaResource.prefixType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Subnet that using the prefix of this IpAllocation resource.
     */
    public val subnet: Output<SubResourceResponse>
        get() = javaResource.subnet().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VirtualNetwork that using the prefix of this IpAllocation resource.
     */
    public val virtualNetwork: Output<SubResourceResponse>
        get() = javaResource.virtualNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object IpAllocationMapper : ResourceMapper<IpAllocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.IpAllocation::class == javaResource::class

    override fun map(javaResource: Resource): IpAllocation = IpAllocation(
        javaResource as
            com.pulumi.azurenative.network.IpAllocation,
    )
}

/**
 * @see [IpAllocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpAllocation].
 */
public suspend fun ipAllocation(
    name: String,
    block: suspend IpAllocationResourceBuilder.() -> Unit,
): IpAllocation {
    val builder = IpAllocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpAllocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipAllocation(name: String): IpAllocation {
    val builder = IpAllocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
