@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin as addressSpaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin as bgpSettingsResponseToKotlin

/**
 * Builder for [LocalNetworkGateway].
 */
@PulumiTagMarker
public class LocalNetworkGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocalNetworkGatewayArgs = LocalNetworkGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocalNetworkGatewayArgsBuilder.() -> Unit) {
        val builder = LocalNetworkGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LocalNetworkGateway {
        val builtJavaResource =
            com.pulumi.azurenative.network.LocalNetworkGateway(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LocalNetworkGateway(builtJavaResource)
    }
}

/**
 * A common class for general resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-06-01, 2016-09-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### CreateLocalNetworkGateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localNetworkGateway = new AzureNative.Network.LocalNetworkGateway("localNetworkGateway", new()
 *     {
 *         Fqdn = "site1.contoso.com",
 *         GatewayIpAddress = "11.12.13.14",
 *         LocalNetworkAddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.1.0.0/16",
 *             },
 *         },
 *         LocalNetworkGatewayName = "localgw",
 *         Location = "Central US",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLocalNetworkGateway(ctx, "localNetworkGateway", &network.LocalNetworkGatewayArgs{
 * 			Fqdn:             pulumi.String("site1.contoso.com"),
 * 			GatewayIpAddress: pulumi.String("11.12.13.14"),
 * 			LocalNetworkAddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.1.0.0/16"),
 * 				},
 * 			},
 * 			LocalNetworkGatewayName: pulumi.String("localgw"),
 * 			Location:                pulumi.String("Central US"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LocalNetworkGateway;
 * import com.pulumi.azurenative.network.LocalNetworkGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localNetworkGateway = new LocalNetworkGateway("localNetworkGateway", LocalNetworkGatewayArgs.builder()
 *             .fqdn("site1.contoso.com")
 *             .gatewayIpAddress("11.12.13.14")
 *             .localNetworkAddressSpace(Map.of("addressPrefixes", "10.1.0.0/16"))
 *             .localNetworkGatewayName("localgw")
 *             .location("Central US")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LocalNetworkGateway localgw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}
 * ```
 */
public class LocalNetworkGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.network.LocalNetworkGateway,
) : KotlinCustomResource(javaResource, LocalNetworkGatewayMapper) {
    /**
     * Local network gateway's BGP speaker settings.
     */
    public val bgpSettings: Output<BgpSettingsResponse>?
        get() = javaResource.bgpSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bgpSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * FQDN of local network gateway.
     */
    public val fqdn: Output<String>?
        get() = javaResource.fqdn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IP address of local network gateway.
     */
    public val gatewayIpAddress: Output<String>?
        get() = javaResource.gatewayIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Local network site address space.
     */
    public val localNetworkAddressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.localNetworkAddressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> addressSpaceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the local network gateway resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the local network gateway resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LocalNetworkGatewayMapper : ResourceMapper<LocalNetworkGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.LocalNetworkGateway::class == javaResource::class

    override fun map(javaResource: Resource): LocalNetworkGateway = LocalNetworkGateway(
        javaResource
            as com.pulumi.azurenative.network.LocalNetworkGateway,
    )
}

/**
 * @see [LocalNetworkGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocalNetworkGateway].
 */
public suspend fun localNetworkGateway(
    name: String,
    block: suspend LocalNetworkGatewayResourceBuilder.() -> Unit,
): LocalNetworkGateway {
    val builder = LocalNetworkGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocalNetworkGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun localNetworkGateway(name: String): LocalNetworkGateway {
    val builder = LocalNetworkGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
