@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.LocalNetworkGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A common class for general resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-06-01, 2016-09-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### CreateLocalNetworkGateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localNetworkGateway = new AzureNative.Network.LocalNetworkGateway("localNetworkGateway", new()
 *     {
 *         Fqdn = "site1.contoso.com",
 *         GatewayIpAddress = "11.12.13.14",
 *         LocalNetworkAddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.1.0.0/16",
 *             },
 *         },
 *         LocalNetworkGatewayName = "localgw",
 *         Location = "Central US",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLocalNetworkGateway(ctx, "localNetworkGateway", &network.LocalNetworkGatewayArgs{
 * 			Fqdn:             pulumi.String("site1.contoso.com"),
 * 			GatewayIpAddress: pulumi.String("11.12.13.14"),
 * 			LocalNetworkAddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.1.0.0/16"),
 * 				},
 * 			},
 * 			LocalNetworkGatewayName: pulumi.String("localgw"),
 * 			Location:                pulumi.String("Central US"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LocalNetworkGateway;
 * import com.pulumi.azurenative.network.LocalNetworkGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localNetworkGateway = new LocalNetworkGateway("localNetworkGateway", LocalNetworkGatewayArgs.builder()
 *             .fqdn("site1.contoso.com")
 *             .gatewayIpAddress("11.12.13.14")
 *             .localNetworkAddressSpace(Map.of("addressPrefixes", "10.1.0.0/16"))
 *             .localNetworkGatewayName("localgw")
 *             .location("Central US")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LocalNetworkGateway localgw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/localNetworkGateways/{localNetworkGatewayName}
 * ```
 * @property bgpSettings Local network gateway's BGP speaker settings.
 * @property fqdn FQDN of local network gateway.
 * @property gatewayIpAddress IP address of local network gateway.
 * @property id Resource ID.
 * @property localNetworkAddressSpace Local network site address space.
 * @property localNetworkGatewayName The name of the local network gateway.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class LocalNetworkGatewayArgs(
    public val bgpSettings: Output<BgpSettingsArgs>? = null,
    public val fqdn: Output<String>? = null,
    public val gatewayIpAddress: Output<String>? = null,
    public val id: Output<String>? = null,
    public val localNetworkAddressSpace: Output<AddressSpaceArgs>? = null,
    public val localNetworkGatewayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.LocalNetworkGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.LocalNetworkGatewayArgs =
        com.pulumi.azurenative.network.LocalNetworkGatewayArgs.builder()
            .bgpSettings(bgpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdn(fqdn?.applyValue({ args0 -> args0 }))
            .gatewayIpAddress(gatewayIpAddress?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .localNetworkAddressSpace(
                localNetworkAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .localNetworkGatewayName(localNetworkGatewayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LocalNetworkGatewayArgs].
 */
@PulumiTagMarker
public class LocalNetworkGatewayArgsBuilder internal constructor() {
    private var bgpSettings: Output<BgpSettingsArgs>? = null

    private var fqdn: Output<String>? = null

    private var gatewayIpAddress: Output<String>? = null

    private var id: Output<String>? = null

    private var localNetworkAddressSpace: Output<AddressSpaceArgs>? = null

    private var localNetworkGatewayName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Local network gateway's BGP speaker settings.
     */
    @JvmName("jwtyuadfatefmuds")
    public suspend fun bgpSettings(`value`: Output<BgpSettingsArgs>) {
        this.bgpSettings = value
    }

    /**
     * @param value FQDN of local network gateway.
     */
    @JvmName("cwplfeadutcytmse")
    public suspend fun fqdn(`value`: Output<String>) {
        this.fqdn = value
    }

    /**
     * @param value IP address of local network gateway.
     */
    @JvmName("bhgbikiuwrwqcjhq")
    public suspend fun gatewayIpAddress(`value`: Output<String>) {
        this.gatewayIpAddress = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ghyxwylgtmheylep")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Local network site address space.
     */
    @JvmName("qqtqjaqbegtwlqqx")
    public suspend fun localNetworkAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.localNetworkAddressSpace = value
    }

    /**
     * @param value The name of the local network gateway.
     */
    @JvmName("umnwedutugmllxca")
    public suspend fun localNetworkGatewayName(`value`: Output<String>) {
        this.localNetworkGatewayName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ovybuniufhhhdfkh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gwsueompaqopnocu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rvytlmwauwpnlroi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Local network gateway's BGP speaker settings.
     */
    @JvmName("emeutqmjdaxyajax")
    public suspend fun bgpSettings(`value`: BgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSettings = mapped
    }

    /**
     * @param argument Local network gateway's BGP speaker settings.
     */
    @JvmName("rytouylsnmnwjafr")
    public suspend fun bgpSettings(argument: suspend BgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSettings = mapped
    }

    /**
     * @param value FQDN of local network gateway.
     */
    @JvmName("uvvliytwvaxoktiy")
    public suspend fun fqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdn = mapped
    }

    /**
     * @param value IP address of local network gateway.
     */
    @JvmName("lunjbctfgujywvkt")
    public suspend fun gatewayIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayIpAddress = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tdysdvyutgugjkfm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Local network site address space.
     */
    @JvmName("lhldsfvtabgilpkj")
    public suspend fun localNetworkAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localNetworkAddressSpace = mapped
    }

    /**
     * @param argument Local network site address space.
     */
    @JvmName("nvcbumdjquqxgqmy")
    public suspend
    fun localNetworkAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localNetworkAddressSpace = mapped
    }

    /**
     * @param value The name of the local network gateway.
     */
    @JvmName("pejlpodnvixaumsk")
    public suspend fun localNetworkGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localNetworkGatewayName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qbcnlexgbyipddmc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vcpnwjkyjkcrjepr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("elutiwepciolntnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("stsnwqfilacincef")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LocalNetworkGatewayArgs = LocalNetworkGatewayArgs(
        bgpSettings = bgpSettings,
        fqdn = fqdn,
        gatewayIpAddress = gatewayIpAddress,
        id = id,
        localNetworkAddressSpace = localNetworkAddressSpace,
        localNetworkGatewayName = localNetworkGatewayName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
