@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NatGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.NatGatewaySkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.NatGatewaySkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Nat Gateway resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create nat gateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var natGateway = new AzureNative.Network.NatGateway("natGateway", new()
 *     {
 *         Location = "westus",
 *         NatGatewayName = "test-natgateway",
 *         PublicIpAddresses = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/PublicIpAddress1",
 *             },
 *         },
 *         PublicIpPrefixes = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPPrefixes/PublicIpPrefix1",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.NatGatewaySkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNatGateway(ctx, "natGateway", &network.NatGatewayArgs{
 * 			Location:       pulumi.String("westus"),
 * 			NatGatewayName: pulumi.String("test-natgateway"),
 * 			PublicIpAddresses: []network.SubResourceArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/PublicIpAddress1"),
 * 				},
 * 			},
 * 			PublicIpPrefixes: []network.SubResourceArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPPrefixes/PublicIpPrefix1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.NatGatewaySkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NatGateway;
 * import com.pulumi.azurenative.network.NatGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var natGateway = new NatGateway("natGateway", NatGatewayArgs.builder()
 *             .location("westus")
 *             .natGatewayName("test-natgateway")
 *             .publicIpAddresses(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/PublicIpAddress1"))
 *             .publicIpPrefixes(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPPrefixes/PublicIpPrefix1"))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NatGateway test-natGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}
 * ```
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The idle timeout of the nat gateway.
 * @property location Resource location.
 * @property natGatewayName The name of the nat gateway.
 * @property publicIpAddresses An array of public ip addresses associated with the nat gateway resource.
 * @property publicIpPrefixes An array of public ip prefixes associated with the nat gateway resource.
 * @property resourceGroupName The name of the resource group.
 * @property sku The nat gateway SKU.
 * @property tags Resource tags.
 * @property zones A list of availability zones denoting the zone in which Nat Gateway should be deployed.
 */
public data class NatGatewayArgs(
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val location: Output<String>? = null,
    public val natGatewayName: Output<String>? = null,
    public val publicIpAddresses: Output<List<SubResourceArgs>>? = null,
    public val publicIpPrefixes: Output<List<SubResourceArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<NatGatewaySkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NatGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NatGatewayArgs =
        com.pulumi.azurenative.network.NatGatewayArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .natGatewayName(natGatewayName?.applyValue({ args0 -> args0 }))
            .publicIpAddresses(
                publicIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicIpPrefixes(
                publicIpPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NatGatewayArgs].
 */
@PulumiTagMarker
public class NatGatewayArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var location: Output<String>? = null

    private var natGatewayName: Output<String>? = null

    private var publicIpAddresses: Output<List<SubResourceArgs>>? = null

    private var publicIpPrefixes: Output<List<SubResourceArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<NatGatewaySkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("qniicchqxhpkbvye")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The idle timeout of the nat gateway.
     */
    @JvmName("sbnansgdduipqvce")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("iouuinywbsnbfurn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the nat gateway.
     */
    @JvmName("rmxwtbsgxcxrhtob")
    public suspend fun natGatewayName(`value`: Output<String>) {
        this.natGatewayName = value
    }

    /**
     * @param value An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("uxgbifsysfwbtjrv")
    public suspend fun publicIpAddresses(`value`: Output<List<SubResourceArgs>>) {
        this.publicIpAddresses = value
    }

    @JvmName("bxgajycgtqfeuiyo")
    public suspend fun publicIpAddresses(vararg values: Output<SubResourceArgs>) {
        this.publicIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("xnxgubjvdvubusct")
    public suspend fun publicIpAddresses(values: List<Output<SubResourceArgs>>) {
        this.publicIpAddresses = Output.all(values)
    }

    /**
     * @param value An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("phqfcudckhpjbgto")
    public suspend fun publicIpPrefixes(`value`: Output<List<SubResourceArgs>>) {
        this.publicIpPrefixes = value
    }

    @JvmName("adndkxyhikwxwthb")
    public suspend fun publicIpPrefixes(vararg values: Output<SubResourceArgs>) {
        this.publicIpPrefixes = Output.all(values.asList())
    }

    /**
     * @param values An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("ndaxwngapwpputin")
    public suspend fun publicIpPrefixes(values: List<Output<SubResourceArgs>>) {
        this.publicIpPrefixes = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fyjtlffeqmxqfgja")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The nat gateway SKU.
     */
    @JvmName("fwmnmvfvnmnhlbws")
    public suspend fun sku(`value`: Output<NatGatewaySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kngfipvvrjgqucdr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("worsrpurevbhsaqn")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("afmhjuakpatcuwbe")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("lxnilrmrashsksyp")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("twjmivasreflrjpb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The idle timeout of the nat gateway.
     */
    @JvmName("ibeylwgdfavohnje")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gafuvqyjyrsqluag")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the nat gateway.
     */
    @JvmName("jxvvnfwwardyjfbv")
    public suspend fun natGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayName = mapped
    }

    /**
     * @param value An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("bounnkcijloompnq")
    public suspend fun publicIpAddresses(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpAddresses = mapped
    }

    /**
     * @param argument An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("bktnilbghfsxmcpt")
    public suspend fun publicIpAddresses(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpAddresses = mapped
    }

    /**
     * @param argument An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("acjtssckwdyukffn")
    public suspend fun publicIpAddresses(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpAddresses = mapped
    }

    /**
     * @param argument An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("dmdmgnncymklwwcr")
    public suspend fun publicIpAddresses(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIpAddresses = mapped
    }

    /**
     * @param values An array of public ip addresses associated with the nat gateway resource.
     */
    @JvmName("eitefpxwmywadgkj")
    public suspend fun publicIpAddresses(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIpAddresses = mapped
    }

    /**
     * @param value An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("krumaqdkunpqdgse")
    public suspend fun publicIpPrefixes(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpPrefixes = mapped
    }

    /**
     * @param argument An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("ujeksdipcgdehkwc")
    public suspend fun publicIpPrefixes(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpPrefixes = mapped
    }

    /**
     * @param argument An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("qspllekgpgxwuwwh")
    public suspend fun publicIpPrefixes(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIpPrefixes = mapped
    }

    /**
     * @param argument An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("ykgnwgbfypombock")
    public suspend fun publicIpPrefixes(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIpPrefixes = mapped
    }

    /**
     * @param values An array of public ip prefixes associated with the nat gateway resource.
     */
    @JvmName("byvflxsjpeysmrfx")
    public suspend fun publicIpPrefixes(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIpPrefixes = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("npdnbasdgsjthaiq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The nat gateway SKU.
     */
    @JvmName("gbfvnwqanigxxkco")
    public suspend fun sku(`value`: NatGatewaySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The nat gateway SKU.
     */
    @JvmName("jcmcrqoabglgkxky")
    public suspend fun sku(argument: suspend NatGatewaySkuArgsBuilder.() -> Unit) {
        val toBeMapped = NatGatewaySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fgfghqtxasfwevew")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hjgrjcpuuskpiukl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("fmtyvjnmagqqmspm")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the zone in which Nat Gateway should be deployed.
     */
    @JvmName("qnugxnhhmcwldcqx")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): NatGatewayArgs = NatGatewayArgs(
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        location = location,
        natGatewayName = natGatewayName,
        publicIpAddresses = publicIpAddresses,
        publicIpPrefixes = publicIpPrefixes,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
