@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerPropertiesResponseNetworkManagerScopes
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerPropertiesResponseNetworkManagerScopes.Companion.toKotlin as networkManagerPropertiesResponseNetworkManagerScopesToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NetworkManager].
 */
@PulumiTagMarker
public class NetworkManagerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkManagerArgs = NetworkManagerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkManagerArgsBuilder.() -> Unit) {
        val builder = NetworkManagerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkManager {
        val builtJavaResource = com.pulumi.azurenative.network.NetworkManager(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkManager(builtJavaResource)
    }
}

/**
 * The Managed Network resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Put Network Manager
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkManager = new AzureNative.Network.NetworkManager("networkManager", new()
 *     {
 *         Description = "My Test Network Manager",
 *         NetworkManagerName = "TestNetworkManager",
 *         NetworkManagerScopeAccesses = new[]
 *         {
 *             "Connectivity",
 *         },
 *         NetworkManagerScopes = new AzureNative.Network.Inputs.NetworkManagerPropertiesNetworkManagerScopesArgs
 *         {
 *             ManagementGroups = new[]
 *             {
 *                 "/providers/Microsoft.Management/managementGroups/sampleMG",
 *             },
 *             Subscriptions = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkManager(ctx, "networkManager", &network.NetworkManagerArgs{
 * 			Description:        pulumi.String("My Test Network Manager"),
 * 			NetworkManagerName: pulumi.String("TestNetworkManager"),
 * 			NetworkManagerScopeAccesses: pulumi.StringArray{
 * 				pulumi.String("Connectivity"),
 * 			},
 * 			NetworkManagerScopes: &network.NetworkManagerPropertiesNetworkManagerScopesArgs{
 * 				ManagementGroups: pulumi.StringArray{
 * 					pulumi.String("/providers/Microsoft.Management/managementGroups/sampleMG"),
 * 				},
 * 				Subscriptions: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkManager;
 * import com.pulumi.azurenative.network.NetworkManagerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkManager = new NetworkManager("networkManager", NetworkManagerArgs.builder()
 *             .description("My Test Network Manager")
 *             .networkManagerName("TestNetworkManager")
 *             .networkManagerScopeAccesses("Connectivity")
 *             .networkManagerScopes(Map.ofEntries(
 *                 Map.entry("managementGroups", "/providers/Microsoft.Management/managementGroups/sampleMG"),
 *                 Map.entry("subscriptions", "/subscriptions/00000000-0000-0000-0000-000000000000")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkManager TestNetworkManager /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}
 * ```
 */
public class NetworkManager internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkManager,
) : KotlinCustomResource(javaResource, NetworkManagerMapper) {
    /**
     * A description of the network manager.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Scope Access.
     */
    public val networkManagerScopeAccesses: Output<List<String>>
        get() = javaResource.networkManagerScopeAccesses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Scope of Network Manager.
     */
    public val networkManagerScopes: Output<NetworkManagerPropertiesResponseNetworkManagerScopes>
        get() = javaResource.networkManagerScopes().applyValue({ args0 ->
            args0.let({ args0 ->
                networkManagerPropertiesResponseNetworkManagerScopesToKotlin(args0)
            })
        })

    /**
     * The provisioning state of the network manager resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for this resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkManagerMapper : ResourceMapper<NetworkManager> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkManager::class == javaResource::class

    override fun map(javaResource: Resource): NetworkManager = NetworkManager(
        javaResource as
            com.pulumi.azurenative.network.NetworkManager,
    )
}

/**
 * @see [NetworkManager].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkManager].
 */
public suspend fun networkManager(
    name: String,
    block: suspend NetworkManagerResourceBuilder.() -> Unit,
): NetworkManager {
    val builder = NetworkManagerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkManager].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkManager(name: String): NetworkManager {
    val builder = NetworkManagerResourceBuilder()
    builder.name(name)
    return builder.build()
}
