@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkProfileArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ContainerNetworkInterfaceConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ContainerNetworkInterfaceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network profile resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create network profile defaults
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkProfile = new AzureNative.Network.NetworkProfile("networkProfile", new()
 *     {
 *         ContainerNetworkInterfaceConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.ContainerNetworkInterfaceConfigurationArgs
 *             {
 *                 IpConfigurations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.IPConfigurationProfileArgs
 *                     {
 *                         Name = "ipconfig1",
 *                         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/networkProfileVnet/subnets/networkProfileSubnet1",
 *                         },
 *                     },
 *                 },
 *                 Name = "eth1",
 *             },
 *         },
 *         Location = "westus",
 *         NetworkProfileName = "networkProfile1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkProfile(ctx, "networkProfile", &network.NetworkProfileArgs{
 * 			ContainerNetworkInterfaceConfigurations: []network.ContainerNetworkInterfaceConfigurationArgs{
 * 				{
 * 					IpConfigurations: network.IPConfigurationProfileArray{
 * 						{
 * 							Name: pulumi.String("ipconfig1"),
 * 							Subnet: {
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/networkProfileVnet/subnets/networkProfileSubnet1"),
 * 							},
 * 						},
 * 					},
 * 					Name: pulumi.String("eth1"),
 * 				},
 * 			},
 * 			Location:           pulumi.String("westus"),
 * 			NetworkProfileName: pulumi.String("networkProfile1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkProfile;
 * import com.pulumi.azurenative.network.NetworkProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkProfile = new NetworkProfile("networkProfile", NetworkProfileArgs.builder()
 *             .containerNetworkInterfaceConfigurations(Map.ofEntries(
 *                 Map.entry("ipConfigurations", Map.ofEntries(
 *                     Map.entry("name", "ipconfig1"),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/networkProfileVnet/subnets/networkProfileSubnet1"))
 *                 )),
 *                 Map.entry("name", "eth1")
 *             ))
 *             .location("westus")
 *             .networkProfileName("networkProfile1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkProfile networkProfile1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkProfiles/{networkProfileName}
 * ```
 * @property containerNetworkInterfaceConfigurations List of chid container network interface configurations.
 * @property id Resource ID.
 * @property location Resource location.
 * @property networkProfileName The name of the network profile.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class NetworkProfileArgs(
    public val containerNetworkInterfaceConfigurations:
    Output<List<ContainerNetworkInterfaceConfigurationArgs>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkProfileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkProfileArgs =
        com.pulumi.azurenative.network.NetworkProfileArgs.builder()
            .containerNetworkInterfaceConfigurations(
                containerNetworkInterfaceConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfileName(networkProfileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var containerNetworkInterfaceConfigurations:
        Output<List<ContainerNetworkInterfaceConfigurationArgs>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var networkProfileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of chid container network interface configurations.
     */
    @JvmName("iqckmfymmpmpoehv")
    public suspend
    fun containerNetworkInterfaceConfigurations(`value`: Output<List<ContainerNetworkInterfaceConfigurationArgs>>) {
        this.containerNetworkInterfaceConfigurations = value
    }

    @JvmName("pdjfrktwhdovexcx")
    public suspend fun containerNetworkInterfaceConfigurations(
        vararg
        values: Output<ContainerNetworkInterfaceConfigurationArgs>,
    ) {
        this.containerNetworkInterfaceConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of chid container network interface configurations.
     */
    @JvmName("qkpfbqknbxjgvvrn")
    public suspend
    fun containerNetworkInterfaceConfigurations(values: List<Output<ContainerNetworkInterfaceConfigurationArgs>>) {
        this.containerNetworkInterfaceConfigurations = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vchksptdbuvrvwme")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jpyufcvonblmlctg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the network profile.
     */
    @JvmName("sqswwjlfyqlkfywc")
    public suspend fun networkProfileName(`value`: Output<String>) {
        this.networkProfileName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("goumxmbfdgexyuhm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jibgrcxnloptwkgc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of chid container network interface configurations.
     */
    @JvmName("fdnfnhlhykotapht")
    public suspend
    fun containerNetworkInterfaceConfigurations(`value`: List<ContainerNetworkInterfaceConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerNetworkInterfaceConfigurations = mapped
    }

    /**
     * @param argument List of chid container network interface configurations.
     */
    @JvmName("valivarnvshhodml")
    public suspend
    fun containerNetworkInterfaceConfigurations(argument: List<suspend ContainerNetworkInterfaceConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerNetworkInterfaceConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaceConfigurations = mapped
    }

    /**
     * @param argument List of chid container network interface configurations.
     */
    @JvmName("nighudtafaaqagpv")
    public suspend fun containerNetworkInterfaceConfigurations(
        vararg
        argument: suspend ContainerNetworkInterfaceConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerNetworkInterfaceConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaceConfigurations = mapped
    }

    /**
     * @param argument List of chid container network interface configurations.
     */
    @JvmName("mshcbwtifddoqpya")
    public suspend
    fun containerNetworkInterfaceConfigurations(argument: suspend ContainerNetworkInterfaceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerNetworkInterfaceConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaceConfigurations = mapped
    }

    /**
     * @param values List of chid container network interface configurations.
     */
    @JvmName("urstxeeuvnrhtrgu")
    public suspend fun containerNetworkInterfaceConfigurations(
        vararg
        values: ContainerNetworkInterfaceConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerNetworkInterfaceConfigurations = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jfxhijdecfkerric")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tdbrwjjksygtwkjm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the network profile.
     */
    @JvmName("yckbfxkcmscoqmuw")
    public suspend fun networkProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fgqwlwnhnidlnxlp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("npjnntijbrgcmrtn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("twrnlvhajgecnwej")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        containerNetworkInterfaceConfigurations = containerNetworkInterfaceConfigurations,
        id = id,
        location = location,
        networkProfileName = networkProfileName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
