@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkSecurityPerimeterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Network Security Perimeter resource
 * Azure REST API version: 2021-03-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-02-01-preview, 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Put Network Security Perimeter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkSecurityPerimeter = new AzureNative.Network.NetworkSecurityPerimeter("networkSecurityPerimeter", new()
 *     {
 *         Description = "Description of TestNetworkSecurityPerimeter",
 *         DisplayName = "TestNetworkSecurityPerimeter",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkSecurityPerimeter(ctx, "networkSecurityPerimeter", &network.NetworkSecurityPerimeterArgs{
 * 			Description:                  pulumi.String("Description of TestNetworkSecurityPerimeter"),
 * 			DisplayName:                  pulumi.String("TestNetworkSecurityPerimeter"),
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			ResourceGroupName:            pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkSecurityPerimeter;
 * import com.pulumi.azurenative.network.NetworkSecurityPerimeterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkSecurityPerimeter = new NetworkSecurityPerimeter("networkSecurityPerimeter", NetworkSecurityPerimeterArgs.builder()
 *             .description("Description of TestNetworkSecurityPerimeter")
 *             .displayName("TestNetworkSecurityPerimeter")
 *             .networkSecurityPerimeterName("nsp1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkSecurityPerimeter TestNetworkSecurityPerimeter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}
 * ```
 * @property description A description of the network security perimeter.
 * @property displayName A friendly name for the network security perimeter.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 */
public data class NetworkSecurityPerimeterArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSecurityPerimeterName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkSecurityPerimeterArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkSecurityPerimeterArgs =
        com.pulumi.azurenative.network.NetworkSecurityPerimeterArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkSecurityPerimeterArgs].
 */
@PulumiTagMarker
public class NetworkSecurityPerimeterArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSecurityPerimeterName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the network security perimeter.
     */
    @JvmName("rdxkjplhabfnehqm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A friendly name for the network security perimeter.
     */
    @JvmName("tswycbmeakyggwgt")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("plqudlrbvnnkgrxd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("hgxnpaekteelsmsw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ytgsavjghuoosxka")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("cwxlfejlasdjckeh")
    public suspend fun networkSecurityPerimeterName(`value`: Output<String>) {
        this.networkSecurityPerimeterName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ppschcmugsiqgmnn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("utxhktixljinrrjx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the network security perimeter.
     */
    @JvmName("uexsjsqsmsvtcfbh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A friendly name for the network security perimeter.
     */
    @JvmName("wnxkqgsonrwjjvcr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("aatkfdwjxyqwfwrh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("olvbeapcuxmvalgc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ssdlhtddfavsyyix")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("grcxjpnkabjbguhx")
    public suspend fun networkSecurityPerimeterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sjiopwmreytrovse")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ospfwlbccpwrpbfr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xbcqcybqjtjghpxp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkSecurityPerimeterArgs = NetworkSecurityPerimeterArgs(
        description = description,
        displayName = displayName,
        id = id,
        location = location,
        name = name,
        networkSecurityPerimeterName = networkSecurityPerimeterName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
