@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.NetworkVirtualApplianceArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.DelegationPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.DelegationPropertiesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualApplianceAdditionalNicPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualApplianceAdditionalNicPropertiesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualApplianceSkuPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualApplianceSkuPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * NetworkVirtualAppliance Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2020-04-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create SaaS NetworkVirtualAppliance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkVirtualAppliance = new AzureNative.Network.NetworkVirtualAppliance("networkVirtualAppliance", new()
 *     {
 *         Delegation = new AzureNative.Network.Inputs.DelegationPropertiesArgs
 *         {
 *             ServiceName = "PaloAltoNetworks.Cloudngfw/firewalls",
 *         },
 *         Location = "West US",
 *         NetworkVirtualApplianceName = "nva",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkVirtualAppliance(ctx, "networkVirtualAppliance", &network.NetworkVirtualApplianceArgs{
 * 			Delegation: &network.DelegationPropertiesArgs{
 * 				ServiceName: pulumi.String("PaloAltoNetworks.Cloudngfw/firewalls"),
 * 			},
 * 			Location:                    pulumi.String("West US"),
 * 			NetworkVirtualApplianceName: pulumi.String("nva"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkVirtualAppliance;
 * import com.pulumi.azurenative.network.NetworkVirtualApplianceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkVirtualAppliance = new NetworkVirtualAppliance("networkVirtualAppliance", NetworkVirtualApplianceArgs.builder()
 *             .delegation(Map.of("serviceName", "PaloAltoNetworks.Cloudngfw/firewalls"))
 *             .location("West US")
 *             .networkVirtualApplianceName("nva")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkVirtualAppliance nva /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}
 * ```
 * @property additionalNics Details required for Additional Network Interface.
 * @property bootStrapConfigurationBlobs BootStrapConfigurationBlobs storage URLs.
 * @property cloudInitConfiguration CloudInitConfiguration string in plain text.
 * @property cloudInitConfigurationBlobs CloudInitConfigurationBlob storage URLs.
 * @property delegation The delegation for the Virtual Appliance
 * @property id Resource ID.
 * @property identity The service principal that has read access to cloud-init and config blob.
 * @property location Resource location.
 * @property networkVirtualApplianceName The name of Network Virtual Appliance.
 * @property nvaSku Network Virtual Appliance SKU.
 * @property resourceGroupName The name of the resource group.
 * @property sshPublicKey Public key for SSH login.
 * @property tags Resource tags.
 * @property virtualApplianceAsn VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported.
 * @property virtualHub The Virtual Hub where Network Virtual Appliance is being deployed.
 */
public data class NetworkVirtualApplianceArgs(
    public val additionalNics: Output<List<VirtualApplianceAdditionalNicPropertiesArgs>>? = null,
    public val bootStrapConfigurationBlobs: Output<List<String>>? = null,
    public val cloudInitConfiguration: Output<String>? = null,
    public val cloudInitConfigurationBlobs: Output<List<String>>? = null,
    public val delegation: Output<DelegationPropertiesArgs>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val networkVirtualApplianceName: Output<String>? = null,
    public val nvaSku: Output<VirtualApplianceSkuPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sshPublicKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualApplianceAsn: Output<Double>? = null,
    public val virtualHub: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.NetworkVirtualApplianceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.NetworkVirtualApplianceArgs =
        com.pulumi.azurenative.network.NetworkVirtualApplianceArgs.builder()
            .additionalNics(
                additionalNics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bootStrapConfigurationBlobs(
                bootStrapConfigurationBlobs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .cloudInitConfiguration(cloudInitConfiguration?.applyValue({ args0 -> args0 }))
            .cloudInitConfigurationBlobs(
                cloudInitConfigurationBlobs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .delegation(delegation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkVirtualApplianceName(networkVirtualApplianceName?.applyValue({ args0 -> args0 }))
            .nvaSku(nvaSku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sshPublicKey(sshPublicKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualApplianceAsn(virtualApplianceAsn?.applyValue({ args0 -> args0 }))
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NetworkVirtualApplianceArgs].
 */
@PulumiTagMarker
public class NetworkVirtualApplianceArgsBuilder internal constructor() {
    private var additionalNics: Output<List<VirtualApplianceAdditionalNicPropertiesArgs>>? = null

    private var bootStrapConfigurationBlobs: Output<List<String>>? = null

    private var cloudInitConfiguration: Output<String>? = null

    private var cloudInitConfigurationBlobs: Output<List<String>>? = null

    private var delegation: Output<DelegationPropertiesArgs>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var networkVirtualApplianceName: Output<String>? = null

    private var nvaSku: Output<VirtualApplianceSkuPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sshPublicKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualApplianceAsn: Output<Double>? = null

    private var virtualHub: Output<SubResourceArgs>? = null

    /**
     * @param value Details required for Additional Network Interface.
     */
    @JvmName("aylwfoiiarsusrxd")
    public suspend
    fun additionalNics(`value`: Output<List<VirtualApplianceAdditionalNicPropertiesArgs>>) {
        this.additionalNics = value
    }

    @JvmName("rpasedsjdhrhdhhx")
    public suspend fun additionalNics(
        vararg
        values: Output<VirtualApplianceAdditionalNicPropertiesArgs>,
    ) {
        this.additionalNics = Output.all(values.asList())
    }

    /**
     * @param values Details required for Additional Network Interface.
     */
    @JvmName("syaoupnmlwuwqmrv")
    public suspend
    fun additionalNics(values: List<Output<VirtualApplianceAdditionalNicPropertiesArgs>>) {
        this.additionalNics = Output.all(values)
    }

    /**
     * @param value BootStrapConfigurationBlobs storage URLs.
     */
    @JvmName("ahrepuxseogddssm")
    public suspend fun bootStrapConfigurationBlobs(`value`: Output<List<String>>) {
        this.bootStrapConfigurationBlobs = value
    }

    @JvmName("nhqwjhhkgtuarlld")
    public suspend fun bootStrapConfigurationBlobs(vararg values: Output<String>) {
        this.bootStrapConfigurationBlobs = Output.all(values.asList())
    }

    /**
     * @param values BootStrapConfigurationBlobs storage URLs.
     */
    @JvmName("uwqxeixejxmvxldt")
    public suspend fun bootStrapConfigurationBlobs(values: List<Output<String>>) {
        this.bootStrapConfigurationBlobs = Output.all(values)
    }

    /**
     * @param value CloudInitConfiguration string in plain text.
     */
    @JvmName("irqdlmmxymscmoyy")
    public suspend fun cloudInitConfiguration(`value`: Output<String>) {
        this.cloudInitConfiguration = value
    }

    /**
     * @param value CloudInitConfigurationBlob storage URLs.
     */
    @JvmName("iddamjyoshoxqmhf")
    public suspend fun cloudInitConfigurationBlobs(`value`: Output<List<String>>) {
        this.cloudInitConfigurationBlobs = value
    }

    @JvmName("rlxqqbopqgvflfsx")
    public suspend fun cloudInitConfigurationBlobs(vararg values: Output<String>) {
        this.cloudInitConfigurationBlobs = Output.all(values.asList())
    }

    /**
     * @param values CloudInitConfigurationBlob storage URLs.
     */
    @JvmName("gbuwkfgpsgsvfbyw")
    public suspend fun cloudInitConfigurationBlobs(values: List<Output<String>>) {
        this.cloudInitConfigurationBlobs = Output.all(values)
    }

    /**
     * @param value The delegation for the Virtual Appliance
     */
    @JvmName("xekwvnljhkshjisi")
    public suspend fun delegation(`value`: Output<DelegationPropertiesArgs>) {
        this.delegation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jsssbcpoqrdmtlvp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The service principal that has read access to cloud-init and config blob.
     */
    @JvmName("abxkdgwimwlgfhfc")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("inykvqslygpfnjyj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of Network Virtual Appliance.
     */
    @JvmName("fypdyxlsplctnjsi")
    public suspend fun networkVirtualApplianceName(`value`: Output<String>) {
        this.networkVirtualApplianceName = value
    }

    /**
     * @param value Network Virtual Appliance SKU.
     */
    @JvmName("igdppeqvjktmmixm")
    public suspend fun nvaSku(`value`: Output<VirtualApplianceSkuPropertiesArgs>) {
        this.nvaSku = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kaoagftivejxlqlq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Public key for SSH login.
     */
    @JvmName("beidchjcwjxbvlmp")
    public suspend fun sshPublicKey(`value`: Output<String>) {
        this.sshPublicKey = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("meqkacqvodcndyww")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported.
     */
    @JvmName("iakjofjrsikbgwsv")
    public suspend fun virtualApplianceAsn(`value`: Output<Double>) {
        this.virtualApplianceAsn = value
    }

    /**
     * @param value The Virtual Hub where Network Virtual Appliance is being deployed.
     */
    @JvmName("umvkgdkrvlcimtpc")
    public suspend fun virtualHub(`value`: Output<SubResourceArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value Details required for Additional Network Interface.
     */
    @JvmName("jbbnssjysxavhabo")
    public suspend fun additionalNics(`value`: List<VirtualApplianceAdditionalNicPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalNics = mapped
    }

    /**
     * @param argument Details required for Additional Network Interface.
     */
    @JvmName("asncpityeqgkbsxx")
    public suspend
    fun additionalNics(argument: List<suspend VirtualApplianceAdditionalNicPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualApplianceAdditionalNicPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalNics = mapped
    }

    /**
     * @param argument Details required for Additional Network Interface.
     */
    @JvmName("jcrnjcwpusdoosre")
    public suspend fun additionalNics(
        vararg
        argument: suspend VirtualApplianceAdditionalNicPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualApplianceAdditionalNicPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalNics = mapped
    }

    /**
     * @param argument Details required for Additional Network Interface.
     */
    @JvmName("spsqhveblbbppvlm")
    public suspend
    fun additionalNics(argument: suspend VirtualApplianceAdditionalNicPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualApplianceAdditionalNicPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalNics = mapped
    }

    /**
     * @param values Details required for Additional Network Interface.
     */
    @JvmName("dkkjcmdegovlqhkk")
    public suspend fun additionalNics(vararg values: VirtualApplianceAdditionalNicPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalNics = mapped
    }

    /**
     * @param value BootStrapConfigurationBlobs storage URLs.
     */
    @JvmName("kywrsdoauhepjlca")
    public suspend fun bootStrapConfigurationBlobs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootStrapConfigurationBlobs = mapped
    }

    /**
     * @param values BootStrapConfigurationBlobs storage URLs.
     */
    @JvmName("xegmpcfrhdaumnyl")
    public suspend fun bootStrapConfigurationBlobs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bootStrapConfigurationBlobs = mapped
    }

    /**
     * @param value CloudInitConfiguration string in plain text.
     */
    @JvmName("rbvmtkekodtvswfy")
    public suspend fun cloudInitConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudInitConfiguration = mapped
    }

    /**
     * @param value CloudInitConfigurationBlob storage URLs.
     */
    @JvmName("bvfmymnebegixlgk")
    public suspend fun cloudInitConfigurationBlobs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudInitConfigurationBlobs = mapped
    }

    /**
     * @param values CloudInitConfigurationBlob storage URLs.
     */
    @JvmName("nrjsbwewidxlopjx")
    public suspend fun cloudInitConfigurationBlobs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudInitConfigurationBlobs = mapped
    }

    /**
     * @param value The delegation for the Virtual Appliance
     */
    @JvmName("mlrehuhmfsaitixw")
    public suspend fun delegation(`value`: DelegationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegation = mapped
    }

    /**
     * @param argument The delegation for the Virtual Appliance
     */
    @JvmName("idhraabyjnnmeprm")
    public suspend fun delegation(argument: suspend DelegationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DelegationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.delegation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ityjmomtwqoyytxm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The service principal that has read access to cloud-init and config blob.
     */
    @JvmName("vgemanjqqcuqdifv")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The service principal that has read access to cloud-init and config blob.
     */
    @JvmName("jhiwdkbaivgdsqgw")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("stovjosapjaoheqa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of Network Virtual Appliance.
     */
    @JvmName("leibdnjrpiromybq")
    public suspend fun networkVirtualApplianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkVirtualApplianceName = mapped
    }

    /**
     * @param value Network Virtual Appliance SKU.
     */
    @JvmName("ogninmwqkaicvtyo")
    public suspend fun nvaSku(`value`: VirtualApplianceSkuPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nvaSku = mapped
    }

    /**
     * @param argument Network Virtual Appliance SKU.
     */
    @JvmName("gfqddfoghcmolnus")
    public suspend fun nvaSku(argument: suspend VirtualApplianceSkuPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualApplianceSkuPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nvaSku = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ynekuedvfkhllklh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Public key for SSH login.
     */
    @JvmName("yaoyhdcmvnccjwxb")
    public suspend fun sshPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshPublicKey = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ytdnkjyuptxidpmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xropkkngvxnkxowu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported.
     */
    @JvmName("iodjnhqsutikgwbv")
    public suspend fun virtualApplianceAsn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualApplianceAsn = mapped
    }

    /**
     * @param value The Virtual Hub where Network Virtual Appliance is being deployed.
     */
    @JvmName("ctnnqwpqautxtqyv")
    public suspend fun virtualHub(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The Virtual Hub where Network Virtual Appliance is being deployed.
     */
    @JvmName("hcljxwblhxdpawme")
    public suspend fun virtualHub(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    internal fun build(): NetworkVirtualApplianceArgs = NetworkVirtualApplianceArgs(
        additionalNics = additionalNics,
        bootStrapConfigurationBlobs = bootStrapConfigurationBlobs,
        cloudInitConfiguration = cloudInitConfiguration,
        cloudInitConfigurationBlobs = cloudInitConfigurationBlobs,
        delegation = delegation,
        id = id,
        identity = identity,
        location = location,
        networkVirtualApplianceName = networkVirtualApplianceName,
        nvaSku = nvaSku,
        resourceGroupName = resourceGroupName,
        sshPublicKey = sshPublicKey,
        tags = tags,
        virtualApplianceAsn = virtualApplianceAsn,
        virtualHub = virtualHub,
    )
}
