@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureFilterResponse
import com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureMachineScopeResponse
import com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureStorageLocationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureFilterResponse.Companion.toKotlin as packetCaptureFilterResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureMachineScopeResponse.Companion.toKotlin as packetCaptureMachineScopeResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PacketCaptureStorageLocationResponse.Companion.toKotlin as packetCaptureStorageLocationResponseToKotlin

/**
 * Builder for [PacketCapture].
 */
@PulumiTagMarker
public class PacketCaptureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PacketCaptureArgs = PacketCaptureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PacketCaptureArgsBuilder.() -> Unit) {
        val builder = PacketCaptureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PacketCapture {
        val builtJavaResource = com.pulumi.azurenative.network.PacketCapture(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PacketCapture(builtJavaResource)
    }
}

/**
 * Information about packet capture session.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-01-01, 2020-06-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create packet capture
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCapture = new AzureNative.Network.PacketCapture("packetCapture", new()
 *     {
 *         BytesToCapturePerPacket = 10000,
 *         Filters = new[]
 *         {
 *             new AzureNative.Network.Inputs.PacketCaptureFilterArgs
 *             {
 *                 LocalIPAddress = "10.0.0.4",
 *                 LocalPort = "80",
 *                 Protocol = "TCP",
 *             },
 *         },
 *         NetworkWatcherName = "nw1",
 *         PacketCaptureName = "pc1",
 *         ResourceGroupName = "rg1",
 *         StorageLocation = new AzureNative.Network.Inputs.PacketCaptureStorageLocationArgs
 *         {
 *             FilePath = "D:\\capture\\pc1.cap",
 *             StorageId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore",
 *             StoragePath = "https://mytestaccountname.blob.core.windows.net/capture/pc1.cap",
 *         },
 *         Target = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1",
 *         TimeLimitInSeconds = 100,
 *         TotalBytesPerSession = 100000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPacketCapture(ctx, "packetCapture", &network.PacketCaptureArgs{
 * 			BytesToCapturePerPacket: pulumi.Float64(10000),
 * 			Filters: []network.PacketCaptureFilterArgs{
 * 				{
 * 					LocalIPAddress: pulumi.String("10.0.0.4"),
 * 					LocalPort:      pulumi.String("80"),
 * 					Protocol:       pulumi.String("TCP"),
 * 				},
 * 			},
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			PacketCaptureName:  pulumi.String("pc1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			StorageLocation: &network.PacketCaptureStorageLocationArgs{
 * 				FilePath:    pulumi.String("D:\\capture\\pc1.cap"),
 * 				StorageId:   pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore"),
 * 				StoragePath: pulumi.String("https://mytestaccountname.blob.core.windows.net/capture/pc1.cap"),
 * 			},
 * 			Target:               pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 			TimeLimitInSeconds:   pulumi.Int(100),
 * 			TotalBytesPerSession: pulumi.Float64(100000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PacketCapture;
 * import com.pulumi.azurenative.network.PacketCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCapture = new PacketCapture("packetCapture", PacketCaptureArgs.builder()
 *             .bytesToCapturePerPacket(10000)
 *             .filters(Map.ofEntries(
 *                 Map.entry("localIPAddress", "10.0.0.4"),
 *                 Map.entry("localPort", "80"),
 *                 Map.entry("protocol", "TCP")
 *             ))
 *             .networkWatcherName("nw1")
 *             .packetCaptureName("pc1")
 *             .resourceGroupName("rg1")
 *             .storageLocation(Map.ofEntries(
 *                 Map.entry("filePath", "D:\\capture\\pc1.cap"),
 *                 Map.entry("storageId", "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore"),
 *                 Map.entry("storagePath", "https://mytestaccountname.blob.core.windows.net/capture/pc1.cap")
 *             ))
 *             .target("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1")
 *             .timeLimitInSeconds(100)
 *             .totalBytesPerSession(100000)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PacketCapture pc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}
 * ```
 */
public class PacketCapture internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PacketCapture,
) : KotlinCustomResource(javaResource, PacketCaptureMapper) {
    /**
     * Number of bytes captured per packet, the remaining bytes are truncated.
     */
    public val bytesToCapturePerPacket: Output<Double>?
        get() = javaResource.bytesToCapturePerPacket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A list of packet capture filters.
     */
    public val filters: Output<List<PacketCaptureFilterResponse>>?
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> packetCaptureFilterResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Name of the packet capture session.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the packet capture session.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     */
    public val scope: Output<PacketCaptureMachineScopeResponse>?
        get() = javaResource.scope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    packetCaptureMachineScopeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The storage location for a packet capture session.
     */
    public val storageLocation: Output<PacketCaptureStorageLocationResponse>
        get() = javaResource.storageLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                packetCaptureStorageLocationResponseToKotlin(args0)
            })
        })

    /**
     * The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
     */
    public val target: Output<String>
        get() = javaResource.target().applyValue({ args0 -> args0 })

    /**
     * Target type of the resource provided.
     */
    public val targetType: Output<String>?
        get() = javaResource.targetType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum duration of the capture session in seconds.
     */
    public val timeLimitInSeconds: Output<Int>?
        get() = javaResource.timeLimitInSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum size of the capture output.
     */
    public val totalBytesPerSession: Output<Double>?
        get() = javaResource.totalBytesPerSession().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PacketCaptureMapper : ResourceMapper<PacketCapture> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PacketCapture::class == javaResource::class

    override fun map(javaResource: Resource): PacketCapture = PacketCapture(
        javaResource as
            com.pulumi.azurenative.network.PacketCapture,
    )
}

/**
 * @see [PacketCapture].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PacketCapture].
 */
public suspend fun packetCapture(
    name: String,
    block: suspend PacketCaptureResourceBuilder.() -> Unit,
): PacketCapture {
    val builder = PacketCaptureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PacketCapture].
 * @param name The _unique_ name of the resulting resource.
 */
public fun packetCapture(name: String): PacketCapture {
    val builder = PacketCaptureResourceBuilder()
    builder.name(name)
    return builder.build()
}
