@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PacketCaptureArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.PacketCaptureTargetType
import com.pulumi.azurenative.network.kotlin.inputs.PacketCaptureFilterArgs
import com.pulumi.azurenative.network.kotlin.inputs.PacketCaptureFilterArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PacketCaptureMachineScopeArgs
import com.pulumi.azurenative.network.kotlin.inputs.PacketCaptureMachineScopeArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PacketCaptureStorageLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.PacketCaptureStorageLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Information about packet capture session.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-01-01, 2020-06-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create packet capture
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var packetCapture = new AzureNative.Network.PacketCapture("packetCapture", new()
 *     {
 *         BytesToCapturePerPacket = 10000,
 *         Filters = new[]
 *         {
 *             new AzureNative.Network.Inputs.PacketCaptureFilterArgs
 *             {
 *                 LocalIPAddress = "10.0.0.4",
 *                 LocalPort = "80",
 *                 Protocol = "TCP",
 *             },
 *         },
 *         NetworkWatcherName = "nw1",
 *         PacketCaptureName = "pc1",
 *         ResourceGroupName = "rg1",
 *         StorageLocation = new AzureNative.Network.Inputs.PacketCaptureStorageLocationArgs
 *         {
 *             FilePath = "D:\\capture\\pc1.cap",
 *             StorageId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore",
 *             StoragePath = "https://mytestaccountname.blob.core.windows.net/capture/pc1.cap",
 *         },
 *         Target = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1",
 *         TimeLimitInSeconds = 100,
 *         TotalBytesPerSession = 100000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPacketCapture(ctx, "packetCapture", &network.PacketCaptureArgs{
 * 			BytesToCapturePerPacket: pulumi.Float64(10000),
 * 			Filters: []network.PacketCaptureFilterArgs{
 * 				{
 * 					LocalIPAddress: pulumi.String("10.0.0.4"),
 * 					LocalPort:      pulumi.String("80"),
 * 					Protocol:       pulumi.String("TCP"),
 * 				},
 * 			},
 * 			NetworkWatcherName: pulumi.String("nw1"),
 * 			PacketCaptureName:  pulumi.String("pc1"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			StorageLocation: &network.PacketCaptureStorageLocationArgs{
 * 				FilePath:    pulumi.String("D:\\capture\\pc1.cap"),
 * 				StorageId:   pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore"),
 * 				StoragePath: pulumi.String("https://mytestaccountname.blob.core.windows.net/capture/pc1.cap"),
 * 			},
 * 			Target:               pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 			TimeLimitInSeconds:   pulumi.Int(100),
 * 			TotalBytesPerSession: pulumi.Float64(100000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PacketCapture;
 * import com.pulumi.azurenative.network.PacketCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var packetCapture = new PacketCapture("packetCapture", PacketCaptureArgs.builder()
 *             .bytesToCapturePerPacket(10000)
 *             .filters(Map.ofEntries(
 *                 Map.entry("localIPAddress", "10.0.0.4"),
 *                 Map.entry("localPort", "80"),
 *                 Map.entry("protocol", "TCP")
 *             ))
 *             .networkWatcherName("nw1")
 *             .packetCaptureName("pc1")
 *             .resourceGroupName("rg1")
 *             .storageLocation(Map.ofEntries(
 *                 Map.entry("filePath", "D:\\capture\\pc1.cap"),
 *                 Map.entry("storageId", "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Storage/storageAccounts/pcstore"),
 *                 Map.entry("storagePath", "https://mytestaccountname.blob.core.windows.net/capture/pc1.cap")
 *             ))
 *             .target("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Compute/virtualMachines/vm1")
 *             .timeLimitInSeconds(100)
 *             .totalBytesPerSession(100000)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PacketCapture pc1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/packetCaptures/{packetCaptureName}
 * ```
 * @property bytesToCapturePerPacket Number of bytes captured per packet, the remaining bytes are truncated.
 * @property filters A list of packet capture filters.
 * @property networkWatcherName The name of the network watcher.
 * @property packetCaptureName The name of the packet capture session.
 * @property resourceGroupName The name of the resource group.
 * @property scope A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
 * @property storageLocation The storage location for a packet capture session.
 * @property target The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
 * @property targetType Target type of the resource provided.
 * @property timeLimitInSeconds Maximum duration of the capture session in seconds.
 * @property totalBytesPerSession Maximum size of the capture output.
 */
public data class PacketCaptureArgs(
    public val bytesToCapturePerPacket: Output<Double>? = null,
    public val filters: Output<List<PacketCaptureFilterArgs>>? = null,
    public val networkWatcherName: Output<String>? = null,
    public val packetCaptureName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<PacketCaptureMachineScopeArgs>? = null,
    public val storageLocation: Output<PacketCaptureStorageLocationArgs>? = null,
    public val target: Output<String>? = null,
    public val targetType: Output<PacketCaptureTargetType>? = null,
    public val timeLimitInSeconds: Output<Int>? = null,
    public val totalBytesPerSession: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PacketCaptureArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PacketCaptureArgs =
        com.pulumi.azurenative.network.PacketCaptureArgs.builder()
            .bytesToCapturePerPacket(bytesToCapturePerPacket?.applyValue({ args0 -> args0 }))
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .networkWatcherName(networkWatcherName?.applyValue({ args0 -> args0 }))
            .packetCaptureName(packetCaptureName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageLocation(storageLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeLimitInSeconds(timeLimitInSeconds?.applyValue({ args0 -> args0 }))
            .totalBytesPerSession(totalBytesPerSession?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PacketCaptureArgs].
 */
@PulumiTagMarker
public class PacketCaptureArgsBuilder internal constructor() {
    private var bytesToCapturePerPacket: Output<Double>? = null

    private var filters: Output<List<PacketCaptureFilterArgs>>? = null

    private var networkWatcherName: Output<String>? = null

    private var packetCaptureName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<PacketCaptureMachineScopeArgs>? = null

    private var storageLocation: Output<PacketCaptureStorageLocationArgs>? = null

    private var target: Output<String>? = null

    private var targetType: Output<PacketCaptureTargetType>? = null

    private var timeLimitInSeconds: Output<Int>? = null

    private var totalBytesPerSession: Output<Double>? = null

    /**
     * @param value Number of bytes captured per packet, the remaining bytes are truncated.
     */
    @JvmName("ijllvdtfwlytbida")
    public suspend fun bytesToCapturePerPacket(`value`: Output<Double>) {
        this.bytesToCapturePerPacket = value
    }

    /**
     * @param value A list of packet capture filters.
     */
    @JvmName("johevpisfirfljps")
    public suspend fun filters(`value`: Output<List<PacketCaptureFilterArgs>>) {
        this.filters = value
    }

    @JvmName("bfprhnvjodtkjbhj")
    public suspend fun filters(vararg values: Output<PacketCaptureFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values A list of packet capture filters.
     */
    @JvmName("aowepsjdeowvsqtt")
    public suspend fun filters(values: List<Output<PacketCaptureFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("xmrwljwqapwsdnjq")
    public suspend fun networkWatcherName(`value`: Output<String>) {
        this.networkWatcherName = value
    }

    /**
     * @param value The name of the packet capture session.
     */
    @JvmName("cvnhkmowswwakcyi")
    public suspend fun packetCaptureName(`value`: Output<String>) {
        this.packetCaptureName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("otexsgidfbbcsqod")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     */
    @JvmName("qrrsagrnhjvuogwn")
    public suspend fun scope(`value`: Output<PacketCaptureMachineScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value The storage location for a packet capture session.
     */
    @JvmName("eeqhqapgxfdgalvf")
    public suspend fun storageLocation(`value`: Output<PacketCaptureStorageLocationArgs>) {
        this.storageLocation = value
    }

    /**
     * @param value The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
     */
    @JvmName("kvvhhbdtcqwidyjx")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Target type of the resource provided.
     */
    @JvmName("chedvybanthncryc")
    public suspend fun targetType(`value`: Output<PacketCaptureTargetType>) {
        this.targetType = value
    }

    /**
     * @param value Maximum duration of the capture session in seconds.
     */
    @JvmName("xuwlsneenxyubide")
    public suspend fun timeLimitInSeconds(`value`: Output<Int>) {
        this.timeLimitInSeconds = value
    }

    /**
     * @param value Maximum size of the capture output.
     */
    @JvmName("mbtqptgctblvtgpy")
    public suspend fun totalBytesPerSession(`value`: Output<Double>) {
        this.totalBytesPerSession = value
    }

    /**
     * @param value Number of bytes captured per packet, the remaining bytes are truncated.
     */
    @JvmName("uwveuxyjwsudmaer")
    public suspend fun bytesToCapturePerPacket(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bytesToCapturePerPacket = mapped
    }

    /**
     * @param value A list of packet capture filters.
     */
    @JvmName("oyfschsrfstncifg")
    public suspend fun filters(`value`: List<PacketCaptureFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument A list of packet capture filters.
     */
    @JvmName("hmcnntowfrkrotlf")
    public suspend fun filters(argument: List<suspend PacketCaptureFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PacketCaptureFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument A list of packet capture filters.
     */
    @JvmName("sganrvmktnvrognn")
    public suspend fun filters(vararg argument: suspend PacketCaptureFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PacketCaptureFilterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument A list of packet capture filters.
     */
    @JvmName("ltvsddhigowlbneb")
    public suspend fun filters(argument: suspend PacketCaptureFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PacketCaptureFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values A list of packet capture filters.
     */
    @JvmName("mcvosrvyhxovtfgh")
    public suspend fun filters(vararg values: PacketCaptureFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("sfnnhvcfooemqjap")
    public suspend fun networkWatcherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the packet capture session.
     */
    @JvmName("adxxcecjghumdnss")
    public suspend fun packetCaptureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetCaptureName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wxrmrqtjvdvwerxd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     */
    @JvmName("vxrtempxfkrnvgeh")
    public suspend fun scope(`value`: PacketCaptureMachineScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     */
    @JvmName("mrvxbwcwyemswhxc")
    public suspend fun scope(argument: suspend PacketCaptureMachineScopeArgsBuilder.() -> Unit) {
        val toBeMapped = PacketCaptureMachineScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value The storage location for a packet capture session.
     */
    @JvmName("umphkdexsuvwqalq")
    public suspend fun storageLocation(`value`: PacketCaptureStorageLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLocation = mapped
    }

    /**
     * @param argument The storage location for a packet capture session.
     */
    @JvmName("jlhkqkrmrffjjabl")
    public suspend
    fun storageLocation(argument: suspend PacketCaptureStorageLocationArgsBuilder.() -> Unit) {
        val toBeMapped = PacketCaptureStorageLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageLocation = mapped
    }

    /**
     * @param value The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
     */
    @JvmName("fpjcpdpccwcaxxol")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Target type of the resource provided.
     */
    @JvmName("kgtlkuscxfsmrtvn")
    public suspend fun targetType(`value`: PacketCaptureTargetType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    /**
     * @param value Maximum duration of the capture session in seconds.
     */
    @JvmName("pakvgdfebbthgvbn")
    public suspend fun timeLimitInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeLimitInSeconds = mapped
    }

    /**
     * @param value Maximum size of the capture output.
     */
    @JvmName("eqyuapfqenyflola")
    public suspend fun totalBytesPerSession(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalBytesPerSession = mapped
    }

    internal fun build(): PacketCaptureArgs = PacketCaptureArgs(
        bytesToCapturePerPacket = bytesToCapturePerPacket,
        filters = filters,
        networkWatcherName = networkWatcherName,
        packetCaptureName = packetCaptureName,
        resourceGroupName = resourceGroupName,
        scope = scope,
        storageLocation = storageLocation,
        target = target,
        targetType = targetType,
        timeLimitInSeconds = timeLimitInSeconds,
        totalBytesPerSession = totalBytesPerSession,
    )
}
