@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.CustomRuleListResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontDoorPolicySettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleSetListResponse
import com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.SecurityPolicyLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.CustomRuleListResponse.Companion.toKotlin as customRuleListResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontDoorPolicySettingsResponse.Companion.toKotlin as frontDoorPolicySettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointLinkResponse.Companion.toKotlin as frontendEndpointLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleSetListResponse.Companion.toKotlin as managedRuleSetListResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleLinkResponse.Companion.toKotlin as routingRuleLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SecurityPolicyLinkResponse.Companion.toKotlin as securityPolicyLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.azurenative.network.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-06-01.
 * ## Example Usage
 * ### Creates specific policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.Network.Policy("policy", new()
 *     {
 *         CustomRules = new AzureNative.Network.Inputs.CustomRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Network.Inputs.CustomRuleArgs
 *                 {
 *                     Action = "Block",
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24",
 *                             },
 *                             MatchVariable = "RemoteAddr",
 *                             Operator = "IPMatch",
 *                         },
 *                     },
 *                     Name = "Rule1",
 *                     Priority = 1,
 *                     RateLimitThreshold = 1000,
 *                     RuleType = "RateLimitRule",
 *                 },
 *                 new AzureNative.Network.Inputs.CustomRuleArgs
 *                 {
 *                     Action = "Block",
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "CH",
 *                             },
 *                             MatchVariable = "RemoteAddr",
 *                             Operator = "GeoMatch",
 *                         },
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "windows",
 *                             },
 *                             MatchVariable = "RequestHeader",
 *                             Operator = "Contains",
 *                             Selector = "UserAgent",
 *                             Transforms = new[]
 *                             {
 *                                 "Lowercase",
 *                             },
 *                         },
 *                     },
 *                     Name = "Rule2",
 *                     Priority = 2,
 *                     RuleType = "MatchRule",
 *                 },
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRuleSetListArgs
 *         {
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.FrontDoorManagedRuleSetArgs
 *                 {
 *                     Exclusions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                         {
 *                             MatchVariable = "RequestHeaderNames",
 *                             Selector = "User-Agent",
 *                             SelectorMatchOperator = "Equals",
 *                         },
 *                     },
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorManagedRuleGroupOverrideArgs
 *                         {
 *                             Exclusions = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                                 {
 *                                     MatchVariable = "RequestCookieNames",
 *                                     Selector = "token",
 *                                     SelectorMatchOperator = "StartsWith",
 *                                 },
 *                             },
 *                             RuleGroupName = "SQLI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.FrontDoorManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "Redirect",
 *                                     EnabledState = "Enabled",
 *                                     Exclusions = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                                         {
 *                                             MatchVariable = "QueryStringArgNames",
 *                                             Selector = "query",
 *                                             SelectorMatchOperator = "Equals",
 *                                         },
 *                                     },
 *                                     RuleId = "942100",
 *                                 },
 *                                 new AzureNative.Network.Inputs.FrontDoorManagedRuleOverrideArgs
 *                                 {
 *                                     EnabledState = "Disabled",
 *                                     RuleId = "942110",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetAction = "Block",
 *                     RuleSetType = "DefaultRuleSet",
 *                     RuleSetVersion = "1.0",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.FrontDoorPolicySettingsArgs
 *         {
 *             CustomBlockResponseBody = "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
 *             CustomBlockResponseStatusCode = 429,
 *             EnabledState = "Enabled",
 *             Mode = "Prevention",
 *             RedirectUrl = "http://www.bing.com",
 *             RequestBodyCheck = "Disabled",
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.SkuArgs
 *         {
 *             Name = "Classic_AzureFrontDoor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewPolicy(ctx, "policy", &network.PolicyArgs{
 * CustomRules: network.CustomRuleListResponse{
 * Rules: network.CustomRuleArray{
 * interface{}{
 * Action: pulumi.String("Block"),
 * MatchConditions: network.FrontDoorMatchConditionArray{
 * &network.FrontDoorMatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariable: pulumi.String("RemoteAddr"),
 * Operator: pulumi.String("IPMatch"),
 * },
 * },
 * Name: pulumi.String("Rule1"),
 * Priority: pulumi.Int(1),
 * RateLimitThreshold: pulumi.Int(1000),
 * RuleType: pulumi.String("RateLimitRule"),
 * },
 * interface{}{
 * Action: pulumi.String("Block"),
 * MatchConditions: network.FrontDoorMatchConditionArray{
 * &network.FrontDoorMatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("CH"),
 * },
 * MatchVariable: pulumi.String("RemoteAddr"),
 * Operator: pulumi.String("GeoMatch"),
 * },
 * &network.FrontDoorMatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("windows"),
 * },
 * MatchVariable: pulumi.String("RequestHeader"),
 * Operator: pulumi.String("Contains"),
 * Selector: pulumi.String("UserAgent"),
 * Transforms: pulumi.StringArray{
 * pulumi.String("Lowercase"),
 * },
 * },
 * },
 * Name: pulumi.String("Rule2"),
 * Priority: pulumi.Int(2),
 * RuleType: pulumi.String("MatchRule"),
 * },
 * },
 * },
 * Location: pulumi.String("WestUs"),
 * ManagedRules: network.ManagedRuleSetListResponse{
 * ManagedRuleSets: network.FrontDoorManagedRuleSetArray{
 * interface{}{
 * Exclusions: network.ManagedRuleExclusionArray{
 * &network.ManagedRuleExclusionArgs{
 * MatchVariable: pulumi.String("RequestHeaderNames"),
 * Selector: pulumi.String("User-Agent"),
 * SelectorMatchOperator: pulumi.String("Equals"),
 * },
 * },
 * RuleGroupOverrides: network.FrontDoorManagedRuleGroupOverrideArray{
 * interface{}{
 * Exclusions: network.ManagedRuleExclusionArray{
 * &network.ManagedRuleExclusionArgs{
 * MatchVariable: pulumi.String("RequestCookieNames"),
 * Selector: pulumi.String("token"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * },
 * RuleGroupName: pulumi.String("SQLI"),
 * Rules: network.FrontDoorManagedRuleOverrideArray{
 * interface{}{
 * Action: pulumi.String("Redirect"),
 * EnabledState: pulumi.String("Enabled"),
 * Exclusions: network.ManagedRuleExclusionArray{
 * &network.ManagedRuleExclusionArgs{
 * MatchVariable: pulumi.String("QueryStringArgNames"),
 * Selector: pulumi.String("query"),
 * SelectorMatchOperator: pulumi.String("Equals"),
 * },
 * },
 * RuleId: pulumi.String("942100"),
 * },
 * &network.FrontDoorManagedRuleOverrideArgs{
 * EnabledState: pulumi.String("Disabled"),
 * RuleId: pulumi.String("942110"),
 * },
 * },
 * },
 * },
 * RuleSetAction: pulumi.String("Block"),
 * RuleSetType: pulumi.String("DefaultRuleSet"),
 * RuleSetVersion: pulumi.String("1.0"),
 * },
 * },
 * },
 * PolicyName: pulumi.String("Policy1"),
 * PolicySettings: &network.FrontDoorPolicySettingsArgs{
 * CustomBlockResponseBody: pulumi.String("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 * CustomBlockResponseStatusCode: pulumi.Int(429),
 * EnabledState: pulumi.String("Enabled"),
 * Mode: pulumi.String("Prevention"),
 * RedirectUrl: pulumi.String("http://www.bing.com"),
 * RequestBodyCheck: pulumi.String("Disabled"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.SkuArgs{
 * Name: pulumi.String("Classic_AzureFrontDoor"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Policy;
 * import com.pulumi.azurenative.network.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .customRules(Map.of("rules",
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("matchValue",
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24"),
 *                         Map.entry("matchVariable", "RemoteAddr"),
 *                         Map.entry("operator", "IPMatch")
 *                     )),
 *                     Map.entry("name", "Rule1"),
 *                     Map.entry("priority", 1),
 *                     Map.entry("rateLimitThreshold", 1000),
 *                     Map.entry("ruleType", "RateLimitRule")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions",
 *                         Map.ofEntries(
 *                             Map.entry("matchValue", "CH"),
 *                             Map.entry("matchVariable", "RemoteAddr"),
 *                             Map.entry("operator", "GeoMatch")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("matchValue", "windows"),
 *                             Map.entry("matchVariable", "RequestHeader"),
 *                             Map.entry("operator", "Contains"),
 *                             Map.entry("selector", "UserAgent"),
 *                             Map.entry("transforms", "Lowercase")
 *                         )),
 *                     Map.entry("name", "Rule2"),
 *                     Map.entry("priority", 2),
 *                     Map.entry("ruleType", "MatchRule")
 *                 )))
 *             .location("WestUs")
 *             .managedRules(Map.of("managedRuleSets", Map.ofEntries(
 *                 Map.entry("exclusions", Map.ofEntries(
 *                     Map.entry("matchVariable", "RequestHeaderNames"),
 *                     Map.entry("selector", "User-Agent"),
 *                     Map.entry("selectorMatchOperator", "Equals")
 *                 )),
 *                 Map.entry("ruleGroupOverrides", Map.ofEntries(
 *                     Map.entry("exclusions", Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestCookieNames"),
 *                         Map.entry("selector", "token"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     )),
 *                     Map.entry("ruleGroupName", "SQLI"),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("action", "Redirect"),
 *                             Map.entry("enabledState", "Enabled"),
 *                             Map.entry("exclusions", Map.ofEntries(
 *                                 Map.entry("matchVariable", "QueryStringArgNames"),
 *                                 Map.entry("selector", "query"),
 *                                 Map.entry("selectorMatchOperator", "Equals")
 *                             )),
 *                             Map.entry("ruleId", "942100")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("enabledState", "Disabled"),
 *                             Map.entry("ruleId", "942110")
 *                         ))
 *                 )),
 *                 Map.entry("ruleSetAction", "Block"),
 *                 Map.entry("ruleSetType", "DefaultRuleSet"),
 *                 Map.entry("ruleSetVersion", "1.0")
 *             )))
 *             .policyName("Policy1")
 *             .policySettings(Map.ofEntries(
 *                 Map.entry("customBlockResponseBody", "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 *                 Map.entry("customBlockResponseStatusCode", 429),
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("mode", "Prevention"),
 *                 Map.entry("redirectUrl", "http://www.bing.com"),
 *                 Map.entry("requestBodyCheck", "Disabled")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Classic_AzureFrontDoor"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Policy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    /**
     * Describes custom rules inside the policy.
     */
    public val customRules: Output<CustomRuleListResponse>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    customRuleListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets a unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes Frontend Endpoints associated with this Web Application Firewall policy.
     */
    public val frontendEndpointLinks: Output<List<FrontendEndpointLinkResponse>>
        get() = javaResource.frontendEndpointLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> frontendEndpointLinkResponseToKotlin(args0) })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes managed rules inside the policy.
     */
    public val managedRules: Output<ManagedRuleSetListResponse>?
        get() = javaResource.managedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRuleSetListResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Describes settings for the policy.
     */
    public val policySettings: Output<FrontDoorPolicySettingsResponse>?
        get() = javaResource.policySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> frontDoorPolicySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state of the policy.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Describes Routing Rules associated with this Web Application Firewall policy.
     */
    public val routingRuleLinks: Output<List<RoutingRuleLinkResponse>>
        get() = javaResource.routingRuleLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingRuleLinkResponseToKotlin(args0) })
            })
        })

    /**
     * Describes Security Policy associated with this Web Application Firewall policy.
     */
    public val securityPolicyLinks: Output<List<SecurityPolicyLinkResponse>>
        get() = javaResource.securityPolicyLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> securityPolicyLinkResponseToKotlin(args0) })
            })
        })

    /**
     * The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.azurenative.network.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
