@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.CustomRuleListArgs
import com.pulumi.azurenative.network.kotlin.inputs.CustomRuleListArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FrontDoorPolicySettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontDoorPolicySettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ManagedRuleSetListArgs
import com.pulumi.azurenative.network.kotlin.inputs.ManagedRuleSetListArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2022-05-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-06-01.
 * ## Example Usage
 * ### Creates specific policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.Network.Policy("policy", new()
 *     {
 *         CustomRules = new AzureNative.Network.Inputs.CustomRuleListArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Network.Inputs.CustomRuleArgs
 *                 {
 *                     Action = "Block",
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "192.168.1.0/24",
 *                                 "10.0.0.0/24",
 *                             },
 *                             MatchVariable = "RemoteAddr",
 *                             Operator = "IPMatch",
 *                         },
 *                     },
 *                     Name = "Rule1",
 *                     Priority = 1,
 *                     RateLimitThreshold = 1000,
 *                     RuleType = "RateLimitRule",
 *                 },
 *                 new AzureNative.Network.Inputs.CustomRuleArgs
 *                 {
 *                     Action = "Block",
 *                     MatchConditions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "CH",
 *                             },
 *                             MatchVariable = "RemoteAddr",
 *                             Operator = "GeoMatch",
 *                         },
 *                         new AzureNative.Network.Inputs.FrontDoorMatchConditionArgs
 *                         {
 *                             MatchValue = new[]
 *                             {
 *                                 "windows",
 *                             },
 *                             MatchVariable = "RequestHeader",
 *                             Operator = "Contains",
 *                             Selector = "UserAgent",
 *                             Transforms = new[]
 *                             {
 *                                 "Lowercase",
 *                             },
 *                         },
 *                     },
 *                     Name = "Rule2",
 *                     Priority = 2,
 *                     RuleType = "MatchRule",
 *                 },
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRuleSetListArgs
 *         {
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.FrontDoorManagedRuleSetArgs
 *                 {
 *                     Exclusions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                         {
 *                             MatchVariable = "RequestHeaderNames",
 *                             Selector = "User-Agent",
 *                             SelectorMatchOperator = "Equals",
 *                         },
 *                     },
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.FrontDoorManagedRuleGroupOverrideArgs
 *                         {
 *                             Exclusions = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                                 {
 *                                     MatchVariable = "RequestCookieNames",
 *                                     Selector = "token",
 *                                     SelectorMatchOperator = "StartsWith",
 *                                 },
 *                             },
 *                             RuleGroupName = "SQLI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.FrontDoorManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "Redirect",
 *                                     EnabledState = "Enabled",
 *                                     Exclusions = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ManagedRuleExclusionArgs
 *                                         {
 *                                             MatchVariable = "QueryStringArgNames",
 *                                             Selector = "query",
 *                                             SelectorMatchOperator = "Equals",
 *                                         },
 *                                     },
 *                                     RuleId = "942100",
 *                                 },
 *                                 new AzureNative.Network.Inputs.FrontDoorManagedRuleOverrideArgs
 *                                 {
 *                                     EnabledState = "Disabled",
 *                                     RuleId = "942110",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetAction = "Block",
 *                     RuleSetType = "DefaultRuleSet",
 *                     RuleSetVersion = "1.0",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.FrontDoorPolicySettingsArgs
 *         {
 *             CustomBlockResponseBody = "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
 *             CustomBlockResponseStatusCode = 429,
 *             EnabledState = "Enabled",
 *             Mode = "Prevention",
 *             RedirectUrl = "http://www.bing.com",
 *             RequestBodyCheck = "Disabled",
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.SkuArgs
 *         {
 *             Name = "Classic_AzureFrontDoor",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewPolicy(ctx, "policy", &network.PolicyArgs{
 * CustomRules: network.CustomRuleListResponse{
 * Rules: network.CustomRuleArray{
 * interface{}{
 * Action: pulumi.String("Block"),
 * MatchConditions: network.FrontDoorMatchConditionArray{
 * &network.FrontDoorMatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariable: pulumi.String("RemoteAddr"),
 * Operator: pulumi.String("IPMatch"),
 * },
 * },
 * Name: pulumi.String("Rule1"),
 * Priority: pulumi.Int(1),
 * RateLimitThreshold: pulumi.Int(1000),
 * RuleType: pulumi.String("RateLimitRule"),
 * },
 * interface{}{
 * Action: pulumi.String("Block"),
 * MatchConditions: network.FrontDoorMatchConditionArray{
 * &network.FrontDoorMatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("CH"),
 * },
 * MatchVariable: pulumi.String("RemoteAddr"),
 * Operator: pulumi.String("GeoMatch"),
 * },
 * &network.FrontDoorMatchConditionArgs{
 * MatchValue: pulumi.StringArray{
 * pulumi.String("windows"),
 * },
 * MatchVariable: pulumi.String("RequestHeader"),
 * Operator: pulumi.String("Contains"),
 * Selector: pulumi.String("UserAgent"),
 * Transforms: pulumi.StringArray{
 * pulumi.String("Lowercase"),
 * },
 * },
 * },
 * Name: pulumi.String("Rule2"),
 * Priority: pulumi.Int(2),
 * RuleType: pulumi.String("MatchRule"),
 * },
 * },
 * },
 * Location: pulumi.String("WestUs"),
 * ManagedRules: network.ManagedRuleSetListResponse{
 * ManagedRuleSets: network.FrontDoorManagedRuleSetArray{
 * interface{}{
 * Exclusions: network.ManagedRuleExclusionArray{
 * &network.ManagedRuleExclusionArgs{
 * MatchVariable: pulumi.String("RequestHeaderNames"),
 * Selector: pulumi.String("User-Agent"),
 * SelectorMatchOperator: pulumi.String("Equals"),
 * },
 * },
 * RuleGroupOverrides: network.FrontDoorManagedRuleGroupOverrideArray{
 * interface{}{
 * Exclusions: network.ManagedRuleExclusionArray{
 * &network.ManagedRuleExclusionArgs{
 * MatchVariable: pulumi.String("RequestCookieNames"),
 * Selector: pulumi.String("token"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * },
 * RuleGroupName: pulumi.String("SQLI"),
 * Rules: network.FrontDoorManagedRuleOverrideArray{
 * interface{}{
 * Action: pulumi.String("Redirect"),
 * EnabledState: pulumi.String("Enabled"),
 * Exclusions: network.ManagedRuleExclusionArray{
 * &network.ManagedRuleExclusionArgs{
 * MatchVariable: pulumi.String("QueryStringArgNames"),
 * Selector: pulumi.String("query"),
 * SelectorMatchOperator: pulumi.String("Equals"),
 * },
 * },
 * RuleId: pulumi.String("942100"),
 * },
 * &network.FrontDoorManagedRuleOverrideArgs{
 * EnabledState: pulumi.String("Disabled"),
 * RuleId: pulumi.String("942110"),
 * },
 * },
 * },
 * },
 * RuleSetAction: pulumi.String("Block"),
 * RuleSetType: pulumi.String("DefaultRuleSet"),
 * RuleSetVersion: pulumi.String("1.0"),
 * },
 * },
 * },
 * PolicyName: pulumi.String("Policy1"),
 * PolicySettings: &network.FrontDoorPolicySettingsArgs{
 * CustomBlockResponseBody: pulumi.String("PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 * CustomBlockResponseStatusCode: pulumi.Int(429),
 * EnabledState: pulumi.String("Enabled"),
 * Mode: pulumi.String("Prevention"),
 * RedirectUrl: pulumi.String("http://www.bing.com"),
 * RequestBodyCheck: pulumi.String("Disabled"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.SkuArgs{
 * Name: pulumi.String("Classic_AzureFrontDoor"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Policy;
 * import com.pulumi.azurenative.network.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .customRules(Map.of("rules",
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("matchValue",
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24"),
 *                         Map.entry("matchVariable", "RemoteAddr"),
 *                         Map.entry("operator", "IPMatch")
 *                     )),
 *                     Map.entry("name", "Rule1"),
 *                     Map.entry("priority", 1),
 *                     Map.entry("rateLimitThreshold", 1000),
 *                     Map.entry("ruleType", "RateLimitRule")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions",
 *                         Map.ofEntries(
 *                             Map.entry("matchValue", "CH"),
 *                             Map.entry("matchVariable", "RemoteAddr"),
 *                             Map.entry("operator", "GeoMatch")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("matchValue", "windows"),
 *                             Map.entry("matchVariable", "RequestHeader"),
 *                             Map.entry("operator", "Contains"),
 *                             Map.entry("selector", "UserAgent"),
 *                             Map.entry("transforms", "Lowercase")
 *                         )),
 *                     Map.entry("name", "Rule2"),
 *                     Map.entry("priority", 2),
 *                     Map.entry("ruleType", "MatchRule")
 *                 )))
 *             .location("WestUs")
 *             .managedRules(Map.of("managedRuleSets", Map.ofEntries(
 *                 Map.entry("exclusions", Map.ofEntries(
 *                     Map.entry("matchVariable", "RequestHeaderNames"),
 *                     Map.entry("selector", "User-Agent"),
 *                     Map.entry("selectorMatchOperator", "Equals")
 *                 )),
 *                 Map.entry("ruleGroupOverrides", Map.ofEntries(
 *                     Map.entry("exclusions", Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestCookieNames"),
 *                         Map.entry("selector", "token"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     )),
 *                     Map.entry("ruleGroupName", "SQLI"),
 *                     Map.entry("rules",
 *                         Map.ofEntries(
 *                             Map.entry("action", "Redirect"),
 *                             Map.entry("enabledState", "Enabled"),
 *                             Map.entry("exclusions", Map.ofEntries(
 *                                 Map.entry("matchVariable", "QueryStringArgNames"),
 *                                 Map.entry("selector", "query"),
 *                                 Map.entry("selectorMatchOperator", "Equals")
 *                             )),
 *                             Map.entry("ruleId", "942100")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("enabledState", "Disabled"),
 *                             Map.entry("ruleId", "942110")
 *                         ))
 *                 )),
 *                 Map.entry("ruleSetAction", "Block"),
 *                 Map.entry("ruleSetType", "DefaultRuleSet"),
 *                 Map.entry("ruleSetVersion", "1.0")
 *             )))
 *             .policyName("Policy1")
 *             .policySettings(Map.ofEntries(
 *                 Map.entry("customBlockResponseBody", "PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg=="),
 *                 Map.entry("customBlockResponseStatusCode", 429),
 *                 Map.entry("enabledState", "Enabled"),
 *                 Map.entry("mode", "Prevention"),
 *                 Map.entry("redirectUrl", "http://www.bing.com"),
 *                 Map.entry("requestBodyCheck", "Disabled")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Classic_AzureFrontDoor"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Policy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/FrontDoorWebApplicationFirewallPolicies/{policyName}
 * ```
 * @property customRules Describes custom rules inside the policy.
 * @property location Resource location.
 * @property managedRules Describes managed rules inside the policy.
 * @property policyName The name of the Web Application Firewall Policy.
 * @property policySettings Describes settings for the policy.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property sku The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
 * @property tags Resource tags.
 */
public data class PolicyArgs(
    public val customRules: Output<CustomRuleListArgs>? = null,
    public val location: Output<String>? = null,
    public val managedRules: Output<ManagedRuleSetListArgs>? = null,
    public val policyName: Output<String>? = null,
    public val policySettings: Output<FrontDoorPolicySettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PolicyArgs =
        com.pulumi.azurenative.network.PolicyArgs.builder()
            .customRules(customRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedRules(managedRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policySettings(policySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var customRules: Output<CustomRuleListArgs>? = null

    private var location: Output<String>? = null

    private var managedRules: Output<ManagedRuleSetListArgs>? = null

    private var policyName: Output<String>? = null

    private var policySettings: Output<FrontDoorPolicySettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Describes custom rules inside the policy.
     */
    @JvmName("xwomkclrnlhsmfxu")
    public suspend fun customRules(`value`: Output<CustomRuleListArgs>) {
        this.customRules = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("pbhantoyccsxvirc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Describes managed rules inside the policy.
     */
    @JvmName("rctoxjabwmvkpwfv")
    public suspend fun managedRules(`value`: Output<ManagedRuleSetListArgs>) {
        this.managedRules = value
    }

    /**
     * @param value The name of the Web Application Firewall Policy.
     */
    @JvmName("cparhepfdtybfxkn")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Describes settings for the policy.
     */
    @JvmName("hfxxkbgrpigkvhod")
    public suspend fun policySettings(`value`: Output<FrontDoorPolicySettingsArgs>) {
        this.policySettings = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("rhklkjrqluvrbhqp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
     */
    @JvmName("qgqvceistbxjhogq")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tqccvnfjabxytueh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Describes custom rules inside the policy.
     */
    @JvmName("igopwrmwiedhgnlx")
    public suspend fun customRules(`value`: CustomRuleListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRules = mapped
    }

    /**
     * @param argument Describes custom rules inside the policy.
     */
    @JvmName("dickyttrtvbxtmgv")
    public suspend fun customRules(argument: suspend CustomRuleListArgsBuilder.() -> Unit) {
        val toBeMapped = CustomRuleListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customRules = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("cdhcojaorjyugxyp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Describes managed rules inside the policy.
     */
    @JvmName("mrjpsdhnrejjbaad")
    public suspend fun managedRules(`value`: ManagedRuleSetListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedRules = mapped
    }

    /**
     * @param argument Describes managed rules inside the policy.
     */
    @JvmName("wtbhfwyikjvcpvyk")
    public suspend fun managedRules(argument: suspend ManagedRuleSetListArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedRuleSetListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedRules = mapped
    }

    /**
     * @param value The name of the Web Application Firewall Policy.
     */
    @JvmName("yilnjvpgjvoweest")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Describes settings for the policy.
     */
    @JvmName("lmgwgddbxweuunuw")
    public suspend fun policySettings(`value`: FrontDoorPolicySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySettings = mapped
    }

    /**
     * @param argument Describes settings for the policy.
     */
    @JvmName("ijuerlbgyrsdcyxl")
    public suspend
    fun policySettings(argument: suspend FrontDoorPolicySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = FrontDoorPolicySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policySettings = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wyimnuayprfpyuij")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
     */
    @JvmName("nsrpglueguypmows")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
     */
    @JvmName("icgsanbtbwhlxrwr")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eodtnmvfppuvvmaa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vdumtypnoololuqr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        customRules = customRules,
        location = location,
        managedRules = managedRules,
        policyName = policyName,
        policySettings = policySettings,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
