@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.PrivateDnsZoneConfigResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateDnsZoneConfigResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PrivateDnsZoneGroup].
 */
@PulumiTagMarker
public class PrivateDnsZoneGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateDnsZoneGroupArgs = PrivateDnsZoneGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateDnsZoneGroupArgsBuilder.() -> Unit) {
        val builder = PrivateDnsZoneGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateDnsZoneGroup {
        val builtJavaResource =
            com.pulumi.azurenative.network.PrivateDnsZoneGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateDnsZoneGroup(builtJavaResource)
    }
}

/**
 * Private dns zone group resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-02-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create private dns zone group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateDnsZoneGroup = new AzureNative.Network.PrivateDnsZoneGroup("privateDnsZoneGroup", new()
 *     {
 *         PrivateDnsZoneConfigs = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateDnsZoneConfigArgs
 *             {
 *                 PrivateDnsZoneId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com",
 *             },
 *         },
 *         PrivateDnsZoneGroupName = "testPdnsgroup",
 *         PrivateEndpointName = "testPe",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateDnsZoneGroup(ctx, "privateDnsZoneGroup", &network.PrivateDnsZoneGroupArgs{
 * 			PrivateDnsZoneConfigs: []network.PrivateDnsZoneConfigArgs{
 * 				{
 * 					PrivateDnsZoneId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com"),
 * 				},
 * 			},
 * 			PrivateDnsZoneGroupName: pulumi.String("testPdnsgroup"),
 * 			PrivateEndpointName:     pulumi.String("testPe"),
 * 			ResourceGroupName:       pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateDnsZoneGroup;
 * import com.pulumi.azurenative.network.PrivateDnsZoneGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateDnsZoneGroup = new PrivateDnsZoneGroup("privateDnsZoneGroup", PrivateDnsZoneGroupArgs.builder()
 *             .privateDnsZoneConfigs(Map.of("privateDnsZoneId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateDnsZones/zone1.com"))
 *             .privateDnsZoneGroupName("testPdnsgroup")
 *             .privateEndpointName("testPe")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateDnsZoneGroup testPdnsgroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}/privateDnsZoneGroups/{privateDnsZoneGroupName}
 * ```
 */
public class PrivateDnsZoneGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PrivateDnsZoneGroup,
) : KotlinCustomResource(javaResource, PrivateDnsZoneGroupMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A collection of private dns zone configurations of the private dns zone group.
     */
    public val privateDnsZoneConfigs: Output<List<PrivateDnsZoneConfigResponse>>?
        get() = javaResource.privateDnsZoneConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the private dns zone group resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })
}

public object PrivateDnsZoneGroupMapper : ResourceMapper<PrivateDnsZoneGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateDnsZoneGroup::class == javaResource::class

    override fun map(javaResource: Resource): PrivateDnsZoneGroup = PrivateDnsZoneGroup(
        javaResource
            as com.pulumi.azurenative.network.PrivateDnsZoneGroup,
    )
}

/**
 * @see [PrivateDnsZoneGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateDnsZoneGroup].
 */
public suspend fun privateDnsZoneGroup(
    name: String,
    block: suspend PrivateDnsZoneGroupResourceBuilder.() -> Unit,
): PrivateDnsZoneGroup {
    val builder = PrivateDnsZoneGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateDnsZoneGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateDnsZoneGroup(name: String): PrivateDnsZoneGroup {
    val builder = PrivateDnsZoneGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
