@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PrivateEndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationSecurityGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.ApplicationSecurityGroupArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.CustomDnsConfigPropertiesFormatArgs
import com.pulumi.azurenative.network.kotlin.inputs.CustomDnsConfigPropertiesFormatArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateEndpointIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateEndpointIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceConnectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.PrivateLinkServiceConnectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Private endpoint resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-02-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create private endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.Network.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         CustomNetworkInterfaceName = "testPeNic",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateEndpointIPConfigurationArgs
 *             {
 *                 GroupId = "file",
 *                 MemberName = "file",
 *                 Name = "pestaticconfig",
 *                 PrivateIPAddress = "192.168.0.6",
 *             },
 *         },
 *         Location = "eastus2euap",
 *         PrivateEndpointName = "testPe",
 *         PrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *                 RequestMessage = "Please approve my connection.",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateEndpoint(ctx, "privateEndpoint", &network.PrivateEndpointArgs{
 * 			CustomNetworkInterfaceName: pulumi.String("testPeNic"),
 * 			IpConfigurations: []network.PrivateEndpointIPConfigurationArgs{
 * 				{
 * 					GroupId:          pulumi.String("file"),
 * 					MemberName:       pulumi.String("file"),
 * 					Name:             pulumi.String("pestaticconfig"),
 * 					PrivateIPAddress: pulumi.String("192.168.0.6"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("eastus2euap"),
 * 			PrivateEndpointName: pulumi.String("testPe"),
 * 			PrivateLinkServiceConnections: []network.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 					RequestMessage:       pulumi.String("Please approve my connection."),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateEndpoint;
 * import com.pulumi.azurenative.network.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .customNetworkInterfaceName("testPeNic")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("groupId", "file"),
 *                 Map.entry("memberName", "file"),
 *                 Map.entry("name", "pestaticconfig"),
 *                 Map.entry("privateIPAddress", "192.168.0.6")
 *             ))
 *             .location("eastus2euap")
 *             .privateEndpointName("testPe")
 *             .privateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 *                 Map.entry("requestMessage", "Please approve my connection.")
 *             ))
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create private endpoint with application security groups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.Network.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         ApplicationSecurityGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ApplicationSecurityGroupArgs
 *             {
 *                 Id = "/subscriptions/subId/resourceGroups/rg1/provders/Microsoft.Network/applicationSecurityGroup/asg1",
 *             },
 *         },
 *         Location = "eastus2euap",
 *         PrivateEndpointName = "testPe",
 *         PrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *                 RequestMessage = "Please approve my connection.",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateEndpoint(ctx, "privateEndpoint", &network.PrivateEndpointArgs{
 * 			ApplicationSecurityGroups: []network.ApplicationSecurityGroupTypeArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/provders/Microsoft.Network/applicationSecurityGroup/asg1"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("eastus2euap"),
 * 			PrivateEndpointName: pulumi.String("testPe"),
 * 			PrivateLinkServiceConnections: []network.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 					RequestMessage:       pulumi.String("Please approve my connection."),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateEndpoint;
 * import com.pulumi.azurenative.network.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .applicationSecurityGroups(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/provders/Microsoft.Network/applicationSecurityGroup/asg1"))
 *             .location("eastus2euap")
 *             .privateEndpointName("testPe")
 *             .privateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 *                 Map.entry("requestMessage", "Please approve my connection.")
 *             ))
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create private endpoint with manual approval connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.Network.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         CustomNetworkInterfaceName = "testPeNic",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateEndpointIPConfigurationArgs
 *             {
 *                 GroupId = "file",
 *                 MemberName = "file",
 *                 Name = "pestaticconfig",
 *                 PrivateIPAddress = "192.168.0.5",
 *             },
 *         },
 *         Location = "eastus",
 *         ManualPrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *                 RequestMessage = "Please manually approve my connection.",
 *             },
 *         },
 *         PrivateEndpointName = "testPe",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateEndpoint(ctx, "privateEndpoint", &network.PrivateEndpointArgs{
 * 			CustomNetworkInterfaceName: pulumi.String("testPeNic"),
 * 			IpConfigurations: []network.PrivateEndpointIPConfigurationArgs{
 * 				{
 * 					GroupId:          pulumi.String("file"),
 * 					MemberName:       pulumi.String("file"),
 * 					Name:             pulumi.String("pestaticconfig"),
 * 					PrivateIPAddress: pulumi.String("192.168.0.5"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			ManualPrivateLinkServiceConnections: []network.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 					RequestMessage:       pulumi.String("Please manually approve my connection."),
 * 				},
 * 			},
 * 			PrivateEndpointName: pulumi.String("testPe"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateEndpoint;
 * import com.pulumi.azurenative.network.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .customNetworkInterfaceName("testPeNic")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("groupId", "file"),
 *                 Map.entry("memberName", "file"),
 *                 Map.entry("name", "pestaticconfig"),
 *                 Map.entry("privateIPAddress", "192.168.0.5")
 *             ))
 *             .location("eastus")
 *             .manualPrivateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 *                 Map.entry("requestMessage", "Please manually approve my connection.")
 *             ))
 *             .privateEndpointName("testPe")
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateEndpoint testPe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}
 * ```
 * @property applicationSecurityGroups Application security groups in which the private endpoint IP configuration is included.
 * @property customDnsConfigs An array of custom dns configurations.
 * @property customNetworkInterfaceName The custom name of the network interface attached to the private endpoint.
 * @property extendedLocation The extended location of the load balancer.
 * @property id Resource ID.
 * @property ipConfigurations A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
 * @property location Resource location.
 * @property manualPrivateLinkServiceConnections A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
 * @property privateEndpointName The name of the private endpoint.
 * @property privateLinkServiceConnections A grouping of information about the connection to the remote resource.
 * @property resourceGroupName The name of the resource group.
 * @property subnet The ID of the subnet from which the private IP will be allocated.
 * @property tags Resource tags.
 */
public data class PrivateEndpointArgs(
    public val applicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null,
    public val customDnsConfigs: Output<List<CustomDnsConfigPropertiesFormatArgs>>? = null,
    public val customNetworkInterfaceName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<PrivateEndpointIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val manualPrivateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? =
        null,
    public val privateEndpointName: Output<String>? = null,
    public val privateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnet: Output<SubnetArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PrivateEndpointArgs =
        com.pulumi.azurenative.network.PrivateEndpointArgs.builder()
            .applicationSecurityGroups(
                applicationSecurityGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .customDnsConfigs(
                customDnsConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customNetworkInterfaceName(customNetworkInterfaceName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .manualPrivateLinkServiceConnections(
                manualPrivateLinkServiceConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateEndpointName(privateEndpointName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnections(
                privateLinkServiceConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointArgs].
 */
@PulumiTagMarker
public class PrivateEndpointArgsBuilder internal constructor() {
    private var applicationSecurityGroups: Output<List<ApplicationSecurityGroupArgs>>? = null

    private var customDnsConfigs: Output<List<CustomDnsConfigPropertiesFormatArgs>>? = null

    private var customNetworkInterfaceName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<PrivateEndpointIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var manualPrivateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? =
        null

    private var privateEndpointName: Output<String>? = null

    private var privateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnet: Output<SubnetArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("jqmynkqmrtbpjtek")
    public suspend
    fun applicationSecurityGroups(`value`: Output<List<ApplicationSecurityGroupArgs>>) {
        this.applicationSecurityGroups = value
    }

    @JvmName("akhtohsbegqoxgng")
    public suspend fun applicationSecurityGroups(
        vararg
        values: Output<ApplicationSecurityGroupArgs>,
    ) {
        this.applicationSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("ggqrwfhbnpqqeuoa")
    public suspend fun applicationSecurityGroups(values: List<Output<ApplicationSecurityGroupArgs>>) {
        this.applicationSecurityGroups = Output.all(values)
    }

    /**
     * @param value An array of custom dns configurations.
     */
    @JvmName("rjpefxgfansjhixd")
    public suspend fun customDnsConfigs(`value`: Output<List<CustomDnsConfigPropertiesFormatArgs>>) {
        this.customDnsConfigs = value
    }

    @JvmName("aurulxfcjetlqbhi")
    public suspend fun customDnsConfigs(vararg values: Output<CustomDnsConfigPropertiesFormatArgs>) {
        this.customDnsConfigs = Output.all(values.asList())
    }

    /**
     * @param values An array of custom dns configurations.
     */
    @JvmName("itvhafcaptquupie")
    public suspend fun customDnsConfigs(values: List<Output<CustomDnsConfigPropertiesFormatArgs>>) {
        this.customDnsConfigs = Output.all(values)
    }

    /**
     * @param value The custom name of the network interface attached to the private endpoint.
     */
    @JvmName("iypprdbxcqueokmp")
    public suspend fun customNetworkInterfaceName(`value`: Output<String>) {
        this.customNetworkInterfaceName = value
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("rewfqdxieslvefxr")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("geyejqjevlqwnnxw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("qkejahxvujwybxqr")
    public suspend fun ipConfigurations(`value`: Output<List<PrivateEndpointIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("ofydccldayxfxosn")
    public suspend fun ipConfigurations(vararg values: Output<PrivateEndpointIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("cbmhirqiwlfprodd")
    public suspend fun ipConfigurations(values: List<Output<PrivateEndpointIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("voqfcufcewijlsxm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("uxkgpttbxudxsurj")
    public suspend
    fun manualPrivateLinkServiceConnections(`value`: Output<List<PrivateLinkServiceConnectionArgs>>) {
        this.manualPrivateLinkServiceConnections = value
    }

    @JvmName("lkiipmqghrlcgbto")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        values: Output<PrivateLinkServiceConnectionArgs>,
    ) {
        this.manualPrivateLinkServiceConnections = Output.all(values.asList())
    }

    /**
     * @param values A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("oarviyksenhhfvso")
    public suspend
    fun manualPrivateLinkServiceConnections(values: List<Output<PrivateLinkServiceConnectionArgs>>) {
        this.manualPrivateLinkServiceConnections = Output.all(values)
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("htqqsnbgcjxpjvdu")
    public suspend fun privateEndpointName(`value`: Output<String>) {
        this.privateEndpointName = value
    }

    /**
     * @param value A grouping of information about the connection to the remote resource.
     */
    @JvmName("udcjjihengaiadmu")
    public suspend
    fun privateLinkServiceConnections(`value`: Output<List<PrivateLinkServiceConnectionArgs>>) {
        this.privateLinkServiceConnections = value
    }

    @JvmName("tcmomrqmhkpqornn")
    public suspend fun privateLinkServiceConnections(
        vararg
        values: Output<PrivateLinkServiceConnectionArgs>,
    ) {
        this.privateLinkServiceConnections = Output.all(values.asList())
    }

    /**
     * @param values A grouping of information about the connection to the remote resource.
     */
    @JvmName("lrgfpfltumphkwcb")
    public suspend
    fun privateLinkServiceConnections(values: List<Output<PrivateLinkServiceConnectionArgs>>) {
        this.privateLinkServiceConnections = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jydlcafvuyrtvxio")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ID of the subnet from which the private IP will be allocated.
     */
    @JvmName("drxnblmhuaadfjsw")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qnpncqdohuevvhbj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("usejjnbxarrpcppi")
    public suspend fun applicationSecurityGroups(`value`: List<ApplicationSecurityGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("jsymmwrmctippcno")
    public suspend
    fun applicationSecurityGroups(argument: List<suspend ApplicationSecurityGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("bftotrnomcmkfifj")
    public suspend fun applicationSecurityGroups(
        vararg
        argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param argument Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("hokacqfgajkentlk")
    public suspend
    fun applicationSecurityGroups(argument: suspend ApplicationSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationSecurityGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param values Application security groups in which the private endpoint IP configuration is included.
     */
    @JvmName("ddpekhoquknovmdt")
    public suspend fun applicationSecurityGroups(vararg values: ApplicationSecurityGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationSecurityGroups = mapped
    }

    /**
     * @param value An array of custom dns configurations.
     */
    @JvmName("uqiyckwlopbgofwl")
    public suspend fun customDnsConfigs(`value`: List<CustomDnsConfigPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDnsConfigs = mapped
    }

    /**
     * @param argument An array of custom dns configurations.
     */
    @JvmName("ehmjagkohpkjuoxj")
    public suspend
    fun customDnsConfigs(argument: List<suspend CustomDnsConfigPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomDnsConfigPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDnsConfigs = mapped
    }

    /**
     * @param argument An array of custom dns configurations.
     */
    @JvmName("wopduyrhcjkfnsnj")
    public suspend fun customDnsConfigs(
        vararg
        argument: suspend CustomDnsConfigPropertiesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomDnsConfigPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDnsConfigs = mapped
    }

    /**
     * @param argument An array of custom dns configurations.
     */
    @JvmName("vgmypluoikttvrcw")
    public suspend
    fun customDnsConfigs(argument: suspend CustomDnsConfigPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomDnsConfigPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customDnsConfigs = mapped
    }

    /**
     * @param values An array of custom dns configurations.
     */
    @JvmName("kkalykvkdqfpnttf")
    public suspend fun customDnsConfigs(vararg values: CustomDnsConfigPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDnsConfigs = mapped
    }

    /**
     * @param value The custom name of the network interface attached to the private endpoint.
     */
    @JvmName("asxsarkhjpaefwky")
    public suspend fun customNetworkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customNetworkInterfaceName = mapped
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("abysseiujbsjxwiv")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the load balancer.
     */
    @JvmName("lumqhvvgcctjjtxh")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wfsrwsmoyijatoal")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("jrupelelsowfgqeu")
    public suspend fun ipConfigurations(`value`: List<PrivateEndpointIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("sqamfjigteoonwuw")
    public suspend
    fun ipConfigurations(argument: List<suspend PrivateEndpointIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("yjxwwubomxtxancc")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend PrivateEndpointIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("gxasdwpeyxyotdij")
    public suspend
    fun ipConfigurations(argument: suspend PrivateEndpointIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    @JvmName("bkikdblqiaewyrkh")
    public suspend fun ipConfigurations(vararg values: PrivateEndpointIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lxhlsqsqpqwtjtox")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("bpercrbvhhqxnowi")
    public suspend
    fun manualPrivateLinkServiceConnections(`value`: List<PrivateLinkServiceConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("vckuselxnkdxnuuy")
    public suspend
    fun manualPrivateLinkServiceConnections(argument: List<suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("tlsjshqvjchkidod")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param argument A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("uxqrxcoxkpaxdddq")
    public suspend
    fun manualPrivateLinkServiceConnections(argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param values A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    @JvmName("fjqnucqfmlibjskb")
    public suspend fun manualPrivateLinkServiceConnections(
        vararg
        values: PrivateLinkServiceConnectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manualPrivateLinkServiceConnections = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("qwgkhfkixqkqpohv")
    public suspend fun privateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointName = mapped
    }

    /**
     * @param value A grouping of information about the connection to the remote resource.
     */
    @JvmName("cynveuhsfdtglugl")
    public suspend
    fun privateLinkServiceConnections(`value`: List<PrivateLinkServiceConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param argument A grouping of information about the connection to the remote resource.
     */
    @JvmName("wlqpgfyxapmjwqbh")
    public suspend
    fun privateLinkServiceConnections(argument: List<suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param argument A grouping of information about the connection to the remote resource.
     */
    @JvmName("lbreobjjvtvosqyv")
    public suspend fun privateLinkServiceConnections(
        vararg
        argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param argument A grouping of information about the connection to the remote resource.
     */
    @JvmName("lytkoiukwwhrdpmp")
    public suspend
    fun privateLinkServiceConnections(argument: suspend PrivateLinkServiceConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkServiceConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param values A grouping of information about the connection to the remote resource.
     */
    @JvmName("vgepcfanpwtqnlce")
    public suspend fun privateLinkServiceConnections(
        vararg
        values: PrivateLinkServiceConnectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnections = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qwdqkhnthkmslnoo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ID of the subnet from which the private IP will be allocated.
     */
    @JvmName("wtgpfdhnbvqenfgw")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The ID of the subnet from which the private IP will be allocated.
     */
    @JvmName("uiggpuvdnxkpeene")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("latoktiggmvvnjrc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sfnldaibrytoylwo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PrivateEndpointArgs = PrivateEndpointArgs(
        applicationSecurityGroups = applicationSecurityGroups,
        customDnsConfigs = customDnsConfigs,
        customNetworkInterfaceName = customNetworkInterfaceName,
        extendedLocation = extendedLocation,
        id = id,
        ipConfigurations = ipConfigurations,
        location = location,
        manualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections,
        privateEndpointName = privateEndpointName,
        privateLinkServiceConnections = privateLinkServiceConnections,
        resourceGroupName = resourceGroupName,
        subnet = subnet,
        tags = tags,
    )
}
