@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin

/**
 * Builder for [PrivateLinkServicePrivateEndpointConnection].
 */
@PulumiTagMarker
public class PrivateLinkServicePrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateLinkServicePrivateEndpointConnectionArgs =
        PrivateLinkServicePrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend PrivateLinkServicePrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = PrivateLinkServicePrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateLinkServicePrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.PrivateLinkServicePrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateLinkServicePrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * PrivateEndpointConnection resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### approve or reject private end point connection for a private link service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateLinkServicePrivateEndpointConnection = new AzureNative.Network.PrivateLinkServicePrivateEndpointConnection("privateLinkServicePrivateEndpointConnection", new()
 *     {
 *         Name = "testPlePeConnection",
 *         PeConnectionName = "testPlePeConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.Network.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "approved it for some reason.",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rg1",
 *         ServiceName = "testPls",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateLinkServicePrivateEndpointConnection(ctx, "privateLinkServicePrivateEndpointConnection", &network.PrivateLinkServicePrivateEndpointConnectionArgs{
 * 			Name:             pulumi.String("testPlePeConnection"),
 * 			PeConnectionName: pulumi.String("testPlePeConnection"),
 * 			PrivateLinkServiceConnectionState: &network.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("approved it for some reason."),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("testPls"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateLinkServicePrivateEndpointConnection;
 * import com.pulumi.azurenative.network.PrivateLinkServicePrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateLinkServicePrivateEndpointConnection = new PrivateLinkServicePrivateEndpointConnection("privateLinkServicePrivateEndpointConnection", PrivateLinkServicePrivateEndpointConnectionArgs.builder()
 *             .name("testPlePeConnection")
 *             .peConnectionName("testPlePeConnection")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "approved it for some reason."),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rg1")
 *             .serviceName("testPls")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateLinkServicePrivateEndpointConnection testPlePeConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateLinkServices/{serviceName}/privateEndpointConnections/{peConnectionName}
 * ```
 */
public class PrivateLinkServicePrivateEndpointConnection internal constructor(
    override val javaResource:
    com.pulumi.azurenative.network.PrivateLinkServicePrivateEndpointConnection,
) : KotlinCustomResource(javaResource, PrivateLinkServicePrivateEndpointConnectionMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The consumer link id.
     */
    public val linkIdentifier: Output<String>
        get() = javaResource.linkIdentifier().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointResponseToKotlin(args0)
            })
        })

    /**
     * The location of the private endpoint.
     */
    public val privateEndpointLocation: Output<String>
        get() = javaResource.privateEndpointLocation().applyValue({ args0 -> args0 })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>?
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    privateLinkServiceConnectionStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateLinkServicePrivateEndpointConnectionMapper :
    ResourceMapper<PrivateLinkServicePrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateLinkServicePrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): PrivateLinkServicePrivateEndpointConnection =
        PrivateLinkServicePrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.network.PrivateLinkServicePrivateEndpointConnection,
        )
}

/**
 * @see [PrivateLinkServicePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateLinkServicePrivateEndpointConnection].
 */
public suspend fun privateLinkServicePrivateEndpointConnection(
    name: String,
    block: suspend PrivateLinkServicePrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    PrivateLinkServicePrivateEndpointConnection {
    val builder = PrivateLinkServicePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateLinkServicePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateLinkServicePrivateEndpointConnection(name: String):
    PrivateLinkServicePrivateEndpointConnection {
    val builder = PrivateLinkServicePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
