@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse
import com.pulumi.azurenative.network.kotlin.outputs.RouteFilterRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse.Companion.toKotlin as expressRouteCircuitPeeringResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RouteFilterRuleResponse.Companion.toKotlin as routeFilterRuleResponseToKotlin

/**
 * Builder for [RouteFilter].
 */
@PulumiTagMarker
public class RouteFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteFilterArgs = RouteFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteFilterArgsBuilder.() -> Unit) {
        val builder = RouteFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteFilter {
        val builtJavaResource = com.pulumi.azurenative.network.RouteFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteFilter(builtJavaResource)
    }
}

/**
 * Route Filter Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### RouteFilterCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeFilter = new AzureNative.Network.RouteFilter("routeFilter", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         RouteFilterName = "filterName",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RouteFilterRuleArgs
 *             {
 *                 Access = "Allow",
 *                 Communities = new[]
 *                 {
 *                     "12076:5030",
 *                     "12076:5040",
 *                 },
 *                 Name = "ruleName",
 *                 RouteFilterRuleType = "Community",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteFilter(ctx, "routeFilter", &network.RouteFilterArgs{
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteFilterName:   pulumi.String("filterName"),
 * 			Rules: []network.RouteFilterRuleTypeArgs{
 * 				{
 * 					Access: pulumi.String("Allow"),
 * 					Communities: pulumi.StringArray{
 * 						pulumi.String("12076:5030"),
 * 						pulumi.String("12076:5040"),
 * 					},
 * 					Name:                pulumi.String("ruleName"),
 * 					RouteFilterRuleType: pulumi.String("Community"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteFilter;
 * import com.pulumi.azurenative.network.RouteFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeFilter = new RouteFilter("routeFilter", RouteFilterArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .routeFilterName("filterName")
 *             .rules(Map.ofEntries(
 *                 Map.entry("access", "Allow"),
 *                 Map.entry("communities",
 *                     "12076:5030",
 *                     "12076:5040"),
 *                 Map.entry("name", "ruleName"),
 *                 Map.entry("routeFilterRuleType", "Community")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteFilter filterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}
 * ```
 */
public class RouteFilter internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RouteFilter,
) : KotlinCustomResource(javaResource, RouteFilterMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A collection of references to express route circuit ipv6 peerings.
     */
    public val ipv6Peerings: Output<List<ExpressRouteCircuitPeeringResponse>>
        get() = javaResource.ipv6Peerings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteCircuitPeeringResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of references to express route circuit peerings.
     */
    public val peerings: Output<List<ExpressRouteCircuitPeeringResponse>>
        get() = javaResource.peerings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    expressRouteCircuitPeeringResponseToKotlin(args0)
                })
            })
        })

    /**
     * The provisioning state of the route filter resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Collection of RouteFilterRules contained within a route filter.
     */
    public val rules: Output<List<RouteFilterRuleResponse>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> routeFilterRuleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RouteFilterMapper : ResourceMapper<RouteFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RouteFilter::class == javaResource::class

    override fun map(javaResource: Resource): RouteFilter = RouteFilter(
        javaResource as
            com.pulumi.azurenative.network.RouteFilter,
    )
}

/**
 * @see [RouteFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteFilter].
 */
public suspend fun routeFilter(name: String, block: suspend RouteFilterResourceBuilder.() -> Unit):
    RouteFilter {
    val builder = RouteFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeFilter(name: String): RouteFilter {
    val builder = RouteFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
