@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RouteFilterRule].
 */
@PulumiTagMarker
public class RouteFilterRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteFilterRuleArgs = RouteFilterRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteFilterRuleArgsBuilder.() -> Unit) {
        val builder = RouteFilterRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteFilterRule {
        val builtJavaResource = com.pulumi.azurenative.network.RouteFilterRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteFilterRule(builtJavaResource)
    }
}

/**
 * Route Filter Rule Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2017-03-01, 2017-10-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### RouteFilterRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeFilterRule = new AzureNative.Network.RouteFilterRule("routeFilterRule", new()
 *     {
 *         Access = "Allow",
 *         Communities = new[]
 *         {
 *             "12076:5030",
 *             "12076:5040",
 *         },
 *         ResourceGroupName = "rg1",
 *         RouteFilterName = "filterName",
 *         RouteFilterRuleType = "Community",
 *         RuleName = "ruleName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteFilterRule(ctx, "routeFilterRule", &network.RouteFilterRuleArgs{
 * 			Access: pulumi.String("Allow"),
 * 			Communities: pulumi.StringArray{
 * 				pulumi.String("12076:5030"),
 * 				pulumi.String("12076:5040"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			RouteFilterName:     pulumi.String("filterName"),
 * 			RouteFilterRuleType: pulumi.String("Community"),
 * 			RuleName:            pulumi.String("ruleName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteFilterRule;
 * import com.pulumi.azurenative.network.RouteFilterRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeFilterRule = new RouteFilterRule("routeFilterRule", RouteFilterRuleArgs.builder()
 *             .access("Allow")
 *             .communities(
 *                 "12076:5030",
 *                 "12076:5040")
 *             .resourceGroupName("rg1")
 *             .routeFilterName("filterName")
 *             .routeFilterRuleType("Community")
 *             .ruleName("ruleName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteFilterRule ruleName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}
 * ```
 */
public class RouteFilterRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RouteFilterRule,
) : KotlinCustomResource(javaResource, RouteFilterRuleMapper) {
    /**
     * The access type of the rule.
     */
    public val access: Output<String>
        get() = javaResource.access().applyValue({ args0 -> args0 })

    /**
     * The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    public val communities: Output<List<String>>
        get() = javaResource.communities().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the route filter rule resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The rule type of the rule.
     */
    public val routeFilterRuleType: Output<String>
        get() = javaResource.routeFilterRuleType().applyValue({ args0 -> args0 })
}

public object RouteFilterRuleMapper : ResourceMapper<RouteFilterRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RouteFilterRule::class == javaResource::class

    override fun map(javaResource: Resource): RouteFilterRule = RouteFilterRule(
        javaResource as
            com.pulumi.azurenative.network.RouteFilterRule,
    )
}

/**
 * @see [RouteFilterRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteFilterRule].
 */
public suspend fun routeFilterRule(
    name: String,
    block: suspend RouteFilterRuleResourceBuilder.() -> Unit,
): RouteFilterRule {
    val builder = RouteFilterRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteFilterRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeFilterRule(name: String): RouteFilterRule {
    val builder = RouteFilterRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
