@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RouteFilterRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.Access
import com.pulumi.azurenative.network.kotlin.enums.RouteFilterRuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Route Filter Rule Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2017-03-01, 2017-10-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### RouteFilterRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeFilterRule = new AzureNative.Network.RouteFilterRule("routeFilterRule", new()
 *     {
 *         Access = "Allow",
 *         Communities = new[]
 *         {
 *             "12076:5030",
 *             "12076:5040",
 *         },
 *         ResourceGroupName = "rg1",
 *         RouteFilterName = "filterName",
 *         RouteFilterRuleType = "Community",
 *         RuleName = "ruleName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteFilterRule(ctx, "routeFilterRule", &network.RouteFilterRuleArgs{
 * 			Access: pulumi.String("Allow"),
 * 			Communities: pulumi.StringArray{
 * 				pulumi.String("12076:5030"),
 * 				pulumi.String("12076:5040"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			RouteFilterName:     pulumi.String("filterName"),
 * 			RouteFilterRuleType: pulumi.String("Community"),
 * 			RuleName:            pulumi.String("ruleName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteFilterRule;
 * import com.pulumi.azurenative.network.RouteFilterRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeFilterRule = new RouteFilterRule("routeFilterRule", RouteFilterRuleArgs.builder()
 *             .access("Allow")
 *             .communities(
 *                 "12076:5030",
 *                 "12076:5040")
 *             .resourceGroupName("rg1")
 *             .routeFilterName("filterName")
 *             .routeFilterRuleType("Community")
 *             .ruleName("ruleName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteFilterRule ruleName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/routeFilters/{routeFilterName}/routeFilterRules/{ruleName}
 * ```
 * @property access The access type of the rule.
 * @property communities The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The name of the resource group.
 * @property routeFilterName The name of the route filter.
 * @property routeFilterRuleType The rule type of the rule.
 * @property ruleName The name of the route filter rule.
 */
public data class RouteFilterRuleArgs(
    public val access: Output<Either<String, Access>>? = null,
    public val communities: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeFilterName: Output<String>? = null,
    public val routeFilterRuleType: Output<Either<String, RouteFilterRuleType>>? = null,
    public val ruleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RouteFilterRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RouteFilterRuleArgs =
        com.pulumi.azurenative.network.RouteFilterRuleArgs.builder()
            .access(
                access?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .communities(communities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeFilterName(routeFilterName?.applyValue({ args0 -> args0 }))
            .routeFilterRuleType(
                routeFilterRuleType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ruleName(ruleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteFilterRuleArgs].
 */
@PulumiTagMarker
public class RouteFilterRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, Access>>? = null

    private var communities: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeFilterName: Output<String>? = null

    private var routeFilterRuleType: Output<Either<String, RouteFilterRuleType>>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value The access type of the rule.
     */
    @JvmName("mcxwfvvdxafqmtux")
    public suspend fun access(`value`: Output<Either<String, Access>>) {
        this.access = value
    }

    /**
     * @param value The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("tqsqixnqrkfeaeft")
    public suspend fun communities(`value`: Output<List<String>>) {
        this.communities = value
    }

    @JvmName("pqemvhgyjxrodacj")
    public suspend fun communities(vararg values: Output<String>) {
        this.communities = Output.all(values.asList())
    }

    /**
     * @param values The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("dxtxfhmttkgiucgn")
    public suspend fun communities(values: List<Output<String>>) {
        this.communities = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ugacnqlvcvvsnpbp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xeqxeebthxjodawu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("vxmetkgsjipsjrju")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ugkipmptlacujsxd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the route filter.
     */
    @JvmName("xikbvohnscinhcvx")
    public suspend fun routeFilterName(`value`: Output<String>) {
        this.routeFilterName = value
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("sgdubvtqlnjmfigp")
    public suspend fun routeFilterRuleType(`value`: Output<Either<String, RouteFilterRuleType>>) {
        this.routeFilterRuleType = value
    }

    /**
     * @param value The name of the route filter rule.
     */
    @JvmName("kdojispoeolbhwgw")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The access type of the rule.
     */
    @JvmName("awfepyehvchkoijm")
    public suspend fun access(`value`: Either<String, Access>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The access type of the rule.
     */
    @JvmName("hyaysrexoerwxfjf")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Access>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The access type of the rule.
     */
    @JvmName("cqhkubxomhgrmdrd")
    public fun access(`value`: Access) {
        val toBeMapped = Either.ofRight<String, Access>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("hdkhrypfuwlicsgo")
    public suspend fun communities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param values The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("ddwwdeuxrmtyvpbu")
    public suspend fun communities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xwnppcgpxvvdalgk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("uifyxbdekuapibki")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ofnonpepafthhfhe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bwnhrqcajkbhoriy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route filter.
     */
    @JvmName("vpjilkmefoihxgdx")
    public suspend fun routeFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilterName = mapped
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("mdvxfgdvjryriujh")
    public suspend fun routeFilterRuleType(`value`: Either<String, RouteFilterRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilterRuleType = mapped
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("owdicqdrcptygluc")
    public fun routeFilterRuleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteFilterRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeFilterRuleType = mapped
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("ldckxhlydlqlxlko")
    public fun routeFilterRuleType(`value`: RouteFilterRuleType) {
        val toBeMapped = Either.ofRight<String, RouteFilterRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeFilterRuleType = mapped
    }

    /**
     * @param value The name of the route filter rule.
     */
    @JvmName("ehxwrykyiumxtjhf")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build(): RouteFilterRuleArgs = RouteFilterRuleArgs(
        access = access,
        communities = communities,
        id = id,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        routeFilterName = routeFilterName,
        routeFilterRuleType = routeFilterRuleType,
        ruleName = ruleName,
    )
}
