@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.RouteMapRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.RouteMapRuleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RouteMap].
 */
@PulumiTagMarker
public class RouteMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RouteMapArgs = RouteMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RouteMapArgsBuilder.() -> Unit) {
        val builder = RouteMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RouteMap {
        val builtJavaResource = com.pulumi.azurenative.network.RouteMap(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RouteMap(builtJavaResource)
    }
}

/**
 * The RouteMap child resource of a Virtual hub.
 * Azure REST API version: 2023-02-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### RouteMapPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routeMap = new AzureNative.Network.RouteMap("routeMap", new()
 *     {
 *         AssociatedInboundConnections = new[]
 *         {
 *             "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteGateways/exrGateway1/expressRouteConnections/exrConn1",
 *         },
 *         AssociatedOutboundConnections = new[] {},
 *         ResourceGroupName = "rg1",
 *         RouteMapName = "routeMap1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RouteMapRuleArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.ActionArgs
 *                     {
 *                         Parameters = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.ParameterArgs
 *                             {
 *                                 AsPath = new[]
 *                                 {
 *                                     "22334",
 *                                 },
 *                                 Community = new() { },
 *                                 RoutePrefix = new() { },
 *                             },
 *                         },
 *                         Type = "Add",
 *                     },
 *                 },
 *                 MatchCriteria = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.CriterionArgs
 *                     {
 *                         AsPath = new() { },
 *                         Community = new() { },
 *                         MatchCondition = "Contains",
 *                         RoutePrefix = new[]
 *                         {
 *                             "10.0.0.0/8",
 *                         },
 *                     },
 *                 },
 *                 Name = "rule1",
 *                 NextStepIfMatched = "Continue",
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRouteMap(ctx, "routeMap", &network.RouteMapArgs{
 * 			AssociatedInboundConnections: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteGateways/exrGateway1/expressRouteConnections/exrConn1"),
 * 			},
 * 			AssociatedOutboundConnections: pulumi.StringArray{},
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 			RouteMapName:                  pulumi.String("routeMap1"),
 * 			Rules: []network.RouteMapRuleArgs{
 * 				{
 * 					Actions: network.ActionArray{
 * 						{
 * 							Parameters: network.ParameterArray{
 * 								{
 * 									AsPath: pulumi.StringArray{
 * 										pulumi.String("22334"),
 * 									},
 * 									Community:   pulumi.StringArray{},
 * 									RoutePrefix: pulumi.StringArray{},
 * 								},
 * 							},
 * 							Type: pulumi.String("Add"),
 * 						},
 * 					},
 * 					MatchCriteria: network.CriterionArray{
 * 						{
 * 							AsPath:         pulumi.StringArray{},
 * 							Community:      pulumi.StringArray{},
 * 							MatchCondition: pulumi.String("Contains"),
 * 							RoutePrefix: pulumi.StringArray{
 * 								pulumi.String("10.0.0.0/8"),
 * 							},
 * 						},
 * 					},
 * 					Name:              pulumi.String("rule1"),
 * 					NextStepIfMatched: pulumi.String("Continue"),
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RouteMap;
 * import com.pulumi.azurenative.network.RouteMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routeMap = new RouteMap("routeMap", RouteMapArgs.builder()
 *             .associatedInboundConnections("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/expressRouteGateways/exrGateway1/expressRouteConnections/exrConn1")
 *             .associatedOutboundConnections()
 *             .resourceGroupName("rg1")
 *             .routeMapName("routeMap1")
 *             .rules(Map.ofEntries(
 *                 Map.entry("actions", Map.ofEntries(
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("asPath", "22334"),
 *                         Map.entry("community", ),
 *                         Map.entry("routePrefix", )
 *                     )),
 *                     Map.entry("type", "Add")
 *                 )),
 *                 Map.entry("matchCriteria", Map.ofEntries(
 *                     Map.entry("asPath", ),
 *                     Map.entry("community", ),
 *                     Map.entry("matchCondition", "Contains"),
 *                     Map.entry("routePrefix", "10.0.0.0/8")
 *                 )),
 *                 Map.entry("name", "rule1"),
 *                 Map.entry("nextStepIfMatched", "Continue")
 *             ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RouteMap routeMap1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeMaps/{routeMapName}
 * ```
 */
public class RouteMap internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RouteMap,
) : KotlinCustomResource(javaResource, RouteMapMapper) {
    /**
     * List of connections which have this RoutMap associated for inbound traffic.
     */
    public val associatedInboundConnections: Output<List<String>>?
        get() = javaResource.associatedInboundConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of connections which have this RoutMap associated for outbound traffic.
     */
    public val associatedOutboundConnections: Output<List<String>>?
        get() = javaResource.associatedOutboundConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the RouteMap resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of RouteMap rules to be applied.
     */
    public val rules: Output<List<RouteMapRuleResponse>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RouteMapMapper : ResourceMapper<RouteMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RouteMap::class == javaResource::class

    override fun map(javaResource: Resource): RouteMap = RouteMap(
        javaResource as
            com.pulumi.azurenative.network.RouteMap,
    )
}

/**
 * @see [RouteMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RouteMap].
 */
public suspend fun routeMap(name: String, block: suspend RouteMapResourceBuilder.() -> Unit):
    RouteMap {
    val builder = RouteMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RouteMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routeMap(name: String): RouteMap {
    val builder = RouteMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
