@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.RoutingPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.RoutingPolicyResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RoutingIntent].
 */
@PulumiTagMarker
public class RoutingIntentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoutingIntentArgs = RoutingIntentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoutingIntentArgsBuilder.() -> Unit) {
        val builder = RoutingIntentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoutingIntent {
        val builtJavaResource = com.pulumi.azurenative.network.RoutingIntent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RoutingIntent(builtJavaResource)
    }
}

/**
 * The routing intent child resource of a Virtual hub.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-01-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### RouteTablePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routingIntent = new AzureNative.Network.RoutingIntent("routingIntent", new()
 *     {
 *         ResourceGroupName = "rg1",
 *         RoutingIntentName = "Intent1",
 *         RoutingPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.RoutingPolicyArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "Internet",
 *                 },
 *                 Name = "InternetTraffic",
 *                 NextHop = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1",
 *             },
 *             new AzureNative.Network.Inputs.RoutingPolicyArgs
 *             {
 *                 Destinations = new[]
 *                 {
 *                     "PrivateTraffic",
 *                 },
 *                 Name = "PrivateTrafficPolicy",
 *                 NextHop = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1",
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRoutingIntent(ctx, "routingIntent", &network.RoutingIntentArgs{
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RoutingIntentName: pulumi.String("Intent1"),
 * 			RoutingPolicies: []network.RoutingPolicyArgs{
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("Internet"),
 * 					},
 * 					Name:    pulumi.String("InternetTraffic"),
 * 					NextHop: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1"),
 * 				},
 * 				{
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("PrivateTraffic"),
 * 					},
 * 					Name:    pulumi.String("PrivateTrafficPolicy"),
 * 					NextHop: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1"),
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RoutingIntent;
 * import com.pulumi.azurenative.network.RoutingIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routingIntent = new RoutingIntent("routingIntent", RoutingIntentArgs.builder()
 *             .resourceGroupName("rg1")
 *             .routingIntentName("Intent1")
 *             .routingPolicies(
 *                 Map.ofEntries(
 *                     Map.entry("destinations", "Internet"),
 *                     Map.entry("name", "InternetTraffic"),
 *                     Map.entry("nextHop", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinations", "PrivateTraffic"),
 *                     Map.entry("name", "PrivateTrafficPolicy"),
 *                     Map.entry("nextHop", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/azureFirewalls/azfw1")
 *                 ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RoutingIntent Intent1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routingIntent/{routingIntentName}
 * ```
 */
public class RoutingIntent internal constructor(
    override val javaResource: com.pulumi.azurenative.network.RoutingIntent,
) : KotlinCustomResource(javaResource, RoutingIntentMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the RoutingIntent resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of routing policies.
     */
    public val routingPolicies: Output<List<RoutingPolicyResponse>>?
        get() = javaResource.routingPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RoutingIntentMapper : ResourceMapper<RoutingIntent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.RoutingIntent::class == javaResource::class

    override fun map(javaResource: Resource): RoutingIntent = RoutingIntent(
        javaResource as
            com.pulumi.azurenative.network.RoutingIntent,
    )
}

/**
 * @see [RoutingIntent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoutingIntent].
 */
public suspend fun routingIntent(
    name: String,
    block: suspend RoutingIntentResourceBuilder.() -> Unit,
): RoutingIntent {
    val builder = RoutingIntentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoutingIntent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routingIntent(name: String): RoutingIntent {
    val builder = RoutingIntentResourceBuilder()
    builder.name(name)
    return builder.build()
}
