@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.RulesEngineArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.RulesEngineRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.RulesEngineRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A rules engine configuration containing a list of rules that will run to modify the runtime behavior of the request and response.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create or update a specific Rules Engine Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rulesEngine = new AzureNative.Network.RulesEngine("rulesEngine", new()
 *     {
 *         FrontDoorName = "frontDoor1",
 *         ResourceGroupName = "rg1",
 *         Rules = new[]
 *         {
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     RouteConfigurationOverride = new AzureNative.Network.Inputs.RedirectConfigurationArgs
 *                     {
 *                         CustomFragment = "fragment",
 *                         CustomHost = "www.bing.com",
 *                         CustomPath = "/api",
 *                         CustomQueryString = "a=b",
 *                         OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration",
 *                         RedirectProtocol = "HttpsOnly",
 *                         RedirectType = "Moved",
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "CH",
 *                         },
 *                         RulesEngineMatchVariable = "RemoteAddr",
 *                         RulesEngineOperator = "GeoMatch",
 *                     },
 *                 },
 *                 MatchProcessingBehavior = "Stop",
 *                 Name = "Rule1",
 *                 Priority = 1,
 *             },
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     ResponseHeaderActions = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.HeaderActionArgs
 *                         {
 *                             HeaderActionType = "Overwrite",
 *                             HeaderName = "Cache-Control",
 *                             Value = "public, max-age=31536000",
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "jpg",
 *                         },
 *                         RulesEngineMatchVariable = "RequestFilenameExtension",
 *                         RulesEngineOperator = "Equal",
 *                         Transforms = new[]
 *                         {
 *                             "Lowercase",
 *                         },
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *             },
 *             new AzureNative.Network.Inputs.RulesEngineRuleArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.RulesEngineActionArgs
 *                 {
 *                     RouteConfigurationOverride = new AzureNative.Network.Inputs.ForwardingConfigurationArgs
 *                     {
 *                         BackendPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 *                         },
 *                         CacheConfiguration = new AzureNative.Network.Inputs.CacheConfigurationArgs
 *                         {
 *                             CacheDuration = "P1DT12H20M30S",
 *                             DynamicCompression = "Disabled",
 *                             QueryParameterStripDirective = "StripOnly",
 *                             QueryParameters = "a=b,p=q",
 *                         },
 *                         ForwardingProtocol = "HttpsOnly",
 *                         OdataType = "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.RulesEngineMatchConditionArgs
 *                     {
 *                         NegateCondition = false,
 *                         RulesEngineMatchValue = new[]
 *                         {
 *                             "allowoverride",
 *                         },
 *                         RulesEngineMatchVariable = "RequestHeader",
 *                         RulesEngineOperator = "Equal",
 *                         Selector = "Rules-Engine-Route-Forward",
 *                         Transforms = new[]
 *                         {
 *                             "Lowercase",
 *                         },
 *                     },
 *                 },
 *                 Name = "Rule3",
 *                 Priority = 3,
 *             },
 *         },
 *         RulesEngineName = "rulesEngine1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewRulesEngine(ctx, "rulesEngine", &network.RulesEngineArgs{
 * 			FrontDoorName:     pulumi.String("frontDoor1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Rules: []network.RulesEngineRuleArgs{
 * 				{
 * 					Action: {
 * 						RouteConfigurationOverride: {
 * 							CustomFragment:    "fragment",
 * 							CustomHost:        "www.bing.com",
 * 							CustomPath:        "/api",
 * 							CustomQueryString: "a=b",
 * 							OdataType:         "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration",
 * 							RedirectProtocol:  "HttpsOnly",
 * 							RedirectType:      "Moved",
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						{
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("CH"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String("RemoteAddr"),
 * 							RulesEngineOperator:      pulumi.String("GeoMatch"),
 * 						},
 * 					},
 * 					MatchProcessingBehavior: pulumi.String("Stop"),
 * 					Name:                    pulumi.String("Rule1"),
 * 					Priority:                pulumi.Int(1),
 * 				},
 * 				{
 * 					Action: {
 * 						ResponseHeaderActions: network.HeaderActionArray{
 * 							{
 * 								HeaderActionType: pulumi.String("Overwrite"),
 * 								HeaderName:       pulumi.String("Cache-Control"),
 * 								Value:            pulumi.String("public, max-age=31536000"),
 * 							},
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						{
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("jpg"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String("RequestFilenameExtension"),
 * 							RulesEngineOperator:      pulumi.String("Equal"),
 * 							Transforms: pulumi.StringArray{
 * 								pulumi.String("Lowercase"),
 * 							},
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule2"),
 * 					Priority: pulumi.Int(2),
 * 				},
 * 				{
 * 					Action: {
 * 						RouteConfigurationOverride: {
 * 							BackendPool: {
 * 								Id: "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1",
 * 							},
 * 							CacheConfiguration: {
 * 								CacheDuration:                "P1DT12H20M30S",
 * 								DynamicCompression:           "Disabled",
 * 								QueryParameterStripDirective: "StripOnly",
 * 								QueryParameters:              "a=b,p=q",
 * 							},
 * 							ForwardingProtocol: "HttpsOnly",
 * 							OdataType:          "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration",
 * 						},
 * 					},
 * 					MatchConditions: network.RulesEngineMatchConditionArray{
 * 						{
 * 							NegateCondition: pulumi.Bool(false),
 * 							RulesEngineMatchValue: pulumi.StringArray{
 * 								pulumi.String("allowoverride"),
 * 							},
 * 							RulesEngineMatchVariable: pulumi.String("RequestHeader"),
 * 							RulesEngineOperator:      pulumi.String("Equal"),
 * 							Selector:                 pulumi.String("Rules-Engine-Route-Forward"),
 * 							Transforms: pulumi.StringArray{
 * 								pulumi.String("Lowercase"),
 * 							},
 * 						},
 * 					},
 * 					Name:     pulumi.String("Rule3"),
 * 					Priority: pulumi.Int(3),
 * 				},
 * 			},
 * 			RulesEngineName: pulumi.String("rulesEngine1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.RulesEngine;
 * import com.pulumi.azurenative.network.RulesEngineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rulesEngine = new RulesEngine("rulesEngine", RulesEngineArgs.builder()
 *             .frontDoorName("frontDoor1")
 *             .resourceGroupName("rg1")
 *             .rules(
 *                 Map.ofEntries(
 *                     Map.entry("action", Map.of("routeConfigurationOverride", Map.ofEntries(
 *                         Map.entry("customFragment", "fragment"),
 *                         Map.entry("customHost", "www.bing.com"),
 *                         Map.entry("customPath", "/api"),
 *                         Map.entry("customQueryString", "a=b"),
 *                         Map.entry("odataType", "#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration"),
 *                         Map.entry("redirectProtocol", "HttpsOnly"),
 *                         Map.entry("redirectType", "Moved")
 *                     ))),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("rulesEngineMatchValue", "CH"),
 *                         Map.entry("rulesEngineMatchVariable", "RemoteAddr"),
 *                         Map.entry("rulesEngineOperator", "GeoMatch")
 *                     )),
 *                     Map.entry("matchProcessingBehavior", "Stop"),
 *                     Map.entry("name", "Rule1"),
 *                     Map.entry("priority", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", Map.of("responseHeaderActions", Map.ofEntries(
 *                         Map.entry("headerActionType", "Overwrite"),
 *                         Map.entry("headerName", "Cache-Control"),
 *                         Map.entry("value", "public, max-age=31536000")
 *                     ))),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("rulesEngineMatchValue", "jpg"),
 *                         Map.entry("rulesEngineMatchVariable", "RequestFilenameExtension"),
 *                         Map.entry("rulesEngineOperator", "Equal"),
 *                         Map.entry("transforms", "Lowercase")
 *                     )),
 *                     Map.entry("name", "Rule2"),
 *                     Map.entry("priority", 2)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", Map.of("routeConfigurationOverride", Map.ofEntries(
 *                         Map.entry("backendPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/frontDoors/frontDoor1/backendPools/backendPool1")),
 *                         Map.entry("cacheConfiguration", Map.ofEntries(
 *                             Map.entry("cacheDuration", "P1DT12H20M30S"),
 *                             Map.entry("dynamicCompression", "Disabled"),
 *                             Map.entry("queryParameterStripDirective", "StripOnly"),
 *                             Map.entry("queryParameters", "a=b,p=q")
 *                         )),
 *                         Map.entry("forwardingProtocol", "HttpsOnly"),
 *                         Map.entry("odataType", "#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration")
 *                     ))),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("negateCondition", false),
 *                         Map.entry("rulesEngineMatchValue", "allowoverride"),
 *                         Map.entry("rulesEngineMatchVariable", "RequestHeader"),
 *                         Map.entry("rulesEngineOperator", "Equal"),
 *                         Map.entry("selector", "Rules-Engine-Route-Forward"),
 *                         Map.entry("transforms", "Lowercase")
 *                     )),
 *                     Map.entry("name", "Rule3"),
 *                     Map.entry("priority", 3)
 *                 ))
 *             .rulesEngineName("rulesEngine1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:RulesEngine rulesEngine1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/rulesEngines/{rulesEngineName}
 * ```
 * @property frontDoorName Name of the Front Door which is globally unique.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rules A list of rules that define a particular Rules Engine Configuration.
 * @property rulesEngineName Name of the Rules Engine which is unique within the Front Door.
 */
public data class RulesEngineArgs(
    public val frontDoorName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rules: Output<List<RulesEngineRuleArgs>>? = null,
    public val rulesEngineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.RulesEngineArgs> {
    override fun toJava(): com.pulumi.azurenative.network.RulesEngineArgs =
        com.pulumi.azurenative.network.RulesEngineArgs.builder()
            .frontDoorName(frontDoorName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .rulesEngineName(rulesEngineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RulesEngineArgs].
 */
@PulumiTagMarker
public class RulesEngineArgsBuilder internal constructor() {
    private var frontDoorName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rules: Output<List<RulesEngineRuleArgs>>? = null

    private var rulesEngineName: Output<String>? = null

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("bbxlaogydqqhceti")
    public suspend fun frontDoorName(`value`: Output<String>) {
        this.frontDoorName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("mgqlirekcxjnshuy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("ewiggqgwqbwqpghy")
    public suspend fun rules(`value`: Output<List<RulesEngineRuleArgs>>) {
        this.rules = value
    }

    @JvmName("sfhmnoinirhalcxo")
    public suspend fun rules(vararg values: Output<RulesEngineRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("bnlbdtbqabgmhhhu")
    public suspend fun rules(values: List<Output<RulesEngineRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Name of the Rules Engine which is unique within the Front Door.
     */
    @JvmName("fumbgrthsansnnln")
    public suspend fun rulesEngineName(`value`: Output<String>) {
        this.rulesEngineName = value
    }

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("xnyhsybmfxofcjau")
    public suspend fun frontDoorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontDoorName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("scsqscjjulvygtao")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("jyfqbqohgsmntyyr")
    public suspend fun rules(`value`: List<RulesEngineRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("dqxiygnvxycjyuhc")
    public suspend fun rules(argument: List<suspend RulesEngineRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RulesEngineRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("vgjadumfehcfbknb")
    public suspend fun rules(vararg argument: suspend RulesEngineRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RulesEngineRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("cxdtqjlyryqftgwd")
    public suspend fun rules(argument: suspend RulesEngineRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RulesEngineRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values A list of rules that define a particular Rules Engine Configuration.
     */
    @JvmName("kucqllrjlnkekfhw")
    public suspend fun rules(vararg values: RulesEngineRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Name of the Rules Engine which is unique within the Front Door.
     */
    @JvmName("ddochwyfmtmrncwo")
    public suspend fun rulesEngineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulesEngineName = mapped
    }

    internal fun build(): RulesEngineArgs = RulesEngineArgs(
        frontDoorName = frontDoorName,
        resourceGroupName = resourceGroupName,
        rules = rules,
        rulesEngineName = rulesEngineName,
    )
}
