@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SecurityAdminConfiguration].
 */
@PulumiTagMarker
public class SecurityAdminConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityAdminConfigurationArgs = SecurityAdminConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityAdminConfigurationArgsBuilder.() -> Unit) {
        val builder = SecurityAdminConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityAdminConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.SecurityAdminConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityAdminConfiguration(builtJavaResource)
    }
}

/**
 * Defines the security admin configuration
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-05-01-preview, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create network manager security admin configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityAdminConfiguration = new AzureNative.Network.SecurityAdminConfiguration("securityAdminConfiguration", new()
 *     {
 *         ApplyOnNetworkIntentPolicyBasedServices = new[]
 *         {
 *             "None",
 *         },
 *         ConfigurationName = "myTestSecurityConfig",
 *         Description = "A sample policy",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityAdminConfiguration(ctx, "securityAdminConfiguration", &network.SecurityAdminConfigurationArgs{
 * 			ApplyOnNetworkIntentPolicyBasedServices: pulumi.StringArray{
 * 				pulumi.String("None"),
 * 			},
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			Description:        pulumi.String("A sample policy"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityAdminConfiguration;
 * import com.pulumi.azurenative.network.SecurityAdminConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityAdminConfiguration = new SecurityAdminConfiguration("securityAdminConfiguration", SecurityAdminConfigurationArgs.builder()
 *             .applyOnNetworkIntentPolicyBasedServices("None")
 *             .configurationName("myTestSecurityConfig")
 *             .description("A sample policy")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityAdminConfiguration myTestSecurityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityAdminConfigurations/{configurationName}
 * ```
 */
public class SecurityAdminConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.SecurityAdminConfiguration,
) : KotlinCustomResource(javaResource, SecurityAdminConfigurationMapper) {
    /**
     * Enum list of network intent policy based services.
     */
    public val applyOnNetworkIntentPolicyBasedServices: Output<List<String>>?
        get() = javaResource.applyOnNetworkIntentPolicyBasedServices().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * A description of the security configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for this resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityAdminConfigurationMapper : ResourceMapper<SecurityAdminConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.SecurityAdminConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): SecurityAdminConfiguration =
        SecurityAdminConfiguration(
            javaResource as
                com.pulumi.azurenative.network.SecurityAdminConfiguration,
        )
}

/**
 * @see [SecurityAdminConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityAdminConfiguration].
 */
public suspend fun securityAdminConfiguration(
    name: String,
    block: suspend SecurityAdminConfigurationResourceBuilder.() -> Unit,
):
    SecurityAdminConfiguration {
    val builder = SecurityAdminConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityAdminConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityAdminConfiguration(name: String): SecurityAdminConfiguration {
    val builder = SecurityAdminConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
