@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.SecurityUserConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DeleteExistingNSGs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the security user configuration
 * Azure REST API version: 2022-04-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Create network manager security user configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityUserConfiguration = new AzureNative.Network.SecurityUserConfiguration("securityUserConfiguration", new()
 *     {
 *         ConfigurationName = "myTestSecurityConfig",
 *         DeleteExistingNSGs = "True",
 *         Description = "A sample policy",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityUserConfiguration(ctx, "securityUserConfiguration", &network.SecurityUserConfigurationArgs{
 * 			ConfigurationName:  pulumi.String("myTestSecurityConfig"),
 * 			DeleteExistingNSGs: pulumi.String("True"),
 * 			Description:        pulumi.String("A sample policy"),
 * 			NetworkManagerName: pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityUserConfiguration;
 * import com.pulumi.azurenative.network.SecurityUserConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityUserConfiguration = new SecurityUserConfiguration("securityUserConfiguration", SecurityUserConfigurationArgs.builder()
 *             .configurationName("myTestSecurityConfig")
 *             .deleteExistingNSGs("True")
 *             .description("A sample policy")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityUserConfiguration myTestSecurityConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/securityUserConfigurations/{configurationName}
 * ```
 * @property configurationName The name of the network manager Security Configuration.
 * @property deleteExistingNSGs Flag if need to delete existing network security groups.
 * @property description A description of the security user configuration.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class SecurityUserConfigurationArgs(
    public val configurationName: Output<String>? = null,
    public val deleteExistingNSGs: Output<Either<String, DeleteExistingNSGs>>? = null,
    public val description: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.SecurityUserConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.SecurityUserConfigurationArgs =
        com.pulumi.azurenative.network.SecurityUserConfigurationArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .deleteExistingNSGs(
                deleteExistingNSGs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityUserConfigurationArgs].
 */
@PulumiTagMarker
public class SecurityUserConfigurationArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var deleteExistingNSGs: Output<Either<String, DeleteExistingNSGs>>? = null

    private var description: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("bccfgyjxyxsgafiy")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Flag if need to delete existing network security groups.
     */
    @JvmName("foeojiqunrkanvac")
    public suspend fun deleteExistingNSGs(`value`: Output<Either<String, DeleteExistingNSGs>>) {
        this.deleteExistingNSGs = value
    }

    /**
     * @param value A description of the security user configuration.
     */
    @JvmName("dysqsgfudykfwnrd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("ycdqvjptxfqixyii")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pqtinfbguuwvoche")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("yjohvpukpcjjdhmj")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Flag if need to delete existing network security groups.
     */
    @JvmName("ktcneijhxguilsel")
    public suspend fun deleteExistingNSGs(`value`: Either<String, DeleteExistingNSGs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteExistingNSGs = mapped
    }

    /**
     * @param value Flag if need to delete existing network security groups.
     */
    @JvmName("wyfhuidjectnflis")
    public fun deleteExistingNSGs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteExistingNSGs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteExistingNSGs = mapped
    }

    /**
     * @param value Flag if need to delete existing network security groups.
     */
    @JvmName("lfgiipvnhahkxloc")
    public fun deleteExistingNSGs(`value`: DeleteExistingNSGs) {
        val toBeMapped = Either.ofRight<String, DeleteExistingNSGs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteExistingNSGs = mapped
    }

    /**
     * @param value A description of the security user configuration.
     */
    @JvmName("gmfxguaxxskfervr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("grmxngkwgkskyats")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qufhyncejekhossx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): SecurityUserConfigurationArgs = SecurityUserConfigurationArgs(
        configurationName = configurationName,
        deleteExistingNSGs = deleteExistingNSGs,
        description = description,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
    )
}
