@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ServiceEndpointPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.ServiceEndpointPolicyDefinitionArgs
import com.pulumi.azurenative.network.kotlin.inputs.ServiceEndpointPolicyDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Service End point policy resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create service endpoint policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpointPolicy = new AzureNative.Network.ServiceEndpointPolicy("serviceEndpointPolicy", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ServiceEndpointPolicyName = "testPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewServiceEndpointPolicy(ctx, "serviceEndpointPolicy", &network.ServiceEndpointPolicyArgs{
 * 			Location:                  pulumi.String("westus"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			ServiceEndpointPolicyName: pulumi.String("testPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicy;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpointPolicy = new ServiceEndpointPolicy("serviceEndpointPolicy", ServiceEndpointPolicyArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .serviceEndpointPolicyName("testPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Create service endpoint policy with definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpointPolicy = new AzureNative.Network.ServiceEndpointPolicy("serviceEndpointPolicy", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ServiceEndpointPolicyDefinitions = new[]
 *         {
 *             new AzureNative.Network.Inputs.ServiceEndpointPolicyDefinitionArgs
 *             {
 *                 Description = "Storage Service EndpointPolicy Definition",
 *                 Name = "StorageServiceEndpointPolicyDefinition",
 *                 Service = "Microsoft.Storage",
 *                 ServiceResources = new[]
 *                 {
 *                     "/subscriptions/subid1",
 *                     "/subscriptions/subid1/resourceGroups/storageRg",
 *                     "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount",
 *                 },
 *             },
 *         },
 *         ServiceEndpointPolicyName = "testPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewServiceEndpointPolicy(ctx, "serviceEndpointPolicy", &network.ServiceEndpointPolicyArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceEndpointPolicyDefinitions: []network.ServiceEndpointPolicyDefinitionTypeArgs{
 * 				{
 * 					Description: pulumi.String("Storage Service EndpointPolicy Definition"),
 * 					Name:        pulumi.String("StorageServiceEndpointPolicyDefinition"),
 * 					Service:     pulumi.String("Microsoft.Storage"),
 * 					ServiceResources: pulumi.StringArray{
 * 						pulumi.String("/subscriptions/subid1"),
 * 						pulumi.String("/subscriptions/subid1/resourceGroups/storageRg"),
 * 						pulumi.String("/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount"),
 * 					},
 * 				},
 * 			},
 * 			ServiceEndpointPolicyName: pulumi.String("testPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicy;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpointPolicy = new ServiceEndpointPolicy("serviceEndpointPolicy", ServiceEndpointPolicyArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .serviceEndpointPolicyDefinitions(Map.ofEntries(
 *                 Map.entry("description", "Storage Service EndpointPolicy Definition"),
 *                 Map.entry("name", "StorageServiceEndpointPolicyDefinition"),
 *                 Map.entry("service", "Microsoft.Storage"),
 *                 Map.entry("serviceResources",
 *                     "/subscriptions/subid1",
 *                     "/subscriptions/subid1/resourceGroups/storageRg",
 *                     "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount")
 *             ))
 *             .serviceEndpointPolicyName("testPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ServiceEndpointPolicy testnsg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}
 * ```
 * @property contextualServiceEndpointPolicies A collection of contextual service endpoint policy.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property serviceAlias The alias indicating if the policy belongs to a service
 * @property serviceEndpointPolicyDefinitions A collection of service endpoint policy definitions of the service endpoint policy.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property serviceEndpointPolicyName The name of the service endpoint policy.
 * @property tags Resource tags.
 */
public data class ServiceEndpointPolicyArgs(
    public val contextualServiceEndpointPolicies: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceAlias: Output<String>? = null,
    public val serviceEndpointPolicyDefinitions: Output<List<ServiceEndpointPolicyDefinitionArgs>>? =
        null,
    public val serviceEndpointPolicyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ServiceEndpointPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ServiceEndpointPolicyArgs =
        com.pulumi.azurenative.network.ServiceEndpointPolicyArgs.builder()
            .contextualServiceEndpointPolicies(
                contextualServiceEndpointPolicies?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceAlias(serviceAlias?.applyValue({ args0 -> args0 }))
            .serviceEndpointPolicyDefinitions(
                serviceEndpointPolicyDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .serviceEndpointPolicyName(serviceEndpointPolicyName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceEndpointPolicyArgs].
 */
@PulumiTagMarker
public class ServiceEndpointPolicyArgsBuilder internal constructor() {
    private var contextualServiceEndpointPolicies: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceAlias: Output<String>? = null

    private var serviceEndpointPolicyDefinitions: Output<List<ServiceEndpointPolicyDefinitionArgs>>? =
        null

    private var serviceEndpointPolicyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A collection of contextual service endpoint policy.
     */
    @JvmName("efrbvraiidaqyirv")
    public suspend fun contextualServiceEndpointPolicies(`value`: Output<List<String>>) {
        this.contextualServiceEndpointPolicies = value
    }

    @JvmName("mvsicohjjgpttcyh")
    public suspend fun contextualServiceEndpointPolicies(vararg values: Output<String>) {
        this.contextualServiceEndpointPolicies = Output.all(values.asList())
    }

    /**
     * @param values A collection of contextual service endpoint policy.
     */
    @JvmName("pklaybmyxbwileqe")
    public suspend fun contextualServiceEndpointPolicies(values: List<Output<String>>) {
        this.contextualServiceEndpointPolicies = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("joogyrqnlculflxm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rmpksfnaeersomnt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lkynopmjjrbehgsu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The alias indicating if the policy belongs to a service
     */
    @JvmName("hltbolebgxnixpdk")
    public suspend fun serviceAlias(`value`: Output<String>) {
        this.serviceAlias = value
    }

    /**
     * @param value A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("kaobmvqsckmuycoh")
    public suspend
    fun serviceEndpointPolicyDefinitions(`value`: Output<List<ServiceEndpointPolicyDefinitionArgs>>) {
        this.serviceEndpointPolicyDefinitions = value
    }

    @JvmName("hbqhpwqqgvmnsngv")
    public suspend fun serviceEndpointPolicyDefinitions(
        vararg
        values: Output<ServiceEndpointPolicyDefinitionArgs>,
    ) {
        this.serviceEndpointPolicyDefinitions = Output.all(values.asList())
    }

    /**
     * @param values A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("klmuhsaofawqnmqs")
    public suspend
    fun serviceEndpointPolicyDefinitions(values: List<Output<ServiceEndpointPolicyDefinitionArgs>>) {
        this.serviceEndpointPolicyDefinitions = Output.all(values)
    }

    /**
     * @param value The name of the service endpoint policy.
     */
    @JvmName("ogffdlbtjvjtklum")
    public suspend fun serviceEndpointPolicyName(`value`: Output<String>) {
        this.serviceEndpointPolicyName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xiivsymmrksxwdow")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A collection of contextual service endpoint policy.
     */
    @JvmName("sqilktuigebbdigm")
    public suspend fun contextualServiceEndpointPolicies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextualServiceEndpointPolicies = mapped
    }

    /**
     * @param values A collection of contextual service endpoint policy.
     */
    @JvmName("eaynbcrqkypkqikp")
    public suspend fun contextualServiceEndpointPolicies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contextualServiceEndpointPolicies = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xoiesgjhfuntpsmf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lkxxjemwwphybmqa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yvtfreuqfxywgyvi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The alias indicating if the policy belongs to a service
     */
    @JvmName("dvvclsxvmjpmusql")
    public suspend fun serviceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAlias = mapped
    }

    /**
     * @param value A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pnxtpfkvuirvfonq")
    public suspend
    fun serviceEndpointPolicyDefinitions(`value`: List<ServiceEndpointPolicyDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param argument A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hdtsoxwovdwelfsi")
    public suspend
    fun serviceEndpointPolicyDefinitions(argument: List<suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param argument A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("sdkvublfwjppsirg")
    public suspend fun serviceEndpointPolicyDefinitions(
        vararg
        argument: suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param argument A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("notiqwjyfgfgfewq")
    public suspend
    fun serviceEndpointPolicyDefinitions(argument: suspend ServiceEndpointPolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceEndpointPolicyDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param values A collection of service endpoint policy definitions of the service endpoint policy.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ojepcgoxngssqmck")
    public suspend fun serviceEndpointPolicyDefinitions(
        vararg
        values: ServiceEndpointPolicyDefinitionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyDefinitions = mapped
    }

    /**
     * @param value The name of the service endpoint policy.
     */
    @JvmName("ehapdjydbtvrxmjo")
    public suspend fun serviceEndpointPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lkclucmuivltcjby")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fcttrnkohwnckqao")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceEndpointPolicyArgs = ServiceEndpointPolicyArgs(
        contextualServiceEndpointPolicies = contextualServiceEndpointPolicies,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        serviceAlias = serviceAlias,
        serviceEndpointPolicyDefinitions = serviceEndpointPolicyDefinitions,
        serviceEndpointPolicyName = serviceEndpointPolicyName,
        tags = tags,
    )
}
