@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ServiceEndpointPolicyDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Service Endpoint policy definitions.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create service endpoint policy definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceEndpointPolicyDefinition = new AzureNative.Network.ServiceEndpointPolicyDefinition("serviceEndpointPolicyDefinition", new()
 *     {
 *         Description = "Storage Service EndpointPolicy Definition",
 *         ResourceGroupName = "rg1",
 *         Service = "Microsoft.Storage",
 *         ServiceEndpointPolicyDefinitionName = "testDefinition",
 *         ServiceEndpointPolicyName = "testPolicy",
 *         ServiceResources = new[]
 *         {
 *             "/subscriptions/subid1",
 *             "/subscriptions/subid1/resourceGroups/storageRg",
 *             "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewServiceEndpointPolicyDefinition(ctx, "serviceEndpointPolicyDefinition", &network.ServiceEndpointPolicyDefinitionArgs{
 * 			Description:                         pulumi.String("Storage Service EndpointPolicy Definition"),
 * 			ResourceGroupName:                   pulumi.String("rg1"),
 * 			Service:                             pulumi.String("Microsoft.Storage"),
 * 			ServiceEndpointPolicyDefinitionName: pulumi.String("testDefinition"),
 * 			ServiceEndpointPolicyName:           pulumi.String("testPolicy"),
 * 			ServiceResources: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/subid1"),
 * 				pulumi.String("/subscriptions/subid1/resourceGroups/storageRg"),
 * 				pulumi.String("/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyDefinition;
 * import com.pulumi.azurenative.network.ServiceEndpointPolicyDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceEndpointPolicyDefinition = new ServiceEndpointPolicyDefinition("serviceEndpointPolicyDefinition", ServiceEndpointPolicyDefinitionArgs.builder()
 *             .description("Storage Service EndpointPolicy Definition")
 *             .resourceGroupName("rg1")
 *             .service("Microsoft.Storage")
 *             .serviceEndpointPolicyDefinitionName("testDefinition")
 *             .serviceEndpointPolicyName("testPolicy")
 *             .serviceResources(
 *                 "/subscriptions/subid1",
 *                 "/subscriptions/subid1/resourceGroups/storageRg",
 *                 "/subscriptions/subid1/resourceGroups/storageRg/providers/Microsoft.Storage/storageAccounts/stAccount")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ServiceEndpointPolicyDefinition testDefinition /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/serviceEndpointPolicies/{serviceEndpointPolicyName}/serviceEndpointPolicyDefinitions/{serviceEndpointPolicyDefinitionName}
 * ```
 * @property description A description for this rule. Restricted to 140 chars.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The name of the resource group.
 * @property service Service endpoint name.
 * @property serviceEndpointPolicyDefinitionName The name of the service endpoint policy definition name.
 * @property serviceEndpointPolicyName The name of the service endpoint policy.
 * @property serviceResources A list of service resources.
 * @property type The type of the resource.
 */
public data class ServiceEndpointPolicyDefinitionArgs(
    public val description: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val service: Output<String>? = null,
    public val serviceEndpointPolicyDefinitionName: Output<String>? = null,
    public val serviceEndpointPolicyName: Output<String>? = null,
    public val serviceResources: Output<List<String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ServiceEndpointPolicyDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ServiceEndpointPolicyDefinitionArgs =
        com.pulumi.azurenative.network.ServiceEndpointPolicyDefinitionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .service(service?.applyValue({ args0 -> args0 }))
            .serviceEndpointPolicyDefinitionName(
                serviceEndpointPolicyDefinitionName?.applyValue({ args0 ->
                    args0
                }),
            )
            .serviceEndpointPolicyName(serviceEndpointPolicyName?.applyValue({ args0 -> args0 }))
            .serviceResources(serviceResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceEndpointPolicyDefinitionArgs].
 */
@PulumiTagMarker
public class ServiceEndpointPolicyDefinitionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var service: Output<String>? = null

    private var serviceEndpointPolicyDefinitionName: Output<String>? = null

    private var serviceEndpointPolicyName: Output<String>? = null

    private var serviceResources: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("hfbsfkysammlppst")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ftuernqwgsmufwhb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("gmwjgipdtyujwncn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("arvnyfaubosyhbca")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Service endpoint name.
     */
    @JvmName("reixvuaukfolyjir")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value The name of the service endpoint policy definition name.
     */
    @JvmName("fhqtqvkkuiguetqx")
    public suspend fun serviceEndpointPolicyDefinitionName(`value`: Output<String>) {
        this.serviceEndpointPolicyDefinitionName = value
    }

    /**
     * @param value The name of the service endpoint policy.
     */
    @JvmName("gxjxpcxokbgpueom")
    public suspend fun serviceEndpointPolicyName(`value`: Output<String>) {
        this.serviceEndpointPolicyName = value
    }

    /**
     * @param value A list of service resources.
     */
    @JvmName("laonvevtnlhfshmk")
    public suspend fun serviceResources(`value`: Output<List<String>>) {
        this.serviceResources = value
    }

    @JvmName("nywkldoivnwcjkfv")
    public suspend fun serviceResources(vararg values: Output<String>) {
        this.serviceResources = Output.all(values.asList())
    }

    /**
     * @param values A list of service resources.
     */
    @JvmName("uaxpfpbqolhjkidn")
    public suspend fun serviceResources(values: List<Output<String>>) {
        this.serviceResources = Output.all(values)
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("oehvtujvrkjowlgu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A description for this rule. Restricted to 140 chars.
     */
    @JvmName("rstuhlfmjtoeismx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kuutxuhrgbsgqylx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("sxmhsxnrcpxsionn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dvynqusqgtaqoyct")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Service endpoint name.
     */
    @JvmName("hcsdwfsjshyfqdlh")
    public suspend fun service(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.service = mapped
    }

    /**
     * @param value The name of the service endpoint policy definition name.
     */
    @JvmName("ofisuadyitjxuebq")
    public suspend fun serviceEndpointPolicyDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyDefinitionName = mapped
    }

    /**
     * @param value The name of the service endpoint policy.
     */
    @JvmName("dwjxfmgeibhslapm")
    public suspend fun serviceEndpointPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicyName = mapped
    }

    /**
     * @param value A list of service resources.
     */
    @JvmName("sqgcokkofksbyjup")
    public suspend fun serviceResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceResources = mapped
    }

    /**
     * @param values A list of service resources.
     */
    @JvmName("njpefhpflwakgpbm")
    public suspend fun serviceResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceResources = mapped
    }

    /**
     * @param value The type of the resource.
     */
    @JvmName("ytbqoiqcjfhunqec")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceEndpointPolicyDefinitionArgs = ServiceEndpointPolicyDefinitionArgs(
        description = description,
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
        service = service,
        serviceEndpointPolicyDefinitionName = serviceEndpointPolicyDefinitionName,
        serviceEndpointPolicyName = serviceEndpointPolicyName,
        serviceResources = serviceResources,
        type = type,
    )
}
