@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.DelegationResponse
import com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationProfileResponse
import com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkSecurityGroupResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.ResourceNavigationLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.RouteTableResponse
import com.pulumi.azurenative.network.kotlin.outputs.ServiceAssociationLinkResponse
import com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPropertiesFormatResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayIPConfigurationResponse.Companion.toKotlin as applicationGatewayIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.DelegationResponse.Companion.toKotlin as delegationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationProfileResponse.Companion.toKotlin as iPConfigurationProfileResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin as iPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkSecurityGroupResponse.Companion.toKotlin as networkSecurityGroupResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ResourceNavigationLinkResponse.Companion.toKotlin as resourceNavigationLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RouteTableResponse.Companion.toKotlin as routeTableResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ServiceAssociationLinkResponse.Companion.toKotlin as serviceAssociationLinkResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPolicyResponse.Companion.toKotlin as serviceEndpointPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPropertiesFormatResponse.Companion.toKotlin as serviceEndpointPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [Subnet].
 */
@PulumiTagMarker
public class SubnetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetArgs = SubnetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetArgsBuilder.() -> Unit) {
        val builder = SubnetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Subnet {
        val builtJavaResource = com.pulumi.azurenative.network.Subnet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subnet(builtJavaResource)
    }
}

/**
 * Subnet in a virtual network resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2016-03-30, 2019-02-01, 2019-06-01, 2019-08-01, 2020-06-01, 2022-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subnet = new AzureNative.Network.Subnet("subnet", new()
 *     {
 *         AddressPrefix = "10.0.0.0/16",
 *         ResourceGroupName = "subnet-test",
 *         SubnetName = "subnet1",
 *         VirtualNetworkName = "vnetname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubnet(ctx, "subnet", &network.SubnetArgs{
 * 			AddressPrefix:      pulumi.String("10.0.0.0/16"),
 * 			ResourceGroupName:  pulumi.String("subnet-test"),
 * 			SubnetName:         pulumi.String("subnet1"),
 * 			VirtualNetworkName: pulumi.String("vnetname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Subnet;
 * import com.pulumi.azurenative.network.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subnet = new Subnet("subnet", SubnetArgs.builder()
 *             .addressPrefix("10.0.0.0/16")
 *             .resourceGroupName("subnet-test")
 *             .subnetName("subnet1")
 *             .virtualNetworkName("vnetname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create subnet with a delegation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subnet = new AzureNative.Network.Subnet("subnet", new()
 *     {
 *         AddressPrefix = "10.0.0.0/16",
 *         ResourceGroupName = "subnet-test",
 *         SubnetName = "subnet1",
 *         VirtualNetworkName = "vnetname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubnet(ctx, "subnet", &network.SubnetArgs{
 * 			AddressPrefix:      pulumi.String("10.0.0.0/16"),
 * 			ResourceGroupName:  pulumi.String("subnet-test"),
 * 			SubnetName:         pulumi.String("subnet1"),
 * 			VirtualNetworkName: pulumi.String("vnetname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Subnet;
 * import com.pulumi.azurenative.network.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subnet = new Subnet("subnet", SubnetArgs.builder()
 *             .addressPrefix("10.0.0.0/16")
 *             .resourceGroupName("subnet-test")
 *             .subnetName("subnet1")
 *             .virtualNetworkName("vnetname")
 *             .build());
 *     }
 * }
 * ```
 * ### Create subnet with service endpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subnet = new AzureNative.Network.Subnet("subnet", new()
 *     {
 *         AddressPrefix = "10.0.0.0/16",
 *         ResourceGroupName = "subnet-test",
 *         ServiceEndpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.ServiceEndpointPropertiesFormatArgs
 *             {
 *                 Service = "Microsoft.Storage",
 *             },
 *         },
 *         SubnetName = "subnet1",
 *         VirtualNetworkName = "vnetname",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubnet(ctx, "subnet", &network.SubnetArgs{
 * 			AddressPrefix:     pulumi.String("10.0.0.0/16"),
 * 			ResourceGroupName: pulumi.String("subnet-test"),
 * 			ServiceEndpoints: []network.ServiceEndpointPropertiesFormatArgs{
 * 				{
 * 					Service: pulumi.String("Microsoft.Storage"),
 * 				},
 * 			},
 * 			SubnetName:         pulumi.String("subnet1"),
 * 			VirtualNetworkName: pulumi.String("vnetname"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Subnet;
 * import com.pulumi.azurenative.network.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subnet = new Subnet("subnet", SubnetArgs.builder()
 *             .addressPrefix("10.0.0.0/16")
 *             .resourceGroupName("subnet-test")
 *             .serviceEndpoints(Map.of("service", "Microsoft.Storage"))
 *             .subnetName("subnet1")
 *             .virtualNetworkName("vnetname")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Subnet subnet1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
 * ```
 */
public class Subnet internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Subnet,
) : KotlinCustomResource(javaResource, SubnetMapper) {
    /**
     * The address prefix for the subnet.
     */
    public val addressPrefix: Output<String>?
        get() = javaResource.addressPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of address prefixes for the subnet.
     */
    public val addressPrefixes: Output<List<String>>?
        get() = javaResource.addressPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Application gateway IP configurations of virtual network resource.
     */
    public val applicationGatewayIPConfigurations:
        Output<List<ApplicationGatewayIPConfigurationResponse>>?
        get() = javaResource.applicationGatewayIPConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationGatewayIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of references to the delegations on the subnet.
     */
    public val delegations: Output<List<DelegationResponse>>?
        get() = javaResource.delegations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> delegationResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Array of IpAllocation which reference this subnet.
     */
    public val ipAllocations: Output<List<SubResourceResponse>>?
        get() = javaResource.ipAllocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subResourceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Array of IP configuration profiles which reference this subnet.
     */
    public val ipConfigurationProfiles: Output<List<IPConfigurationProfileResponse>>
        get() = javaResource.ipConfigurationProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> iPConfigurationProfileResponseToKotlin(args0) })
            })
        })

    /**
     * An array of references to the network interface IP configurations using subnet.
     */
    public val ipConfigurations: Output<List<IPConfigurationResponse>>
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> iPConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Nat gateway associated with this subnet.
     */
    public val natGateway: Output<SubResourceResponse>?
        get() = javaResource.natGateway().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The reference to the NetworkSecurityGroup resource.
     */
    public val networkSecurityGroup: Output<NetworkSecurityGroupResponse>?
        get() = javaResource.networkSecurityGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkSecurityGroupResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Enable or Disable apply network policies on private end point in the subnet.
     */
    public val privateEndpointNetworkPolicies: Output<String>?
        get() = javaResource.privateEndpointNetworkPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array of references to private endpoints.
     */
    public val privateEndpoints: Output<List<PrivateEndpointResponse>>
        get() = javaResource.privateEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            })
        })

    /**
     * Enable or Disable apply network policies on private link service in the subnet.
     */
    public val privateLinkServiceNetworkPolicies: Output<String>?
        get() = javaResource.privateLinkServiceNetworkPolicies().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The provisioning state of the subnet resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
     */
    public val purpose: Output<String>
        get() = javaResource.purpose().applyValue({ args0 -> args0 })

    /**
     * An array of references to the external resources using subnet.
     */
    public val resourceNavigationLinks: Output<List<ResourceNavigationLinkResponse>>
        get() = javaResource.resourceNavigationLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceNavigationLinkResponseToKotlin(args0) })
            })
        })

    /**
     * The reference to the RouteTable resource.
     */
    public val routeTable: Output<RouteTableResponse>?
        get() = javaResource.routeTable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    routeTableResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * An array of references to services injecting into this subnet.
     */
    public val serviceAssociationLinks: Output<List<ServiceAssociationLinkResponse>>
        get() = javaResource.serviceAssociationLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceAssociationLinkResponseToKotlin(args0) })
            })
        })

    /**
     * An array of service endpoint policies.
     */
    public val serviceEndpointPolicies: Output<List<ServiceEndpointPolicyResponse>>?
        get() = javaResource.serviceEndpointPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        serviceEndpointPolicyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of service endpoints.
     */
    public val serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatResponse>>?
        get() = javaResource.serviceEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        serviceEndpointPropertiesFormatResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SubnetMapper : ResourceMapper<Subnet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Subnet::class == javaResource::class

    override fun map(javaResource: Resource): Subnet = Subnet(
        javaResource as
            com.pulumi.azurenative.network.Subnet,
    )
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subnet].
 */
public suspend fun subnet(name: String, block: suspend SubnetResourceBuilder.() -> Unit): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subnet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnet(name: String): Subnet {
    val builder = SubnetResourceBuilder()
    builder.name(name)
    return builder.build()
}
