@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualApplianceSiteArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.Office365PolicyPropertiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.Office365PolicyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Virtual Appliance Site resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create Network Virtual Appliance Site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualApplianceSite = new AzureNative.Network.VirtualApplianceSite("virtualApplianceSite", new()
 *     {
 *         AddressPrefix = "192.168.1.0/24",
 *         NetworkVirtualApplianceName = "nva",
 *         O365Policy = new AzureNative.Network.Inputs.Office365PolicyPropertiesArgs
 *         {
 *             BreakOutCategories = new AzureNative.Network.Inputs.BreakOutCategoryPoliciesArgs
 *             {
 *                 Allow = true,
 *                 Default = true,
 *                 Optimize = true,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         SiteName = "site1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualApplianceSite(ctx, "virtualApplianceSite", &network.VirtualApplianceSiteArgs{
 * 			AddressPrefix:               pulumi.String("192.168.1.0/24"),
 * 			NetworkVirtualApplianceName: pulumi.String("nva"),
 * 			O365Policy: network.Office365PolicyPropertiesResponse{
 * 				BreakOutCategories: &network.BreakOutCategoryPoliciesArgs{
 * 					Allow:    pulumi.Bool(true),
 * 					Default:  pulumi.Bool(true),
 * 					Optimize: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SiteName:          pulumi.String("site1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualApplianceSite;
 * import com.pulumi.azurenative.network.VirtualApplianceSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualApplianceSite = new VirtualApplianceSite("virtualApplianceSite", VirtualApplianceSiteArgs.builder()
 *             .addressPrefix("192.168.1.0/24")
 *             .networkVirtualApplianceName("nva")
 *             .o365Policy(Map.of("breakOutCategories", Map.ofEntries(
 *                 Map.entry("allow", true),
 *                 Map.entry("default", true),
 *                 Map.entry("optimize", true)
 *             )))
 *             .resourceGroupName("rg1")
 *             .siteName("site1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualApplianceSite site1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/virtualApplianceSites/{siteName}
 * ```
 * @property addressPrefix Address Prefix.
 * @property id Resource ID.
 * @property name Name of the virtual appliance site.
 * @property networkVirtualApplianceName The name of the Network Virtual Appliance.
 * @property o365Policy Office 365 Policy.
 * @property resourceGroupName The name of the resource group.
 * @property siteName The name of the site.
 */
public data class VirtualApplianceSiteArgs(
    public val addressPrefix: Output<String>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkVirtualApplianceName: Output<String>? = null,
    public val o365Policy: Output<Office365PolicyPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualApplianceSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualApplianceSiteArgs =
        com.pulumi.azurenative.network.VirtualApplianceSiteArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkVirtualApplianceName(networkVirtualApplianceName?.applyValue({ args0 -> args0 }))
            .o365Policy(o365Policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualApplianceSiteArgs].
 */
@PulumiTagMarker
public class VirtualApplianceSiteArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var networkVirtualApplianceName: Output<String>? = null

    private var o365Policy: Output<Office365PolicyPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    /**
     * @param value Address Prefix.
     */
    @JvmName("sleiiyoaneptviiv")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ysjrnqceaulmfqvk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the virtual appliance site.
     */
    @JvmName("qwujanvlqfjrtfvd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Network Virtual Appliance.
     */
    @JvmName("xrspmqibjbauqunu")
    public suspend fun networkVirtualApplianceName(`value`: Output<String>) {
        this.networkVirtualApplianceName = value
    }

    /**
     * @param value Office 365 Policy.
     */
    @JvmName("ttefcpnpsecylgap")
    public suspend fun o365Policy(`value`: Output<Office365PolicyPropertiesArgs>) {
        this.o365Policy = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wnvbubadkcejytuo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the site.
     */
    @JvmName("iwyqvcbgjvqvcivf")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value Address Prefix.
     */
    @JvmName("yskpgjokuesjmckg")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("swdbifhjavqxtudo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the virtual appliance site.
     */
    @JvmName("xjtbhttuxictwgmm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Network Virtual Appliance.
     */
    @JvmName("sawqceninbnwfwpb")
    public suspend fun networkVirtualApplianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkVirtualApplianceName = mapped
    }

    /**
     * @param value Office 365 Policy.
     */
    @JvmName("vbjaorpgwesvtgfo")
    public suspend fun o365Policy(`value`: Office365PolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.o365Policy = mapped
    }

    /**
     * @param argument Office 365 Policy.
     */
    @JvmName("jtipjhvnhgtlutuo")
    public suspend fun o365Policy(argument: suspend Office365PolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = Office365PolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.o365Policy = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("exlwtdfslocmrfwp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the site.
     */
    @JvmName("kdyqpfvqcqbtwiyf")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    internal fun build(): VirtualApplianceSiteArgs = VirtualApplianceSiteArgs(
        addressPrefix = addressPrefix,
        id = id,
        name = name,
        networkVirtualApplianceName = networkVirtualApplianceName,
        o365Policy = o365Policy,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
    )
}
