@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteV2Response
import com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteV2Response.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VirtualHubRouteTableV2].
 */
@PulumiTagMarker
public class VirtualHubRouteTableV2ResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualHubRouteTableV2Args = VirtualHubRouteTableV2Args()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualHubRouteTableV2ArgsBuilder.() -> Unit) {
        val builder = VirtualHubRouteTableV2ArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualHubRouteTableV2 {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualHubRouteTableV2(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualHubRouteTableV2(builtJavaResource)
    }
}

/**
 * VirtualHubRouteTableV2 Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### VirtualHubRouteTableV2Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHubRouteTableV2 = new AzureNative.Network.VirtualHubRouteTableV2("virtualHubRouteTableV2", new()
 *     {
 *         AttachedConnections = new[]
 *         {
 *             "All_Vnets",
 *         },
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "virtualHubRouteTable1a",
 *         Routes = new[]
 *         {
 *             new AzureNative.Network.Inputs.VirtualHubRouteV2Args
 *             {
 *                 DestinationType = "CIDR",
 *                 Destinations = new[]
 *                 {
 *                     "20.10.0.0/16",
 *                     "20.20.0.0/16",
 *                 },
 *                 NextHopType = "IPAddress",
 *                 NextHops = new[]
 *                 {
 *                     "10.0.0.68",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.VirtualHubRouteV2Args
 *             {
 *                 DestinationType = "CIDR",
 *                 Destinations = new[]
 *                 {
 *                     "0.0.0.0/0",
 *                 },
 *                 NextHopType = "IPAddress",
 *                 NextHops = new[]
 *                 {
 *                     "10.0.0.68",
 *                 },
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHubRouteTableV2(ctx, "virtualHubRouteTableV2", &network.VirtualHubRouteTableV2Args{
 * 			AttachedConnections: pulumi.StringArray{
 * 				pulumi.String("All_Vnets"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteTableName:    pulumi.String("virtualHubRouteTable1a"),
 * 			Routes: []network.VirtualHubRouteV2Args{
 * 				{
 * 					DestinationType: pulumi.String("CIDR"),
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("20.10.0.0/16"),
 * 						pulumi.String("20.20.0.0/16"),
 * 					},
 * 					NextHopType: pulumi.String("IPAddress"),
 * 					NextHops: pulumi.StringArray{
 * 						pulumi.String("10.0.0.68"),
 * 					},
 * 				},
 * 				{
 * 					DestinationType: pulumi.String("CIDR"),
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("0.0.0.0/0"),
 * 					},
 * 					NextHopType: pulumi.String("IPAddress"),
 * 					NextHops: pulumi.StringArray{
 * 						pulumi.String("10.0.0.68"),
 * 					},
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHubRouteTableV2;
 * import com.pulumi.azurenative.network.VirtualHubRouteTableV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHubRouteTableV2 = new VirtualHubRouteTableV2("virtualHubRouteTableV2", VirtualHubRouteTableV2Args.builder()
 *             .attachedConnections("All_Vnets")
 *             .resourceGroupName("rg1")
 *             .routeTableName("virtualHubRouteTable1a")
 *             .routes(
 *                 Map.ofEntries(
 *                     Map.entry("destinationType", "CIDR"),
 *                     Map.entry("destinations",
 *                         "20.10.0.0/16",
 *                         "20.20.0.0/16"),
 *                     Map.entry("nextHopType", "IPAddress"),
 *                     Map.entry("nextHops", "10.0.0.68")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationType", "CIDR"),
 *                     Map.entry("destinations", "0.0.0.0/0"),
 *                     Map.entry("nextHopType", "IPAddress"),
 *                     Map.entry("nextHops", "10.0.0.68")
 *                 ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHubRouteTableV2 virtualHubRouteTable1a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}
 * ```
 */
public class VirtualHubRouteTableV2 internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualHubRouteTableV2,
) : KotlinCustomResource(javaResource, VirtualHubRouteTableV2Mapper) {
    /**
     * List of all connections attached to this route table v2.
     */
    public val attachedConnections: Output<List<String>>?
        get() = javaResource.attachedConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the virtual hub route table v2 resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of all routes.
     */
    public val routes: Output<List<VirtualHubRouteV2Response>>?
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object VirtualHubRouteTableV2Mapper : ResourceMapper<VirtualHubRouteTableV2> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualHubRouteTableV2::class == javaResource::class

    override fun map(javaResource: Resource): VirtualHubRouteTableV2 =
        VirtualHubRouteTableV2(javaResource as com.pulumi.azurenative.network.VirtualHubRouteTableV2)
}

/**
 * @see [VirtualHubRouteTableV2].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualHubRouteTableV2].
 */
public suspend fun virtualHubRouteTableV2(
    name: String,
    block: suspend VirtualHubRouteTableV2ResourceBuilder.() -> Unit,
): VirtualHubRouteTableV2 {
    val builder = VirtualHubRouteTableV2ResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualHubRouteTableV2].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualHubRouteTableV2(name: String): VirtualHubRouteTableV2 {
    val builder = VirtualHubRouteTableV2ResourceBuilder()
    builder.name(name)
    return builder.build()
}
