@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionMode
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionProtocol
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayConnectionType
import com.pulumi.azurenative.network.kotlin.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.GatewayCustomBgpIpAddressIpConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LocalNetworkGatewayArgs
import com.pulumi.azurenative.network.kotlin.inputs.LocalNetworkGatewayArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.TrafficSelectorPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.TrafficSelectorPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A common class for general resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### CreateVirtualNetworkGatewayConnection_S2S
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkGatewayConnection = new AzureNative.Network.VirtualNetworkGatewayConnection("virtualNetworkGatewayConnection", new()
 *     {
 *         ConnectionMode = "Default",
 *         ConnectionProtocol = "IKEv2",
 *         ConnectionType = "IPsec",
 *         DpdTimeoutSeconds = 30,
 *         EgressNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2",
 *             },
 *         },
 *         EnableBgp = false,
 *         GatewayCustomBgpIpAddresses = new[]
 *         {
 *             new AzureNative.Network.Inputs.GatewayCustomBgpIpAddressIpConfigurationArgs
 *             {
 *                 CustomBgpIpAddress = "169.254.21.1",
 *                 IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default",
 *             },
 *             new AzureNative.Network.Inputs.GatewayCustomBgpIpAddressIpConfigurationArgs
 *             {
 *                 CustomBgpIpAddress = "169.254.21.3",
 *                 IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/ActiveActive",
 *             },
 *         },
 *         IngressNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1",
 *             },
 *         },
 *         IpsecPolicies = new[] {},
 *         LocalNetworkGateway2 = new AzureNative.Network.Inputs.LocalNetworkGatewayArgs
 *         {
 *             GatewayIpAddress = "x.x.x.x",
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/localNetworkGateways/localgw",
 *             LocalNetworkAddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *             {
 *                 AddressPrefixes = new[]
 *                 {
 *                     "10.1.0.0/16",
 *                 },
 *             },
 *             Location = "centralus",
 *             Tags = null,
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "rg1",
 *         RoutingWeight = 0,
 *         SharedKey = "Abc123",
 *         TrafficSelectorPolicies = new[] {},
 *         UsePolicyBasedTrafficSelectors = false,
 *         VirtualNetworkGateway1 = new AzureNative.Network.Inputs.VirtualNetworkGatewayArgs
 *         {
 *             ActiveActive = false,
 *             BgpSettings = new AzureNative.Network.Inputs.BgpSettingsArgs
 *             {
 *                 Asn = 65514,
 *                 BgpPeeringAddress = "10.0.1.30",
 *                 PeerWeight = 0,
 *             },
 *             EnableBgp = false,
 *             GatewayType = "Vpn",
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw",
 *             IpConfigurations = new[]
 *             {
 *                 new AzureNative.Network.Inputs.VirtualNetworkGatewayIPConfigurationArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1",
 *                     Name = "gwipconfig1",
 *                     PrivateIPAllocationMethod = "Dynamic",
 *                     PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip",
 *                     },
 *                     Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet",
 *                     },
 *                 },
 *             },
 *             Location = "centralus",
 *             Sku = new AzureNative.Network.Inputs.VirtualNetworkGatewaySkuArgs
 *             {
 *                 Name = "VpnGw1",
 *                 Tier = "VpnGw1",
 *             },
 *             Tags = null,
 *             VpnType = "RouteBased",
 *         },
 *         VirtualNetworkGatewayConnectionName = "connS2S",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewVirtualNetworkGatewayConnection(ctx, "virtualNetworkGatewayConnection", &network.VirtualNetworkGatewayConnectionArgs{
 * ConnectionMode: pulumi.String("Default"),
 * ConnectionProtocol: pulumi.String("IKEv2"),
 * ConnectionType: pulumi.String("IPsec"),
 * DpdTimeoutSeconds: pulumi.Int(30),
 * EgressNatRules: []network.SubResourceArgs{
 * {
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
 * },
 * },
 * EnableBgp: pulumi.Bool(false),
 * GatewayCustomBgpIpAddresses: []network.GatewayCustomBgpIpAddressIpConfigurationArgs{
 * {
 * CustomBgpIpAddress: pulumi.String("169.254.21.1"),
 * IpConfigurationId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default"),
 * },
 * {
 * CustomBgpIpAddress: pulumi.String("169.254.21.3"),
 * IpConfigurationId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/ActiveActive"),
 * },
 * },
 * IngressNatRules: []network.SubResourceArgs{
 * {
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
 * },
 * },
 * IpsecPolicies: network.IpsecPolicyArray{
 * },
 * LocalNetworkGateway2: network.LocalNetworkGatewayResponse{
 * GatewayIpAddress: pulumi.String("x.x.x.x"),
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/localNetworkGateways/localgw"),
 * LocalNetworkAddressSpace: &network.AddressSpaceArgs{
 * AddressPrefixes: pulumi.StringArray{
 * pulumi.String("10.1.0.0/16"),
 * },
 * },
 * Location: pulumi.String("centralus"),
 * Tags: nil,
 * },
 * Location: pulumi.String("centralus"),
 * ResourceGroupName: pulumi.String("rg1"),
 * RoutingWeight: pulumi.Int(0),
 * SharedKey: pulumi.String("Abc123"),
 * TrafficSelectorPolicies: network.TrafficSelectorPolicyArray{
 * },
 * UsePolicyBasedTrafficSelectors: pulumi.Bool(false),
 * VirtualNetworkGateway1: network.VirtualNetworkGatewayResponse{
 * ActiveActive: pulumi.Bool(false),
 * BgpSettings: &network.BgpSettingsArgs{
 * Asn: pulumi.Float64(65514),
 * BgpPeeringAddress: pulumi.String("10.0.1.30"),
 * PeerWeight: pulumi.Int(0),
 * },
 * EnableBgp: pulumi.Bool(false),
 * GatewayType: pulumi.String("Vpn"),
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
 * IpConfigurations: network.VirtualNetworkGatewayIPConfigurationArray{
 * interface{}{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
 * Name: pulumi.String("gwipconfig1"),
 * PrivateIPAllocationMethod: pulumi.String("Dynamic"),
 * PublicIPAddress: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
 * },
 * Subnet: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
 * },
 * },
 * },
 * Location: pulumi.String("centralus"),
 * Sku: &network.VirtualNetworkGatewaySkuArgs{
 * Name: pulumi.String("VpnGw1"),
 * Tier: pulumi.String("VpnGw1"),
 * },
 * Tags: nil,
 * VpnType: pulumi.String("RouteBased"),
 * },
 * VirtualNetworkGatewayConnectionName: pulumi.String("connS2S"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayConnection;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkGatewayConnection = new VirtualNetworkGatewayConnection("virtualNetworkGatewayConnection", VirtualNetworkGatewayConnectionArgs.builder()
 *             .connectionMode("Default")
 *             .connectionProtocol("IKEv2")
 *             .connectionType("IPsec")
 *             .dpdTimeoutSeconds(30)
 *             .egressNatRules(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"))
 *             .enableBgp(false)
 *             .gatewayCustomBgpIpAddresses(
 *                 Map.ofEntries(
 *                     Map.entry("customBgpIpAddress", "169.254.21.1"),
 *                     Map.entry("ipConfigurationId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/default")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("customBgpIpAddress", "169.254.21.3"),
 *                     Map.entry("ipConfigurationId", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/ActiveActive")
 *                 ))
 *             .ingressNatRules(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"))
 *             .ipsecPolicies()
 *             .localNetworkGateway2(Map.ofEntries(
 *                 Map.entry("gatewayIpAddress", "x.x.x.x"),
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/localNetworkGateways/localgw"),
 *                 Map.entry("localNetworkAddressSpace", Map.of("addressPrefixes", "10.1.0.0/16")),
 *                 Map.entry("location", "centralus"),
 *                 Map.entry("tags", )
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("rg1")
 *             .routingWeight(0)
 *             .sharedKey("Abc123")
 *             .trafficSelectorPolicies()
 *             .usePolicyBasedTrafficSelectors(false)
 *             .virtualNetworkGateway1(Map.ofEntries(
 *                 Map.entry("activeActive", false),
 *                 Map.entry("bgpSettings", Map.ofEntries(
 *                     Map.entry("asn", 65514),
 *                     Map.entry("bgpPeeringAddress", "10.0.1.30"),
 *                     Map.entry("peerWeight", 0)
 *                 )),
 *                 Map.entry("enableBgp", false),
 *                 Map.entry("gatewayType", "Vpn"),
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw"),
 *                 Map.entry("ipConfigurations", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/ipConfigurations/gwipconfig1"),
 *                     Map.entry("name", "gwipconfig1"),
 *                     Map.entry("privateIPAllocationMethod", "Dynamic"),
 *                     Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip")),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"))
 *                 )),
 *                 Map.entry("location", "centralus"),
 *                 Map.entry("sku", Map.ofEntries(
 *                     Map.entry("name", "VpnGw1"),
 *                     Map.entry("tier", "VpnGw1")
 *                 )),
 *                 Map.entry("tags", ),
 *                 Map.entry("vpnType", "RouteBased")
 *             ))
 *             .virtualNetworkGatewayConnectionName("connS2S")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkGatewayConnection connS2S /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}
 * ```
 * @property authorizationKey The authorizationKey.
 * @property connectionMode The connection mode for this connection.
 * @property connectionProtocol Connection protocol used for this connection.
 * @property connectionType Gateway connection type.
 * @property dpdTimeoutSeconds The dead peer detection timeout of this connection in seconds.
 * @property egressNatRules List of egress NatRules.
 * @property enableBgp EnableBgp flag.
 * @property enablePrivateLinkFastPath Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
 * @property expressRouteGatewayBypass Bypass ExpressRoute Gateway for data forwarding.
 * @property gatewayCustomBgpIpAddresses GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
 * @property id Resource ID.
 * @property ingressNatRules List of ingress NatRules.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property localNetworkGateway2 The reference to local network gateway resource.
 * @property location Resource location.
 * @property peer The reference to peerings resource.
 * @property resourceGroupName The name of the resource group.
 * @property routingWeight The routing weight.
 * @property sharedKey The IPSec shared key.
 * @property tags Resource tags.
 * @property trafficSelectorPolicies The Traffic Selector Policies to be considered by this connection.
 * @property useLocalAzureIpAddress Use private local Azure IP for the connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property virtualNetworkGateway1 The reference to virtual network gateway resource.
 * @property virtualNetworkGateway2 The reference to virtual network gateway resource.
 * @property virtualNetworkGatewayConnectionName The name of the virtual network gateway connection.
 */
public data class VirtualNetworkGatewayConnectionArgs(
    public val authorizationKey: Output<String>? = null,
    public val connectionMode: Output<Either<String, VirtualNetworkGatewayConnectionMode>>? = null,
    public val connectionProtocol: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? =
        null,
    public val connectionType: Output<Either<String, VirtualNetworkGatewayConnectionType>>? = null,
    public val dpdTimeoutSeconds: Output<Int>? = null,
    public val egressNatRules: Output<List<SubResourceArgs>>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enablePrivateLinkFastPath: Output<Boolean>? = null,
    public val expressRouteGatewayBypass: Output<Boolean>? = null,
    public val gatewayCustomBgpIpAddresses:
    Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>? = null,
    public val id: Output<String>? = null,
    public val ingressNatRules: Output<List<SubResourceArgs>>? = null,
    public val ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val localNetworkGateway2: Output<LocalNetworkGatewayArgs>? = null,
    public val location: Output<String>? = null,
    public val peer: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routingWeight: Output<Int>? = null,
    public val sharedKey: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null,
    public val useLocalAzureIpAddress: Output<Boolean>? = null,
    public val usePolicyBasedTrafficSelectors: Output<Boolean>? = null,
    public val virtualNetworkGateway1: Output<VirtualNetworkGatewayArgs>? = null,
    public val virtualNetworkGateway2: Output<VirtualNetworkGatewayArgs>? = null,
    public val virtualNetworkGatewayConnectionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs =
        com.pulumi.azurenative.network.VirtualNetworkGatewayConnectionArgs.builder()
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .connectionMode(
                connectionMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .connectionProtocol(
                connectionProtocol?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectionType(
                connectionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dpdTimeoutSeconds(dpdTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .egressNatRules(
                egressNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enablePrivateLinkFastPath(enablePrivateLinkFastPath?.applyValue({ args0 -> args0 }))
            .expressRouteGatewayBypass(expressRouteGatewayBypass?.applyValue({ args0 -> args0 }))
            .gatewayCustomBgpIpAddresses(
                gatewayCustomBgpIpAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ingressNatRules(
                ingressNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipsecPolicies(
                ipsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .localNetworkGateway2(
                localNetworkGateway2?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .peer(peer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficSelectorPolicies(
                trafficSelectorPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .useLocalAzureIpAddress(useLocalAzureIpAddress?.applyValue({ args0 -> args0 }))
            .usePolicyBasedTrafficSelectors(usePolicyBasedTrafficSelectors?.applyValue({ args0 -> args0 }))
            .virtualNetworkGateway1(
                virtualNetworkGateway1?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualNetworkGateway2(
                virtualNetworkGateway2?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .virtualNetworkGatewayConnectionName(
                virtualNetworkGatewayConnectionName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkGatewayConnectionArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayConnectionArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var connectionMode: Output<Either<String, VirtualNetworkGatewayConnectionMode>>? = null

    private var connectionProtocol: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>? =
        null

    private var connectionType: Output<Either<String, VirtualNetworkGatewayConnectionType>>? = null

    private var dpdTimeoutSeconds: Output<Int>? = null

    private var egressNatRules: Output<List<SubResourceArgs>>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enablePrivateLinkFastPath: Output<Boolean>? = null

    private var expressRouteGatewayBypass: Output<Boolean>? = null

    private var gatewayCustomBgpIpAddresses:
        Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>? = null

    private var id: Output<String>? = null

    private var ingressNatRules: Output<List<SubResourceArgs>>? = null

    private var ipsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var localNetworkGateway2: Output<LocalNetworkGatewayArgs>? = null

    private var location: Output<String>? = null

    private var peer: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var routingWeight: Output<Int>? = null

    private var sharedKey: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficSelectorPolicies: Output<List<TrafficSelectorPolicyArgs>>? = null

    private var useLocalAzureIpAddress: Output<Boolean>? = null

    private var usePolicyBasedTrafficSelectors: Output<Boolean>? = null

    private var virtualNetworkGateway1: Output<VirtualNetworkGatewayArgs>? = null

    private var virtualNetworkGateway2: Output<VirtualNetworkGatewayArgs>? = null

    private var virtualNetworkGatewayConnectionName: Output<String>? = null

    /**
     * @param value The authorizationKey.
     */
    @JvmName("duasproahkcmkfal")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("famngqdobjujupos")
    public suspend
    fun connectionMode(`value`: Output<Either<String, VirtualNetworkGatewayConnectionMode>>) {
        this.connectionMode = value
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("rymkpypqphgooeyv")
    public suspend
    fun connectionProtocol(`value`: Output<Either<String, VirtualNetworkGatewayConnectionProtocol>>) {
        this.connectionProtocol = value
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("nvrylelkyfbswwkd")
    public suspend
    fun connectionType(`value`: Output<Either<String, VirtualNetworkGatewayConnectionType>>) {
        this.connectionType = value
    }

    /**
     * @param value The dead peer detection timeout of this connection in seconds.
     */
    @JvmName("rrjhvydumoxgxpmh")
    public suspend fun dpdTimeoutSeconds(`value`: Output<Int>) {
        this.dpdTimeoutSeconds = value
    }

    /**
     * @param value List of egress NatRules.
     */
    @JvmName("femlgtxoycaflsqv")
    public suspend fun egressNatRules(`value`: Output<List<SubResourceArgs>>) {
        this.egressNatRules = value
    }

    @JvmName("gvpuqlbspykredao")
    public suspend fun egressNatRules(vararg values: Output<SubResourceArgs>) {
        this.egressNatRules = Output.all(values.asList())
    }

    /**
     * @param values List of egress NatRules.
     */
    @JvmName("yqfeyriqojeqxuup")
    public suspend fun egressNatRules(values: List<Output<SubResourceArgs>>) {
        this.egressNatRules = Output.all(values)
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("aieoivkmvcnyvwtr")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("atysvtwsbevmfvov")
    public suspend fun enablePrivateLinkFastPath(`value`: Output<Boolean>) {
        this.enablePrivateLinkFastPath = value
    }

    /**
     * @param value Bypass ExpressRoute Gateway for data forwarding.
     */
    @JvmName("ehrwixmfjgxfxtdc")
    public suspend fun expressRouteGatewayBypass(`value`: Output<Boolean>) {
        this.expressRouteGatewayBypass = value
    }

    /**
     * @param value GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("mspnkxrwucqmlstr")
    public suspend
    fun gatewayCustomBgpIpAddresses(`value`: Output<List<GatewayCustomBgpIpAddressIpConfigurationArgs>>) {
        this.gatewayCustomBgpIpAddresses = value
    }

    @JvmName("uufirbylchytvqul")
    public suspend fun gatewayCustomBgpIpAddresses(
        vararg
        values: Output<GatewayCustomBgpIpAddressIpConfigurationArgs>,
    ) {
        this.gatewayCustomBgpIpAddresses = Output.all(values.asList())
    }

    /**
     * @param values GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("xfrrlclaemwthxnj")
    public suspend
    fun gatewayCustomBgpIpAddresses(values: List<Output<GatewayCustomBgpIpAddressIpConfigurationArgs>>) {
        this.gatewayCustomBgpIpAddresses = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("urrgvbitrvmrrxjf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of ingress NatRules.
     */
    @JvmName("obtvsuerpaplrtct")
    public suspend fun ingressNatRules(`value`: Output<List<SubResourceArgs>>) {
        this.ingressNatRules = value
    }

    @JvmName("knexmaahjlakmtfd")
    public suspend fun ingressNatRules(vararg values: Output<SubResourceArgs>) {
        this.ingressNatRules = Output.all(values.asList())
    }

    /**
     * @param values List of ingress NatRules.
     */
    @JvmName("jcapjtppcbqevisg")
    public suspend fun ingressNatRules(values: List<Output<SubResourceArgs>>) {
        this.ingressNatRules = Output.all(values)
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("tihalufxqeddesmh")
    public suspend fun ipsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.ipsecPolicies = value
    }

    @JvmName("satyvgmowdhounxy")
    public suspend fun ipsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.ipsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("ewkobajgjaqqdgrm")
    public suspend fun ipsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.ipsecPolicies = Output.all(values)
    }

    /**
     * @param value The reference to local network gateway resource.
     */
    @JvmName("hcuaukrnjfjpjioq")
    public suspend fun localNetworkGateway2(`value`: Output<LocalNetworkGatewayArgs>) {
        this.localNetworkGateway2 = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vqudaalgvbhkijyy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The reference to peerings resource.
     */
    @JvmName("taahmjjesabuvier")
    public suspend fun peer(`value`: Output<SubResourceArgs>) {
        this.peer = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tlnnwgwrggesoqep")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The routing weight.
     */
    @JvmName("kvosnkbneutyljoq")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value The IPSec shared key.
     */
    @JvmName("dedhwhyxeawkwvbp")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dmugwknbgfpffkmw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("nhgkxvbokasjcsrr")
    public suspend fun trafficSelectorPolicies(`value`: Output<List<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = value
    }

    @JvmName("nhcejviwxecrcbqc")
    public suspend fun trafficSelectorPolicies(vararg values: Output<TrafficSelectorPolicyArgs>) {
        this.trafficSelectorPolicies = Output.all(values.asList())
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("lgkmjcmwxsuyjiig")
    public suspend fun trafficSelectorPolicies(values: List<Output<TrafficSelectorPolicyArgs>>) {
        this.trafficSelectorPolicies = Output.all(values)
    }

    /**
     * @param value Use private local Azure IP for the connection.
     */
    @JvmName("awdmsmovgbcxiscm")
    public suspend fun useLocalAzureIpAddress(`value`: Output<Boolean>) {
        this.useLocalAzureIpAddress = value
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("diqvlxbolpbqmpci")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Output<Boolean>) {
        this.usePolicyBasedTrafficSelectors = value
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("dkdsclwqpbykvqmo")
    public suspend fun virtualNetworkGateway1(`value`: Output<VirtualNetworkGatewayArgs>) {
        this.virtualNetworkGateway1 = value
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("unmaqgcfckuftigq")
    public suspend fun virtualNetworkGateway2(`value`: Output<VirtualNetworkGatewayArgs>) {
        this.virtualNetworkGateway2 = value
    }

    /**
     * @param value The name of the virtual network gateway connection.
     */
    @JvmName("acfpywgohfcflfsr")
    public suspend fun virtualNetworkGatewayConnectionName(`value`: Output<String>) {
        this.virtualNetworkGatewayConnectionName = value
    }

    /**
     * @param value The authorizationKey.
     */
    @JvmName("xprpuqcuyvfivkai")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("fnwgikooiuaiydss")
    public suspend fun connectionMode(`value`: Either<String, VirtualNetworkGatewayConnectionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("sxmcoxstdxyfbwes")
    public fun connectionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection mode for this connection.
     */
    @JvmName("viindicpktabkkms")
    public fun connectionMode(`value`: VirtualNetworkGatewayConnectionMode) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("xwggadgnhgaulvdn")
    public suspend
    fun connectionProtocol(`value`: Either<String, VirtualNetworkGatewayConnectionProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionProtocol = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("gnayruacoivrmhym")
    public fun connectionProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionProtocol = mapped
    }

    /**
     * @param value Connection protocol used for this connection.
     */
    @JvmName("djnawpubpdabdpgy")
    public fun connectionProtocol(`value`: VirtualNetworkGatewayConnectionProtocol) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionProtocol = mapped
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("xfqqwghwvpsjguwg")
    public suspend fun connectionType(`value`: Either<String, VirtualNetworkGatewayConnectionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("rxmahqjlpsyvdrvo")
    public fun connectionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value Gateway connection type.
     */
    @JvmName("titypoaiuabxwrvh")
    public fun connectionType(`value`: VirtualNetworkGatewayConnectionType) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayConnectionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionType = mapped
    }

    /**
     * @param value The dead peer detection timeout of this connection in seconds.
     */
    @JvmName("gcrevbcdjocmflvy")
    public suspend fun dpdTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dpdTimeoutSeconds = mapped
    }

    /**
     * @param value List of egress NatRules.
     */
    @JvmName("jmdpnvoosfdedtmj")
    public suspend fun egressNatRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("mmgnepqjvhoeppit")
    public suspend fun egressNatRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("dkclyvtgbnvcndlu")
    public suspend fun egressNatRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param argument List of egress NatRules.
     */
    @JvmName("ridxsofxvqnfekin")
    public suspend fun egressNatRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.egressNatRules = mapped
    }

    /**
     * @param values List of egress NatRules.
     */
    @JvmName("adjgttasyuwqtvhq")
    public suspend fun egressNatRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressNatRules = mapped
    }

    /**
     * @param value EnableBgp flag.
     */
    @JvmName("epbxoabyuanmsjiu")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("lffcggruwwpkgrjs")
    public suspend fun enablePrivateLinkFastPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateLinkFastPath = mapped
    }

    /**
     * @param value Bypass ExpressRoute Gateway for data forwarding.
     */
    @JvmName("fjcfyyyjyfhpmxfw")
    public suspend fun expressRouteGatewayBypass(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGatewayBypass = mapped
    }

    /**
     * @param value GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("swfleiboguceylru")
    public suspend
    fun gatewayCustomBgpIpAddresses(`value`: List<GatewayCustomBgpIpAddressIpConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param argument GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("xuohfoftsjpnpdti")
    public suspend
    fun gatewayCustomBgpIpAddresses(argument: List<suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param argument GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("rshfupacumhypojp")
    public suspend fun gatewayCustomBgpIpAddresses(
        vararg
        argument: suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param argument GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("edttybuojdnilmwx")
    public suspend
    fun gatewayCustomBgpIpAddresses(argument: suspend GatewayCustomBgpIpAddressIpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GatewayCustomBgpIpAddressIpConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param values GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
     */
    @JvmName("wdnrfyjllalgfkkn")
    public suspend fun gatewayCustomBgpIpAddresses(
        vararg
        values: GatewayCustomBgpIpAddressIpConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayCustomBgpIpAddresses = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jmksvhvsxkgsrvvk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of ingress NatRules.
     */
    @JvmName("momnnqlyrvtpmiie")
    public suspend fun ingressNatRules(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("ofyussoohdtsjawx")
    public suspend fun ingressNatRules(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("fcjubqwnxulgkfcj")
    public suspend fun ingressNatRules(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param argument List of ingress NatRules.
     */
    @JvmName("kmslkxxanrbmtyon")
    public suspend fun ingressNatRules(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ingressNatRules = mapped
    }

    /**
     * @param values List of ingress NatRules.
     */
    @JvmName("mylywqpmtegqlurb")
    public suspend fun ingressNatRules(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingressNatRules = mapped
    }

    /**
     * @param value The IPSec Policies to be considered by this connection.
     */
    @JvmName("jvpiqeguiubahnle")
    public suspend fun ipsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("gfareywjjlyeujxc")
    public suspend fun ipsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("gtkyugapbhahhsyk")
    public suspend fun ipsecPolicies(vararg argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param argument The IPSec Policies to be considered by this connection.
     */
    @JvmName("bxlnjvuantdvieck")
    public suspend fun ipsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipsecPolicies = mapped
    }

    /**
     * @param values The IPSec Policies to be considered by this connection.
     */
    @JvmName("jxwyhahkakeywhfu")
    public suspend fun ipsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipsecPolicies = mapped
    }

    /**
     * @param value The reference to local network gateway resource.
     */
    @JvmName("tonxsqpmjhqnmrur")
    public suspend fun localNetworkGateway2(`value`: LocalNetworkGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localNetworkGateway2 = mapped
    }

    /**
     * @param argument The reference to local network gateway resource.
     */
    @JvmName("wqcctkdoxxbgokao")
    public suspend
    fun localNetworkGateway2(argument: suspend LocalNetworkGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = LocalNetworkGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localNetworkGateway2 = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kshndlcujdpmghja")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The reference to peerings resource.
     */
    @JvmName("egqalfuvgtycrliv")
    public suspend fun peer(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peer = mapped
    }

    /**
     * @param argument The reference to peerings resource.
     */
    @JvmName("ofnvjqcqckiwuoyg")
    public suspend fun peer(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peer = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vfychmrbwjxrrydb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The routing weight.
     */
    @JvmName("twmkfpbfbdmrdwac")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    /**
     * @param value The IPSec shared key.
     */
    @JvmName("csepfenmxlupxetw")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rgwnueivjfvxgisq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("feluofqkqbgjftjn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("pchmthtksjjuyajy")
    public suspend fun trafficSelectorPolicies(`value`: List<TrafficSelectorPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("okutnxiebgapldpy")
    public suspend
    fun trafficSelectorPolicies(argument: List<suspend TrafficSelectorPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("vlslvbacljcavqqe")
    public suspend fun trafficSelectorPolicies(
        vararg
        argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrafficSelectorPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param argument The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("pqyugtltqwmsupao")
    public suspend
    fun trafficSelectorPolicies(argument: suspend TrafficSelectorPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrafficSelectorPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param values The Traffic Selector Policies to be considered by this connection.
     */
    @JvmName("adjtiwdkhqapvjre")
    public suspend fun trafficSelectorPolicies(vararg values: TrafficSelectorPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficSelectorPolicies = mapped
    }

    /**
     * @param value Use private local Azure IP for the connection.
     */
    @JvmName("stydxcgswbilkvhv")
    public suspend fun useLocalAzureIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useLocalAzureIpAddress = mapped
    }

    /**
     * @param value Enable policy-based traffic selectors.
     */
    @JvmName("oijcxfsfwtforybm")
    public suspend fun usePolicyBasedTrafficSelectors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePolicyBasedTrafficSelectors = mapped
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("rogovmknjnvjmfuc")
    public suspend fun virtualNetworkGateway1(`value`: VirtualNetworkGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGateway1 = mapped
    }

    /**
     * @param argument The reference to virtual network gateway resource.
     */
    @JvmName("vvndugehoalunpsa")
    public suspend
    fun virtualNetworkGateway1(argument: suspend VirtualNetworkGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkGateway1 = mapped
    }

    /**
     * @param value The reference to virtual network gateway resource.
     */
    @JvmName("wsutysrnhxmsqtoj")
    public suspend fun virtualNetworkGateway2(`value`: VirtualNetworkGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGateway2 = mapped
    }

    /**
     * @param argument The reference to virtual network gateway resource.
     */
    @JvmName("jpdhecqwrvxmcnni")
    public suspend
    fun virtualNetworkGateway2(argument: suspend VirtualNetworkGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkGateway2 = mapped
    }

    /**
     * @param value The name of the virtual network gateway connection.
     */
    @JvmName("svsngvdsqgbirvoi")
    public suspend fun virtualNetworkGatewayConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayConnectionName = mapped
    }

    internal fun build(): VirtualNetworkGatewayConnectionArgs = VirtualNetworkGatewayConnectionArgs(
        authorizationKey = authorizationKey,
        connectionMode = connectionMode,
        connectionProtocol = connectionProtocol,
        connectionType = connectionType,
        dpdTimeoutSeconds = dpdTimeoutSeconds,
        egressNatRules = egressNatRules,
        enableBgp = enableBgp,
        enablePrivateLinkFastPath = enablePrivateLinkFastPath,
        expressRouteGatewayBypass = expressRouteGatewayBypass,
        gatewayCustomBgpIpAddresses = gatewayCustomBgpIpAddresses,
        id = id,
        ingressNatRules = ingressNatRules,
        ipsecPolicies = ipsecPolicies,
        localNetworkGateway2 = localNetworkGateway2,
        location = location,
        peer = peer,
        resourceGroupName = resourceGroupName,
        routingWeight = routingWeight,
        sharedKey = sharedKey,
        tags = tags,
        trafficSelectorPolicies = trafficSelectorPolicies,
        useLocalAzureIpAddress = useLocalAzureIpAddress,
        usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors,
        virtualNetworkGateway1 = virtualNetworkGateway1,
        virtualNetworkGateway2 = virtualNetworkGateway2,
        virtualNetworkGatewayConnectionName = virtualNetworkGatewayConnectionName,
    )
}
