@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkBgpCommunitiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkEncryptionResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin as addressSpaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkBgpCommunitiesResponse.Companion.toKotlin as virtualNetworkBgpCommunitiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkEncryptionResponse.Companion.toKotlin as virtualNetworkEncryptionResponseToKotlin

/**
 * Builder for [VirtualNetworkPeering].
 */
@PulumiTagMarker
public class VirtualNetworkPeeringResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkPeeringArgs = VirtualNetworkPeeringArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkPeeringArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkPeeringArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualNetworkPeering {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualNetworkPeering(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetworkPeering(builtJavaResource)
    }
}

/**
 * Peerings in a virtual network resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkPeering = new AzureNative.Network.VirtualNetworkPeering("virtualNetworkPeering", new()
 *     {
 *         AllowForwardedTraffic = true,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2",
 *         },
 *         ResourceGroupName = "peerTest",
 *         UseRemoteGateways = false,
 *         VirtualNetworkName = "vnet1",
 *         VirtualNetworkPeeringName = "peer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkPeering(ctx, "virtualNetworkPeering", &network.VirtualNetworkPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(true),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("peerTest"),
 * 			UseRemoteGateways:         pulumi.Bool(false),
 * 			VirtualNetworkName:        pulumi.String("vnet1"),
 * 			VirtualNetworkPeeringName: pulumi.String("peer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkPeering;
 * import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkPeering = new VirtualNetworkPeering("virtualNetworkPeering", VirtualNetworkPeeringArgs.builder()
 *             .allowForwardedTraffic(true)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"))
 *             .resourceGroupName("peerTest")
 *             .useRemoteGateways(false)
 *             .virtualNetworkName("vnet1")
 *             .virtualNetworkPeeringName("peer")
 *             .build());
 *     }
 * }
 * ```
 * ### Create peering with remote virtual network encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkPeering = new AzureNative.Network.VirtualNetworkPeering("virtualNetworkPeering", new()
 *     {
 *         AllowForwardedTraffic = true,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2",
 *         },
 *         ResourceGroupName = "peerTest",
 *         UseRemoteGateways = false,
 *         VirtualNetworkName = "vnet1",
 *         VirtualNetworkPeeringName = "peer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkPeering(ctx, "virtualNetworkPeering", &network.VirtualNetworkPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(true),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("peerTest"),
 * 			UseRemoteGateways:         pulumi.Bool(false),
 * 			VirtualNetworkName:        pulumi.String("vnet1"),
 * 			VirtualNetworkPeeringName: pulumi.String("peer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkPeering;
 * import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkPeering = new VirtualNetworkPeering("virtualNetworkPeering", VirtualNetworkPeeringArgs.builder()
 *             .allowForwardedTraffic(true)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"))
 *             .resourceGroupName("peerTest")
 *             .useRemoteGateways(false)
 *             .virtualNetworkName("vnet1")
 *             .virtualNetworkPeeringName("peer")
 *             .build());
 *     }
 * }
 * ```
 * ### Sync Peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkPeering = new AzureNative.Network.VirtualNetworkPeering("virtualNetworkPeering", new()
 *     {
 *         AllowForwardedTraffic = true,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2",
 *         },
 *         ResourceGroupName = "peerTest",
 *         SyncRemoteAddressSpace = "true",
 *         UseRemoteGateways = false,
 *         VirtualNetworkName = "vnet1",
 *         VirtualNetworkPeeringName = "peer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkPeering(ctx, "virtualNetworkPeering", &network.VirtualNetworkPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(true),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("peerTest"),
 * 			SyncRemoteAddressSpace:    pulumi.String("true"),
 * 			UseRemoteGateways:         pulumi.Bool(false),
 * 			VirtualNetworkName:        pulumi.String("vnet1"),
 * 			VirtualNetworkPeeringName: pulumi.String("peer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkPeering;
 * import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkPeering = new VirtualNetworkPeering("virtualNetworkPeering", VirtualNetworkPeeringArgs.builder()
 *             .allowForwardedTraffic(true)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"))
 *             .resourceGroupName("peerTest")
 *             .syncRemoteAddressSpace("true")
 *             .useRemoteGateways(false)
 *             .virtualNetworkName("vnet1")
 *             .virtualNetworkPeeringName("peer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkPeering peer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/virtualNetworkPeerings/{virtualNetworkPeeringName}
 * ```
 */
public class VirtualNetworkPeering internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualNetworkPeering,
) : KotlinCustomResource(javaResource, VirtualNetworkPeeringMapper) {
    /**
     * Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    public val allowForwardedTraffic: Output<Boolean>?
        get() = javaResource.allowForwardedTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    public val allowGatewayTransit: Output<Boolean>?
        get() = javaResource.allowGatewayTransit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    public val allowVirtualNetworkAccess: Output<Boolean>?
        get() = javaResource.allowVirtualNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If we need to verify the provisioning state of the remote gateway.
     */
    public val doNotVerifyRemoteGateways: Output<Boolean>?
        get() = javaResource.doNotVerifyRemoteGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the virtual network peering.
     */
    public val peeringState: Output<String>?
        get() = javaResource.peeringState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The peering sync status of the virtual network peering.
     */
    public val peeringSyncLevel: Output<String>?
        get() = javaResource.peeringSyncLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the virtual network peering resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The reference to the address space peered with the remote virtual network.
     */
    public val remoteAddressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.remoteAddressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> addressSpaceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The reference to the remote virtual network's Bgp Communities.
     */
    public val remoteBgpCommunities: Output<VirtualNetworkBgpCommunitiesResponse>?
        get() = javaResource.remoteBgpCommunities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkBgpCommunitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    public val remoteVirtualNetwork: Output<SubResourceResponse>?
        get() = javaResource.remoteVirtualNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The reference to the current address space of the remote virtual network.
     */
    public val remoteVirtualNetworkAddressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.remoteVirtualNetworkAddressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> addressSpaceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The reference to the remote virtual network's encryption
     */
    public val remoteVirtualNetworkEncryption: Output<VirtualNetworkEncryptionResponse>
        get() = javaResource.remoteVirtualNetworkEncryption().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualNetworkEncryptionResponseToKotlin(args0)
            })
        })

    /**
     * The resourceGuid property of the Virtual Network peering resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    public val useRemoteGateways: Output<Boolean>?
        get() = javaResource.useRemoteGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualNetworkPeeringMapper : ResourceMapper<VirtualNetworkPeering> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualNetworkPeering::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkPeering =
        VirtualNetworkPeering(javaResource as com.pulumi.azurenative.network.VirtualNetworkPeering)
}

/**
 * @see [VirtualNetworkPeering].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkPeering].
 */
public suspend fun virtualNetworkPeering(
    name: String,
    block: suspend VirtualNetworkPeeringResourceBuilder.() -> Unit,
): VirtualNetworkPeering {
    val builder = VirtualNetworkPeeringResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkPeering].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkPeering(name: String): VirtualNetworkPeering {
    val builder = VirtualNetworkPeeringResourceBuilder()
    builder.name(name)
    return builder.build()
}
