@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPeeringLevel
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPeeringState
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkBgpCommunitiesArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkBgpCommunitiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Peerings in a virtual network resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Create peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkPeering = new AzureNative.Network.VirtualNetworkPeering("virtualNetworkPeering", new()
 *     {
 *         AllowForwardedTraffic = true,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2",
 *         },
 *         ResourceGroupName = "peerTest",
 *         UseRemoteGateways = false,
 *         VirtualNetworkName = "vnet1",
 *         VirtualNetworkPeeringName = "peer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkPeering(ctx, "virtualNetworkPeering", &network.VirtualNetworkPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(true),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("peerTest"),
 * 			UseRemoteGateways:         pulumi.Bool(false),
 * 			VirtualNetworkName:        pulumi.String("vnet1"),
 * 			VirtualNetworkPeeringName: pulumi.String("peer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkPeering;
 * import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkPeering = new VirtualNetworkPeering("virtualNetworkPeering", VirtualNetworkPeeringArgs.builder()
 *             .allowForwardedTraffic(true)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"))
 *             .resourceGroupName("peerTest")
 *             .useRemoteGateways(false)
 *             .virtualNetworkName("vnet1")
 *             .virtualNetworkPeeringName("peer")
 *             .build());
 *     }
 * }
 * ```
 * ### Create peering with remote virtual network encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkPeering = new AzureNative.Network.VirtualNetworkPeering("virtualNetworkPeering", new()
 *     {
 *         AllowForwardedTraffic = true,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2",
 *         },
 *         ResourceGroupName = "peerTest",
 *         UseRemoteGateways = false,
 *         VirtualNetworkName = "vnet1",
 *         VirtualNetworkPeeringName = "peer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkPeering(ctx, "virtualNetworkPeering", &network.VirtualNetworkPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(true),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("peerTest"),
 * 			UseRemoteGateways:         pulumi.Bool(false),
 * 			VirtualNetworkName:        pulumi.String("vnet1"),
 * 			VirtualNetworkPeeringName: pulumi.String("peer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkPeering;
 * import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkPeering = new VirtualNetworkPeering("virtualNetworkPeering", VirtualNetworkPeeringArgs.builder()
 *             .allowForwardedTraffic(true)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"))
 *             .resourceGroupName("peerTest")
 *             .useRemoteGateways(false)
 *             .virtualNetworkName("vnet1")
 *             .virtualNetworkPeeringName("peer")
 *             .build());
 *     }
 * }
 * ```
 * ### Sync Peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkPeering = new AzureNative.Network.VirtualNetworkPeering("virtualNetworkPeering", new()
 *     {
 *         AllowForwardedTraffic = true,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         RemoteVirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2",
 *         },
 *         ResourceGroupName = "peerTest",
 *         SyncRemoteAddressSpace = "true",
 *         UseRemoteGateways = false,
 *         VirtualNetworkName = "vnet1",
 *         VirtualNetworkPeeringName = "peer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkPeering(ctx, "virtualNetworkPeering", &network.VirtualNetworkPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(true),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			RemoteVirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"),
 * 			},
 * 			ResourceGroupName:         pulumi.String("peerTest"),
 * 			SyncRemoteAddressSpace:    pulumi.String("true"),
 * 			UseRemoteGateways:         pulumi.Bool(false),
 * 			VirtualNetworkName:        pulumi.String("vnet1"),
 * 			VirtualNetworkPeeringName: pulumi.String("peer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkPeering;
 * import com.pulumi.azurenative.network.VirtualNetworkPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkPeering = new VirtualNetworkPeering("virtualNetworkPeering", VirtualNetworkPeeringArgs.builder()
 *             .allowForwardedTraffic(true)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/subid/resourceGroups/peerTest/providers/Microsoft.Network/virtualNetworks/vnet2"))
 *             .resourceGroupName("peerTest")
 *             .syncRemoteAddressSpace("true")
 *             .useRemoteGateways(false)
 *             .virtualNetworkName("vnet1")
 *             .virtualNetworkPeeringName("peer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkPeering peer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/virtualNetworkPeerings/{virtualNetworkPeeringName}
 * ```
 * @property allowForwardedTraffic Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
 * @property allowGatewayTransit If gateway links can be used in remote virtual networking to link to this virtual network.
 * @property allowVirtualNetworkAccess Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
 * @property doNotVerifyRemoteGateways If we need to verify the provisioning state of the remote gateway.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peeringState The status of the virtual network peering.
 * @property peeringSyncLevel The peering sync status of the virtual network peering.
 * @property remoteAddressSpace The reference to the address space peered with the remote virtual network.
 * @property remoteBgpCommunities The reference to the remote virtual network's Bgp Communities.
 * @property remoteVirtualNetwork The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
 * @property remoteVirtualNetworkAddressSpace The reference to the current address space of the remote virtual network.
 * @property resourceGroupName The name of the resource group.
 * @property syncRemoteAddressSpace Parameter indicates the intention to sync the peering with the current address space on the remote vNet after it's updated.
 * @property type Resource type.
 * @property useRemoteGateways If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
 * @property virtualNetworkName The name of the virtual network.
 * @property virtualNetworkPeeringName The name of the peering.
 */
public data class VirtualNetworkPeeringArgs(
    public val allowForwardedTraffic: Output<Boolean>? = null,
    public val allowGatewayTransit: Output<Boolean>? = null,
    public val allowVirtualNetworkAccess: Output<Boolean>? = null,
    public val doNotVerifyRemoteGateways: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val peeringState: Output<Either<String, VirtualNetworkPeeringState>>? = null,
    public val peeringSyncLevel: Output<Either<String, VirtualNetworkPeeringLevel>>? = null,
    public val remoteAddressSpace: Output<AddressSpaceArgs>? = null,
    public val remoteBgpCommunities: Output<VirtualNetworkBgpCommunitiesArgs>? = null,
    public val remoteVirtualNetwork: Output<SubResourceArgs>? = null,
    public val remoteVirtualNetworkAddressSpace: Output<AddressSpaceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val syncRemoteAddressSpace: Output<String>? = null,
    public val type: Output<String>? = null,
    public val useRemoteGateways: Output<Boolean>? = null,
    public val virtualNetworkName: Output<String>? = null,
    public val virtualNetworkPeeringName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkPeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkPeeringArgs =
        com.pulumi.azurenative.network.VirtualNetworkPeeringArgs.builder()
            .allowForwardedTraffic(allowForwardedTraffic?.applyValue({ args0 -> args0 }))
            .allowGatewayTransit(allowGatewayTransit?.applyValue({ args0 -> args0 }))
            .allowVirtualNetworkAccess(allowVirtualNetworkAccess?.applyValue({ args0 -> args0 }))
            .doNotVerifyRemoteGateways(doNotVerifyRemoteGateways?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .peeringState(
                peeringState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .peeringSyncLevel(
                peeringSyncLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .remoteAddressSpace(
                remoteAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteBgpCommunities(
                remoteBgpCommunities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteVirtualNetwork(
                remoteVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteVirtualNetworkAddressSpace(
                remoteVirtualNetworkAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .syncRemoteAddressSpace(syncRemoteAddressSpace?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .useRemoteGateways(useRemoteGateways?.applyValue({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName?.applyValue({ args0 -> args0 }))
            .virtualNetworkPeeringName(virtualNetworkPeeringName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPeeringArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPeeringArgsBuilder internal constructor() {
    private var allowForwardedTraffic: Output<Boolean>? = null

    private var allowGatewayTransit: Output<Boolean>? = null

    private var allowVirtualNetworkAccess: Output<Boolean>? = null

    private var doNotVerifyRemoteGateways: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var peeringState: Output<Either<String, VirtualNetworkPeeringState>>? = null

    private var peeringSyncLevel: Output<Either<String, VirtualNetworkPeeringLevel>>? = null

    private var remoteAddressSpace: Output<AddressSpaceArgs>? = null

    private var remoteBgpCommunities: Output<VirtualNetworkBgpCommunitiesArgs>? = null

    private var remoteVirtualNetwork: Output<SubResourceArgs>? = null

    private var remoteVirtualNetworkAddressSpace: Output<AddressSpaceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var syncRemoteAddressSpace: Output<String>? = null

    private var type: Output<String>? = null

    private var useRemoteGateways: Output<Boolean>? = null

    private var virtualNetworkName: Output<String>? = null

    private var virtualNetworkPeeringName: Output<String>? = null

    /**
     * @param value Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    @JvmName("farmyvkdsiitlfre")
    public suspend fun allowForwardedTraffic(`value`: Output<Boolean>) {
        this.allowForwardedTraffic = value
    }

    /**
     * @param value If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    @JvmName("rcouuymyhreecvod")
    public suspend fun allowGatewayTransit(`value`: Output<Boolean>) {
        this.allowGatewayTransit = value
    }

    /**
     * @param value Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    @JvmName("ghdfjbatktbfydmx")
    public suspend fun allowVirtualNetworkAccess(`value`: Output<Boolean>) {
        this.allowVirtualNetworkAccess = value
    }

    /**
     * @param value If we need to verify the provisioning state of the remote gateway.
     */
    @JvmName("qanruqyyfrylilst")
    public suspend fun doNotVerifyRemoteGateways(`value`: Output<Boolean>) {
        this.doNotVerifyRemoteGateways = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vaibquepxjkfcrnk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("dmdejaofyymwggla")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("atafnxlpvbddwwak")
    public suspend fun peeringState(`value`: Output<Either<String, VirtualNetworkPeeringState>>) {
        this.peeringState = value
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("umoyhbwjhamxgunl")
    public suspend fun peeringSyncLevel(`value`: Output<Either<String, VirtualNetworkPeeringLevel>>) {
        this.peeringSyncLevel = value
    }

    /**
     * @param value The reference to the address space peered with the remote virtual network.
     */
    @JvmName("fhwltjmtcvfnlgnp")
    public suspend fun remoteAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.remoteAddressSpace = value
    }

    /**
     * @param value The reference to the remote virtual network's Bgp Communities.
     */
    @JvmName("qoeosvaxhsxxroch")
    public suspend fun remoteBgpCommunities(`value`: Output<VirtualNetworkBgpCommunitiesArgs>) {
        this.remoteBgpCommunities = value
    }

    /**
     * @param value The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    @JvmName("yaujfwafslececvn")
    public suspend fun remoteVirtualNetwork(`value`: Output<SubResourceArgs>) {
        this.remoteVirtualNetwork = value
    }

    /**
     * @param value The reference to the current address space of the remote virtual network.
     */
    @JvmName("jesngrvdjnuahlqx")
    public suspend fun remoteVirtualNetworkAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.remoteVirtualNetworkAddressSpace = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qlpojwkvbkgconfx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameter indicates the intention to sync the peering with the current address space on the remote vNet after it's updated.
     */
    @JvmName("bkktlcrpglcmcqxi")
    public suspend fun syncRemoteAddressSpace(`value`: Output<String>) {
        this.syncRemoteAddressSpace = value
    }

    /**
     * @param value Resource type.
     */
    @JvmName("lvegmukhxrsqbell")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    @JvmName("tacsednsyianpcjm")
    public suspend fun useRemoteGateways(`value`: Output<Boolean>) {
        this.useRemoteGateways = value
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("yvlseotwcsljnndk")
    public suspend fun virtualNetworkName(`value`: Output<String>) {
        this.virtualNetworkName = value
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("mfooojigdyifihpr")
    public suspend fun virtualNetworkPeeringName(`value`: Output<String>) {
        this.virtualNetworkPeeringName = value
    }

    /**
     * @param value Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    @JvmName("epigawtvfejcevxk")
    public suspend fun allowForwardedTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowForwardedTraffic = mapped
    }

    /**
     * @param value If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    @JvmName("thnyxykpmhadywdi")
    public suspend fun allowGatewayTransit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowGatewayTransit = mapped
    }

    /**
     * @param value Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    @JvmName("isllxtrfllmjqoej")
    public suspend fun allowVirtualNetworkAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVirtualNetworkAccess = mapped
    }

    /**
     * @param value If we need to verify the provisioning state of the remote gateway.
     */
    @JvmName("gryuiklrrvparwuo")
    public suspend fun doNotVerifyRemoteGateways(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doNotVerifyRemoteGateways = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yxybyyvcbqcprsuk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ybpafqkitnipwltp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("uolchmwodtsytmfi")
    public suspend fun peeringState(`value`: Either<String, VirtualNetworkPeeringState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringState = mapped
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("tvnfvjfnrvrvtxoi")
    public fun peeringState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringState = mapped
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("oeasapkguqoluuxq")
    public fun peeringState(`value`: VirtualNetworkPeeringState) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringState = mapped
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("kjxsqpyxtqjjsyvi")
    public suspend fun peeringSyncLevel(`value`: Either<String, VirtualNetworkPeeringLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringSyncLevel = mapped
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("wudsguscbmtyxhmq")
    public fun peeringSyncLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPeeringLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringSyncLevel = mapped
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("amcvuqmhurksasxn")
    public fun peeringSyncLevel(`value`: VirtualNetworkPeeringLevel) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPeeringLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringSyncLevel = mapped
    }

    /**
     * @param value The reference to the address space peered with the remote virtual network.
     */
    @JvmName("failtfypevexjhkx")
    public suspend fun remoteAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteAddressSpace = mapped
    }

    /**
     * @param argument The reference to the address space peered with the remote virtual network.
     */
    @JvmName("ydnbtnrktqwbjqwc")
    public suspend fun remoteAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteAddressSpace = mapped
    }

    /**
     * @param value The reference to the remote virtual network's Bgp Communities.
     */
    @JvmName("wvaddunpekxsfrwg")
    public suspend fun remoteBgpCommunities(`value`: VirtualNetworkBgpCommunitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteBgpCommunities = mapped
    }

    /**
     * @param argument The reference to the remote virtual network's Bgp Communities.
     */
    @JvmName("ugwiohdexbnwfgbt")
    public suspend
    fun remoteBgpCommunities(argument: suspend VirtualNetworkBgpCommunitiesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkBgpCommunitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteBgpCommunities = mapped
    }

    /**
     * @param value The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    @JvmName("mttskwkowsejlwmn")
    public suspend fun remoteVirtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param argument The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    @JvmName("ncaftacxjqjrecep")
    public suspend fun remoteVirtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param value The reference to the current address space of the remote virtual network.
     */
    @JvmName("bqbblorlstrjdhnv")
    public suspend fun remoteVirtualNetworkAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVirtualNetworkAddressSpace = mapped
    }

    /**
     * @param argument The reference to the current address space of the remote virtual network.
     */
    @JvmName("qumshwnyirrdhscp")
    public suspend
    fun remoteVirtualNetworkAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVirtualNetworkAddressSpace = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bclgvwkljuiltjfl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameter indicates the intention to sync the peering with the current address space on the remote vNet after it's updated.
     */
    @JvmName("bbmmvrbyxgcpdrri")
    public suspend fun syncRemoteAddressSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncRemoteAddressSpace = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("hefmfwfefruqxkiy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    @JvmName("yrggfwtvwsmcybue")
    public suspend fun useRemoteGateways(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useRemoteGateways = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("lhhpsmycxggvtmtv")
    public suspend fun virtualNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkName = mapped
    }

    /**
     * @param value The name of the peering.
     */
    @JvmName("fbppbmeyhxnysbcn")
    public suspend fun virtualNetworkPeeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkPeeringName = mapped
    }

    internal fun build(): VirtualNetworkPeeringArgs = VirtualNetworkPeeringArgs(
        allowForwardedTraffic = allowForwardedTraffic,
        allowGatewayTransit = allowGatewayTransit,
        allowVirtualNetworkAccess = allowVirtualNetworkAccess,
        doNotVerifyRemoteGateways = doNotVerifyRemoteGateways,
        id = id,
        name = name,
        peeringState = peeringState,
        peeringSyncLevel = peeringSyncLevel,
        remoteAddressSpace = remoteAddressSpace,
        remoteBgpCommunities = remoteBgpCommunities,
        remoteVirtualNetwork = remoteVirtualNetwork,
        remoteVirtualNetworkAddressSpace = remoteVirtualNetworkAddressSpace,
        resourceGroupName = resourceGroupName,
        syncRemoteAddressSpace = syncRemoteAddressSpace,
        type = type,
        useRemoteGateways = useRemoteGateways,
        virtualNetworkName = virtualNetworkName,
        virtualNetworkPeeringName = virtualNetworkPeeringName,
    )
}
