@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VirtualWan].
 */
@PulumiTagMarker
public class VirtualWanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualWanArgs = VirtualWanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualWanArgsBuilder.() -> Unit) {
        val builder = VirtualWanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualWan {
        val builtJavaResource = com.pulumi.azurenative.network.VirtualWan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VirtualWan(builtJavaResource)
    }
}

/**
 * VirtualWAN Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### VirtualWANCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualWan = new AzureNative.Network.VirtualWan("virtualWan", new()
 *     {
 *         DisableVpnEncryption = false,
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         Type = "Basic",
 *         VirtualWANName = "wan1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualWan(ctx, "virtualWan", &network.VirtualWanArgs{
 * 			DisableVpnEncryption: pulumi.Bool(false),
 * 			Location:             pulumi.String("West US"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			Type:           pulumi.String("Basic"),
 * 			VirtualWANName: pulumi.String("wan1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualWan;
 * import com.pulumi.azurenative.network.VirtualWanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualWan = new VirtualWan("virtualWan", VirtualWanArgs.builder()
 *             .disableVpnEncryption(false)
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .type("Basic")
 *             .virtualWANName("wan1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualWan wan1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}
 * ```
 */
public class VirtualWan internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualWan,
) : KotlinCustomResource(javaResource, VirtualWanMapper) {
    /**
     * True if branch to branch traffic is allowed.
     */
    public val allowBranchToBranchTraffic: Output<Boolean>?
        get() = javaResource.allowBranchToBranchTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * True if Vnet to Vnet traffic is allowed.
     */
    public val allowVnetToVnetTraffic: Output<Boolean>?
        get() = javaResource.allowVnetToVnetTraffic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Vpn encryption to be disabled or not.
     */
    public val disableVpnEncryption: Output<Boolean>?
        get() = javaResource.disableVpnEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The office local breakout category.
     */
    public val office365LocalBreakoutCategory: Output<String>
        get() = javaResource.office365LocalBreakoutCategory().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the virtual WAN resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of VirtualHubs in the VirtualWAN.
     */
    public val virtualHubs: Output<List<SubResourceResponse>>
        get() = javaResource.virtualHubs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * List of VpnSites in the VirtualWAN.
     */
    public val vpnSites: Output<List<SubResourceResponse>>
        get() = javaResource.vpnSites().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object VirtualWanMapper : ResourceMapper<VirtualWan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualWan::class == javaResource::class

    override fun map(javaResource: Resource): VirtualWan = VirtualWan(
        javaResource as
            com.pulumi.azurenative.network.VirtualWan,
    )
}

/**
 * @see [VirtualWan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualWan].
 */
public suspend fun virtualWan(name: String, block: suspend VirtualWanResourceBuilder.() -> Unit):
    VirtualWan {
    val builder = VirtualWanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualWan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualWan(name: String): VirtualWan {
    val builder = VirtualWanResourceBuilder()
    builder.name(name)
    return builder.build()
}
