@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VpnGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnConnectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnConnectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnGatewayNatRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnGatewayNatRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VpnGateway Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### VpnGatewayPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnGateway = new AzureNative.Network.VpnGateway("vpnGateway", new()
 *     {
 *         BgpSettings = new AzureNative.Network.Inputs.BgpSettingsArgs
 *         {
 *             Asn = 65515,
 *             BgpPeeringAddresses = new[]
 *             {
 *                 new AzureNative.Network.Inputs.IPConfigurationBgpPeeringAddressArgs
 *                 {
 *                     CustomBgpIpAddresses = new[]
 *                     {
 *                         "169.254.21.5",
 *                     },
 *                     IpconfigurationId = "Instance0",
 *                 },
 *                 new AzureNative.Network.Inputs.IPConfigurationBgpPeeringAddressArgs
 *                 {
 *                     CustomBgpIpAddresses = new[]
 *                     {
 *                         "169.254.21.10",
 *                     },
 *                     IpconfigurationId = "Instance1",
 *                 },
 *             },
 *             PeerWeight = 0,
 *         },
 *         Connections = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnConnectionArgs
 *             {
 *                 Name = "vpnConnection1",
 *                 RemoteVpnSite = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1",
 *                 },
 *                 VpnLinkConnections = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnSiteLinkConnectionArgs
 *                     {
 *                         ConnectionBandwidth = 200,
 *                         EgressNatRules = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03",
 *                             },
 *                         },
 *                         Name = "Connection-Link1",
 *                         SharedKey = "key",
 *                         VpnConnectionProtocolType = "IKEv2",
 *                         VpnSiteLink = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         EnableBgpRouteTranslationForNat = false,
 *         GatewayName = "gateway1",
 *         IsRoutingPreferenceInternet = false,
 *         Location = "westcentralus",
 *         NatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnGatewayNatRuleArgs
 *             {
 *                 ExternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "192.168.0.0/26",
 *                     },
 *                 },
 *                 InternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "0.0.0.0/26",
 *                     },
 *                 },
 *                 IpConfigurationId = "",
 *                 Mode = "EgressSnat",
 *                 Name = "nat03",
 *                 Type = "Static",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnGateway(ctx, "vpnGateway", &network.VpnGatewayArgs{
 * 			BgpSettings: network.BgpSettingsResponse{
 * 				Asn: pulumi.Float64(65515),
 * 				BgpPeeringAddresses: network.IPConfigurationBgpPeeringAddressArray{
 * 					&network.IPConfigurationBgpPeeringAddressArgs{
 * 						CustomBgpIpAddresses: pulumi.StringArray{
 * 							pulumi.String("169.254.21.5"),
 * 						},
 * 						IpconfigurationId: pulumi.String("Instance0"),
 * 					},
 * 					&network.IPConfigurationBgpPeeringAddressArgs{
 * 						CustomBgpIpAddresses: pulumi.StringArray{
 * 							pulumi.String("169.254.21.10"),
 * 						},
 * 						IpconfigurationId: pulumi.String("Instance1"),
 * 					},
 * 				},
 * 				PeerWeight: pulumi.Int(0),
 * 			},
 * 			Connections: []network.VpnConnectionTypeArgs{
 * 				{
 * 					Name: pulumi.String("vpnConnection1"),
 * 					RemoteVpnSite: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1"),
 * 					},
 * 					VpnLinkConnections: network.VpnSiteLinkConnectionArray{
 * 						{
 * 							ConnectionBandwidth: pulumi.Int(200),
 * 							EgressNatRules: network.SubResourceArray{
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03"),
 * 								},
 * 							},
 * 							Name:                      pulumi.String("Connection-Link1"),
 * 							SharedKey:                 pulumi.String("key"),
 * 							VpnConnectionProtocolType: pulumi.String("IKEv2"),
 * 							VpnSiteLink: {
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			EnableBgpRouteTranslationForNat: pulumi.Bool(false),
 * 			GatewayName:                     pulumi.String("gateway1"),
 * 			IsRoutingPreferenceInternet:     pulumi.Bool(false),
 * 			Location:                        pulumi.String("westcentralus"),
 * 			NatRules: []network.VpnGatewayNatRuleArgs{
 * 				{
 * 					ExternalMappings: network.VpnNatRuleMappingArray{
 * 						{
 * 							AddressSpace: pulumi.String("192.168.0.0/26"),
 * 						},
 * 					},
 * 					InternalMappings: network.VpnNatRuleMappingArray{
 * 						{
 * 							AddressSpace: pulumi.String("0.0.0.0/26"),
 * 						},
 * 					},
 * 					IpConfigurationId: pulumi.String(""),
 * 					Mode:              pulumi.String("EgressSnat"),
 * 					Name:              pulumi.String("nat03"),
 * 					Type:              pulumi.String("Static"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnGateway;
 * import com.pulumi.azurenative.network.VpnGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnGateway = new VpnGateway("vpnGateway", VpnGatewayArgs.builder()
 *             .bgpSettings(Map.ofEntries(
 *                 Map.entry("asn", 65515),
 *                 Map.entry("bgpPeeringAddresses",
 *                     Map.ofEntries(
 *                         Map.entry("customBgpIpAddresses", "169.254.21.5"),
 *                         Map.entry("ipconfigurationId", "Instance0")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("customBgpIpAddresses", "169.254.21.10"),
 *                         Map.entry("ipconfigurationId", "Instance1")
 *                     )),
 *                 Map.entry("peerWeight", 0)
 *             ))
 *             .connections(Map.ofEntries(
 *                 Map.entry("name", "vpnConnection1"),
 *                 Map.entry("remoteVpnSite", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1")),
 *                 Map.entry("vpnLinkConnections", Map.ofEntries(
 *                     Map.entry("connectionBandwidth", 200),
 *                     Map.entry("egressNatRules", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnGateways/gateway1/natRules/nat03")),
 *                     Map.entry("name", "Connection-Link1"),
 *                     Map.entry("sharedKey", "key"),
 *                     Map.entry("vpnConnectionProtocolType", "IKEv2"),
 *                     Map.entry("vpnSiteLink", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnSites/vpnSite1/vpnSiteLinks/siteLink1"))
 *                 ))
 *             ))
 *             .enableBgpRouteTranslationForNat(false)
 *             .gatewayName("gateway1")
 *             .isRoutingPreferenceInternet(false)
 *             .location("westcentralus")
 *             .natRules(Map.ofEntries(
 *                 Map.entry("externalMappings", Map.of("addressSpace", "192.168.0.0/26")),
 *                 Map.entry("internalMappings", Map.of("addressSpace", "0.0.0.0/26")),
 *                 Map.entry("ipConfigurationId", ""),
 *                 Map.entry("mode", "EgressSnat"),
 *                 Map.entry("name", "nat03"),
 *                 Map.entry("type", "Static")
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnGateway gateway1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}
 * ```
 * @property bgpSettings Local network gateway's BGP speaker settings.
 * @property connections List of all vpn connections to the gateway.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property enableBgpRouteTranslationForNat Enable BGP routes translation for NAT on this VpnGateway.
 * @property gatewayName The name of the gateway.
 * @property id Resource ID.
 * @property isRoutingPreferenceInternet Enable Routing Preference property for the Public IP Interface of the VpnGateway.
 * @property location Resource location.
 * @property natRules List of all the nat Rules associated with the gateway.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property resourceGroupName The resource group name of the VpnGateway.
 * @property tags Resource tags.
 * @property virtualHub The VirtualHub to which the gateway belongs.
 * @property vpnGatewayScaleUnit The scale unit for this vpn gateway.
 */
public data class VpnGatewayArgs(
    public val bgpSettings: Output<BgpSettingsArgs>? = null,
    public val connections: Output<List<VpnConnectionArgs>>? = null,
    public val enableBgpRouteTranslationForNat: Output<Boolean>? = null,
    public val gatewayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val isRoutingPreferenceInternet: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val natRules: Output<List<VpnGatewayNatRuleArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHub: Output<SubResourceArgs>? = null,
    public val vpnGatewayScaleUnit: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VpnGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VpnGatewayArgs =
        com.pulumi.azurenative.network.VpnGatewayArgs.builder()
            .bgpSettings(bgpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connections(
                connections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableBgpRouteTranslationForNat(enableBgpRouteTranslationForNat?.applyValue({ args0 -> args0 }))
            .gatewayName(gatewayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .isRoutingPreferenceInternet(isRoutingPreferenceInternet?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .natRules(
                natRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpnGatewayScaleUnit(vpnGatewayScaleUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnGatewayArgs].
 */
@PulumiTagMarker
public class VpnGatewayArgsBuilder internal constructor() {
    private var bgpSettings: Output<BgpSettingsArgs>? = null

    private var connections: Output<List<VpnConnectionArgs>>? = null

    private var enableBgpRouteTranslationForNat: Output<Boolean>? = null

    private var gatewayName: Output<String>? = null

    private var id: Output<String>? = null

    private var isRoutingPreferenceInternet: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var natRules: Output<List<VpnGatewayNatRuleArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHub: Output<SubResourceArgs>? = null

    private var vpnGatewayScaleUnit: Output<Int>? = null

    /**
     * @param value Local network gateway's BGP speaker settings.
     */
    @JvmName("djkffixlnatcuyjf")
    public suspend fun bgpSettings(`value`: Output<BgpSettingsArgs>) {
        this.bgpSettings = value
    }

    /**
     * @param value List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pptdbdgoffebvmgn")
    public suspend fun connections(`value`: Output<List<VpnConnectionArgs>>) {
        this.connections = value
    }

    @JvmName("ouphiaowhrfamxxv")
    public suspend fun connections(vararg values: Output<VpnConnectionArgs>) {
        this.connections = Output.all(values.asList())
    }

    /**
     * @param values List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("yfbcrdfrdhvgksbo")
    public suspend fun connections(values: List<Output<VpnConnectionArgs>>) {
        this.connections = Output.all(values)
    }

    /**
     * @param value Enable BGP routes translation for NAT on this VpnGateway.
     */
    @JvmName("xdiepnsbngxloyjq")
    public suspend fun enableBgpRouteTranslationForNat(`value`: Output<Boolean>) {
        this.enableBgpRouteTranslationForNat = value
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("wdumcypecarjnmvt")
    public suspend fun gatewayName(`value`: Output<String>) {
        this.gatewayName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("iwkpioyviwpvnigj")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Enable Routing Preference property for the Public IP Interface of the VpnGateway.
     */
    @JvmName("rpwmonycvxggjhok")
    public suspend fun isRoutingPreferenceInternet(`value`: Output<Boolean>) {
        this.isRoutingPreferenceInternet = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tjutugdpajagepkj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qubqkpdlpgsctqkc")
    public suspend fun natRules(`value`: Output<List<VpnGatewayNatRuleArgs>>) {
        this.natRules = value
    }

    @JvmName("rxdoeufytiyhjsul")
    public suspend fun natRules(vararg values: Output<VpnGatewayNatRuleArgs>) {
        this.natRules = Output.all(values.asList())
    }

    /**
     * @param values List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mcqqibhnwgrtdcvl")
    public suspend fun natRules(values: List<Output<VpnGatewayNatRuleArgs>>) {
        this.natRules = Output.all(values)
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("qkjoiuynkqolwkor")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ymidhfmdchfqiyyk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VirtualHub to which the gateway belongs.
     */
    @JvmName("huticfxetragxwvd")
    public suspend fun virtualHub(`value`: Output<SubResourceArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value The scale unit for this vpn gateway.
     */
    @JvmName("gmnmcwqgjgjclnfu")
    public suspend fun vpnGatewayScaleUnit(`value`: Output<Int>) {
        this.vpnGatewayScaleUnit = value
    }

    /**
     * @param value Local network gateway's BGP speaker settings.
     */
    @JvmName("alqnorfjfjigcmtg")
    public suspend fun bgpSettings(`value`: BgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSettings = mapped
    }

    /**
     * @param argument Local network gateway's BGP speaker settings.
     */
    @JvmName("otjdfvinahvciknj")
    public suspend fun bgpSettings(argument: suspend BgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSettings = mapped
    }

    /**
     * @param value List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("kljddhfuaibgqjch")
    public suspend fun connections(`value`: List<VpnConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param argument List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("brfnwdifmhjihwbk")
    public suspend fun connections(argument: List<suspend VpnConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gfvjfluvcmfcylvu")
    public suspend fun connections(vararg argument: suspend VpnConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnConnectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mbjbmncmlwdthcjf")
    public suspend fun connections(argument: suspend VpnConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnConnectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param values List of all vpn connections to the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("kfkwevwxmsynbfaa")
    public suspend fun connections(vararg values: VpnConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param value Enable BGP routes translation for NAT on this VpnGateway.
     */
    @JvmName("nwxrvnwwbpaqjyph")
    public suspend fun enableBgpRouteTranslationForNat(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgpRouteTranslationForNat = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("smbysnbfpbdidjwq")
    public suspend fun gatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pvgamxeeqodcktlo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Enable Routing Preference property for the Public IP Interface of the VpnGateway.
     */
    @JvmName("yphqdixqyplivaau")
    public suspend fun isRoutingPreferenceInternet(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRoutingPreferenceInternet = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ttotpphkfrwwxoev")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("smlwtrdxlhsucfcs")
    public suspend fun natRules(`value`: List<VpnGatewayNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natRules = mapped
    }

    /**
     * @param argument List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("gdgbdtramudifyew")
    public suspend fun natRules(argument: List<suspend VpnGatewayNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnGatewayNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param argument List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jpjciiqlqmjcmpgn")
    public suspend fun natRules(vararg argument: suspend VpnGatewayNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VpnGatewayNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param argument List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bbqhnxsxvwouqsmc")
    public suspend fun natRules(argument: suspend VpnGatewayNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnGatewayNatRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param values List of all the nat Rules associated with the gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("yksnrtsbxtoaxcql")
    public suspend fun natRules(vararg values: VpnGatewayNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natRules = mapped
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("enabvthyyaxvskgc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pwwpcxlxpiaroads")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ebupbptdtuawwuay")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VirtualHub to which the gateway belongs.
     */
    @JvmName("uabwhytebckdiopb")
    public suspend fun virtualHub(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The VirtualHub to which the gateway belongs.
     */
    @JvmName("qvnflmshbdyepjrg")
    public suspend fun virtualHub(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    /**
     * @param value The scale unit for this vpn gateway.
     */
    @JvmName("kutbrutmdyqxkfyj")
    public suspend fun vpnGatewayScaleUnit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayScaleUnit = mapped
    }

    internal fun build(): VpnGatewayArgs = VpnGatewayArgs(
        bgpSettings = bgpSettings,
        connections = connections,
        enableBgpRouteTranslationForNat = enableBgpRouteTranslationForNat,
        gatewayName = gatewayName,
        id = id,
        isRoutingPreferenceInternet = isRoutingPreferenceInternet,
        location = location,
        natRules = natRules,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualHub = virtualHub,
        vpnGatewayScaleUnit = vpnGatewayScaleUnit,
    )
}
