@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AadAuthenticationParametersResponse
import com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnGatewayResponse
import com.pulumi.azurenative.network.kotlin.outputs.RadiusServerResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigRadiusClientRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigRadiusServerRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigVpnClientRevokedCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigVpnClientRootCertificateResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.AadAuthenticationParametersResponse.Companion.toKotlin as aadAuthenticationParametersResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin as ipsecPolicyResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.P2SVpnGatewayResponse.Companion.toKotlin as p2SVpnGatewayResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RadiusServerResponse.Companion.toKotlin as radiusServerResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigRadiusClientRootCertificateResponse.Companion.toKotlin as vpnServerConfigRadiusClientRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigRadiusServerRootCertificateResponse.Companion.toKotlin as vpnServerConfigRadiusServerRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigVpnClientRevokedCertificateResponse.Companion.toKotlin as vpnServerConfigVpnClientRevokedCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigVpnClientRootCertificateResponse.Companion.toKotlin as vpnServerConfigVpnClientRootCertificateResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupResponse.Companion.toKotlin as vpnServerConfigurationPolicyGroupResponseToKotlin

/**
 * Builder for [VpnServerConfiguration].
 */
@PulumiTagMarker
public class VpnServerConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnServerConfigurationArgs = VpnServerConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnServerConfigurationArgsBuilder.() -> Unit) {
        val builder = VpnServerConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpnServerConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.VpnServerConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpnServerConfiguration(builtJavaResource)
    }
}

/**
 * VpnServerConfiguration Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### VpnServerConfigurationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnServerConfiguration = new AzureNative.Network.VpnServerConfiguration("vpnServerConfiguration", new()
 *     {
 *         ConfigurationPolicyGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1",
 *                 IsDefault = true,
 *                 Name = "policyGroup1",
 *                 PolicyMembers = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *                     {
 *                         AttributeType = "RadiusAzureGroupId",
 *                         AttributeValue = "6ad1bd08",
 *                         Name = "policy1",
 *                     },
 *                 },
 *                 Priority = 0,
 *             },
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2",
 *                 IsDefault = true,
 *                 Name = "policyGroup2",
 *                 PolicyMembers = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *                     {
 *                         AttributeType = "CertificateGroupId",
 *                         AttributeValue = "red.com",
 *                         Name = "policy2",
 *                     },
 *                 },
 *                 Priority = 0,
 *             },
 *         },
 *         Location = "West US",
 *         RadiusClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigRadiusClientRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigRadiusClientRootCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         RadiusServerRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigRadiusServerRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigRadiusServerRootCer1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM",
 *             },
 *         },
 *         RadiusServers = new[]
 *         {
 *             new AzureNative.Network.Inputs.RadiusServerArgs
 *             {
 *                 RadiusServerAddress = "10.0.0.0",
 *                 RadiusServerScore = 25,
 *                 RadiusServerSecret = "radiusServerSecret",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VpnClientIpsecPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.IpsecPolicyArgs
 *             {
 *                 DhGroup = "DHGroup14",
 *                 IkeEncryption = "AES256",
 *                 IkeIntegrity = "SHA384",
 *                 IpsecEncryption = "AES256",
 *                 IpsecIntegrity = "SHA256",
 *                 PfsGroup = "PFS14",
 *                 SaDataSizeKilobytes = 429497,
 *                 SaLifeTimeSeconds = 86472,
 *             },
 *         },
 *         VpnClientRevokedCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigVpnClientRevokedCertificateArgs
 *             {
 *                 Name = "vpnServerConfigVpnClientRevokedCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         VpnClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigVpnClientRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigVpnClientRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN",
 *             },
 *         },
 *         VpnProtocols = new[]
 *         {
 *             "IkeV2",
 *         },
 *         VpnServerConfigurationName = "vpnServerConfiguration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnServerConfiguration(ctx, "vpnServerConfiguration", &network.VpnServerConfigurationArgs{
 * 			ConfigurationPolicyGroups: []network.VpnServerConfigurationPolicyGroupArgs{
 * 				{
 * 					Id:        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
 * 					IsDefault: pulumi.Bool(true),
 * 					Name:      pulumi.String("policyGroup1"),
 * 					PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 						{
 * 							AttributeType:  pulumi.String("RadiusAzureGroupId"),
 * 							AttributeValue: pulumi.String("6ad1bd08"),
 * 							Name:           pulumi.String("policy1"),
 * 						},
 * 					},
 * 					Priority: pulumi.Int(0),
 * 				},
 * 				{
 * 					Id:        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
 * 					IsDefault: pulumi.Bool(true),
 * 					Name:      pulumi.String("policyGroup2"),
 * 					PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 						{
 * 							AttributeType:  pulumi.String("CertificateGroupId"),
 * 							AttributeValue: pulumi.String("red.com"),
 * 							Name:           pulumi.String("policy2"),
 * 						},
 * 					},
 * 					Priority: pulumi.Int(0),
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			RadiusClientRootCertificates: []network.VpnServerConfigRadiusClientRootCertificateArgs{
 * 				{
 * 					Name:       pulumi.String("vpnServerConfigRadiusClientRootCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			RadiusServerRootCertificates: []network.VpnServerConfigRadiusServerRootCertificateArgs{
 * 				{
 * 					Name:           pulumi.String("vpnServerConfigRadiusServerRootCer1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
 * 				},
 * 			},
 * 			RadiusServers: []network.RadiusServerArgs{
 * 				{
 * 					RadiusServerAddress: pulumi.String("10.0.0.0"),
 * 					RadiusServerScore:   pulumi.Float64(25),
 * 					RadiusServerSecret:  pulumi.String("radiusServerSecret"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VpnClientIpsecPolicies: []network.IpsecPolicyArgs{
 * 				{
 * 					DhGroup:             pulumi.String("DHGroup14"),
 * 					IkeEncryption:       pulumi.String("AES256"),
 * 					IkeIntegrity:        pulumi.String("SHA384"),
 * 					IpsecEncryption:     pulumi.String("AES256"),
 * 					IpsecIntegrity:      pulumi.String("SHA256"),
 * 					PfsGroup:            pulumi.String("PFS14"),
 * 					SaDataSizeKilobytes: pulumi.Int(429497),
 * 					SaLifeTimeSeconds:   pulumi.Int(86472),
 * 				},
 * 			},
 * 			VpnClientRevokedCertificates: []network.VpnServerConfigVpnClientRevokedCertificateArgs{
 * 				{
 * 					Name:       pulumi.String("vpnServerConfigVpnClientRevokedCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			VpnClientRootCertificates: []network.VpnServerConfigVpnClientRootCertificateArgs{
 * 				{
 * 					Name:           pulumi.String("vpnServerConfigVpnClientRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
 * 				},
 * 			},
 * 			VpnProtocols: pulumi.StringArray{
 * 				pulumi.String("IkeV2"),
 * 			},
 * 			VpnServerConfigurationName: pulumi.String("vpnServerConfiguration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnServerConfiguration;
 * import com.pulumi.azurenative.network.VpnServerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnServerConfiguration = new VpnServerConfiguration("vpnServerConfiguration", VpnServerConfigurationArgs.builder()
 *             .configurationPolicyGroups(
 *                 Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
 *                     Map.entry("isDefault", true),
 *                     Map.entry("name", "policyGroup1"),
 *                     Map.entry("policyMembers", Map.ofEntries(
 *                         Map.entry("attributeType", "RadiusAzureGroupId"),
 *                         Map.entry("attributeValue", "6ad1bd08"),
 *                         Map.entry("name", "policy1")
 *                     )),
 *                     Map.entry("priority", 0)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
 *                     Map.entry("isDefault", true),
 *                     Map.entry("name", "policyGroup2"),
 *                     Map.entry("policyMembers", Map.ofEntries(
 *                         Map.entry("attributeType", "CertificateGroupId"),
 *                         Map.entry("attributeValue", "red.com"),
 *                         Map.entry("name", "policy2")
 *                     )),
 *                     Map.entry("priority", 0)
 *                 ))
 *             .location("West US")
 *             .radiusClientRootCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigRadiusClientRootCert1"),
 *                 Map.entry("thumbprint", "83FFBFC8848B5A5836C94D0112367E16148A286F")
 *             ))
 *             .radiusServerRootCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigRadiusServerRootCer1"),
 *                 Map.entry("publicCertData", "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM")
 *             ))
 *             .radiusServers(Map.ofEntries(
 *                 Map.entry("radiusServerAddress", "10.0.0.0"),
 *                 Map.entry("radiusServerScore", 25),
 *                 Map.entry("radiusServerSecret", "radiusServerSecret")
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .vpnClientIpsecPolicies(Map.ofEntries(
 *                 Map.entry("dhGroup", "DHGroup14"),
 *                 Map.entry("ikeEncryption", "AES256"),
 *                 Map.entry("ikeIntegrity", "SHA384"),
 *                 Map.entry("ipsecEncryption", "AES256"),
 *                 Map.entry("ipsecIntegrity", "SHA256"),
 *                 Map.entry("pfsGroup", "PFS14"),
 *                 Map.entry("saDataSizeKilobytes", 429497),
 *                 Map.entry("saLifeTimeSeconds", 86472)
 *             ))
 *             .vpnClientRevokedCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigVpnClientRevokedCert1"),
 *                 Map.entry("thumbprint", "83FFBFC8848B5A5836C94D0112367E16148A286F")
 *             ))
 *             .vpnClientRootCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigVpnClientRootCert1"),
 *                 Map.entry("publicCertData", "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN")
 *             ))
 *             .vpnProtocols("IkeV2")
 *             .vpnServerConfigurationName("vpnServerConfiguration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnServerConfiguration vpnServerConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}
 * ```
 */
public class VpnServerConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VpnServerConfiguration,
) : KotlinCustomResource(javaResource, VpnServerConfigurationMapper) {
    /**
     * The set of aad vpn authentication parameters.
     */
    public val aadAuthenticationParameters: Output<AadAuthenticationParametersResponse>?
        get() = javaResource.aadAuthenticationParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> aadAuthenticationParametersResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * List of all VpnServerConfigurationPolicyGroups.
     */
    public val configurationPolicyGroups: Output<List<VpnServerConfigurationPolicyGroupResponse>>?
        get() = javaResource.configurationPolicyGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnServerConfigurationPolicyGroupResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of references to P2SVpnGateways.
     */
    public val p2SVpnGateways: Output<List<P2SVpnGatewayResponse>>
        get() = javaResource.p2SVpnGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> p2SVpnGatewayResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Radius client root certificate of VpnServerConfiguration.
     */
    public val radiusClientRootCertificates:
        Output<List<VpnServerConfigRadiusClientRootCertificateResponse>>?
        get() = javaResource.radiusClientRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnServerConfigRadiusClientRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The radius server address property of the VpnServerConfiguration resource for point to site client connection.
     */
    public val radiusServerAddress: Output<String>?
        get() = javaResource.radiusServerAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Radius Server root certificate of VpnServerConfiguration.
     */
    public val radiusServerRootCertificates:
        Output<List<VpnServerConfigRadiusServerRootCertificateResponse>>?
        get() = javaResource.radiusServerRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnServerConfigRadiusServerRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The radius secret property of the VpnServerConfiguration resource for point to site client connection.
     */
    public val radiusServerSecret: Output<String>?
        get() = javaResource.radiusServerSecret().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Multiple Radius Server configuration for VpnServerConfiguration.
     */
    public val radiusServers: Output<List<RadiusServerResponse>>?
        get() = javaResource.radiusServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        radiusServerResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * VPN authentication types for the VpnServerConfiguration.
     */
    public val vpnAuthenticationTypes: Output<List<String>>?
        get() = javaResource.vpnAuthenticationTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyResponse>>?
        get() = javaResource.vpnClientIpsecPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        ipsecPolicyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VPN client revoked certificate of VpnServerConfiguration.
     */
    public val vpnClientRevokedCertificates:
        Output<List<VpnServerConfigVpnClientRevokedCertificateResponse>>?
        get() = javaResource.vpnClientRevokedCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnServerConfigVpnClientRevokedCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VPN client root certificate of VpnServerConfiguration.
     */
    public val vpnClientRootCertificates:
        Output<List<VpnServerConfigVpnClientRootCertificateResponse>>?
        get() = javaResource.vpnClientRootCertificates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnServerConfigVpnClientRootCertificateResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * VPN protocols for the VpnServerConfiguration.
     */
    public val vpnProtocols: Output<List<String>>?
        get() = javaResource.vpnProtocols().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object VpnServerConfigurationMapper : ResourceMapper<VpnServerConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VpnServerConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): VpnServerConfiguration =
        VpnServerConfiguration(javaResource as com.pulumi.azurenative.network.VpnServerConfiguration)
}

/**
 * @see [VpnServerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnServerConfiguration].
 */
public suspend fun vpnServerConfiguration(
    name: String,
    block: suspend VpnServerConfigurationResourceBuilder.() -> Unit,
): VpnServerConfiguration {
    val builder = VpnServerConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnServerConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnServerConfiguration(name: String): VpnServerConfiguration {
    val builder = VpnServerConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
