@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.DevicePropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.O365PolicyPropertiesResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnSiteLinkResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin as addressSpaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin as bgpSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.DevicePropertiesResponse.Companion.toKotlin as devicePropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.O365PolicyPropertiesResponse.Companion.toKotlin as o365PolicyPropertiesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnSiteLinkResponse.Companion.toKotlin as vpnSiteLinkResponseToKotlin

/**
 * Builder for [VpnSite].
 */
@PulumiTagMarker
public class VpnSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnSiteArgs = VpnSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnSiteArgsBuilder.() -> Unit) {
        val builder = VpnSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpnSite {
        val builtJavaResource = com.pulumi.azurenative.network.VpnSite(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnSite(builtJavaResource)
    }
}

/**
 * VpnSite Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2018-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### VpnSiteCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnSite = new AzureNative.Network.VpnSite("vpnSite", new()
 *     {
 *         AddressSpace = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "10.0.0.0/16",
 *             },
 *         },
 *         IsSecuritySite = false,
 *         Location = "West US",
 *         O365Policy = new AzureNative.Network.Inputs.O365PolicyPropertiesArgs
 *         {
 *             BreakOutCategories = new AzureNative.Network.Inputs.O365BreakOutCategoryPoliciesArgs
 *             {
 *                 Allow = true,
 *                 Default = false,
 *                 Optimize = true,
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualWan = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1",
 *         },
 *         VpnSiteLinks = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnSiteLinkArgs
 *             {
 *                 BgpProperties = new AzureNative.Network.Inputs.VpnLinkBgpSettingsArgs
 *                 {
 *                     Asn = 1234,
 *                     BgpPeeringAddress = "192.168.0.0",
 *                 },
 *                 Fqdn = "link1.vpnsite1.contoso.com",
 *                 IpAddress = "50.50.50.56",
 *                 LinkProperties = new AzureNative.Network.Inputs.VpnLinkProviderPropertiesArgs
 *                 {
 *                     LinkProviderName = "vendor1",
 *                     LinkSpeedInMbps = 0,
 *                 },
 *                 Name = "vpnSiteLink1",
 *             },
 *         },
 *         VpnSiteName = "vpnSite1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnSite(ctx, "vpnSite", &network.VpnSiteArgs{
 * 			AddressSpace: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("10.0.0.0/16"),
 * 				},
 * 			},
 * 			IsSecuritySite: pulumi.Bool(false),
 * 			Location:       pulumi.String("West US"),
 * 			O365Policy: network.O365PolicyPropertiesResponse{
 * 				BreakOutCategories: &network.O365BreakOutCategoryPoliciesArgs{
 * 					Allow:    pulumi.Bool(true),
 * 					Default:  pulumi.Bool(false),
 * 					Optimize: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualWan: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1"),
 * 			},
 * 			VpnSiteLinks: []network.VpnSiteLinkArgs{
 * 				{
 * 					BgpProperties: {
 * 						Asn:               pulumi.Float64(1234),
 * 						BgpPeeringAddress: pulumi.String("192.168.0.0"),
 * 					},
 * 					Fqdn:      pulumi.String("link1.vpnsite1.contoso.com"),
 * 					IpAddress: pulumi.String("50.50.50.56"),
 * 					LinkProperties: {
 * 						LinkProviderName: pulumi.String("vendor1"),
 * 						LinkSpeedInMbps:  pulumi.Int(0),
 * 					},
 * 					Name: pulumi.String("vpnSiteLink1"),
 * 				},
 * 			},
 * 			VpnSiteName: pulumi.String("vpnSite1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnSite;
 * import com.pulumi.azurenative.network.VpnSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnSite = new VpnSite("vpnSite", VpnSiteArgs.builder()
 *             .addressSpace(Map.of("addressPrefixes", "10.0.0.0/16"))
 *             .isSecuritySite(false)
 *             .location("West US")
 *             .o365Policy(Map.of("breakOutCategories", Map.ofEntries(
 *                 Map.entry("allow", true),
 *                 Map.entry("default", false),
 *                 Map.entry("optimize", true)
 *             )))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualWan(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualWANs/wan1"))
 *             .vpnSiteLinks(Map.ofEntries(
 *                 Map.entry("bgpProperties", Map.ofEntries(
 *                     Map.entry("asn", 1234),
 *                     Map.entry("bgpPeeringAddress", "192.168.0.0")
 *                 )),
 *                 Map.entry("fqdn", "link1.vpnsite1.contoso.com"),
 *                 Map.entry("ipAddress", "50.50.50.56"),
 *                 Map.entry("linkProperties", Map.ofEntries(
 *                     Map.entry("linkProviderName", "vendor1"),
 *                     Map.entry("linkSpeedInMbps", 0)
 *                 )),
 *                 Map.entry("name", "vpnSiteLink1")
 *             ))
 *             .vpnSiteName("vpnSite1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnSite vpnSite1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnSites/{vpnSiteName}
 * ```
 */
public class VpnSite internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VpnSite,
) : KotlinCustomResource(javaResource, VpnSiteMapper) {
    /**
     * The AddressSpace that contains an array of IP address ranges.
     */
    public val addressSpace: Output<AddressSpaceResponse>?
        get() = javaResource.addressSpace().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    addressSpaceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The set of bgp properties.
     */
    public val bgpProperties: Output<BgpSettingsResponse>?
        get() = javaResource.bgpProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bgpSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The device properties.
     */
    public val deviceProperties: Output<DevicePropertiesResponse>?
        get() = javaResource.deviceProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> devicePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The ip-address for the vpn-site.
     */
    public val ipAddress: Output<String>?
        get() = javaResource.ipAddress().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IsSecuritySite flag.
     */
    public val isSecuritySite: Output<Boolean>?
        get() = javaResource.isSecuritySite().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Office365 Policy.
     */
    public val o365Policy: Output<O365PolicyPropertiesResponse>?
        get() = javaResource.o365Policy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    o365PolicyPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the VPN site resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The key for vpn-site that can be used for connections.
     */
    public val siteKey: Output<String>?
        get() = javaResource.siteKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VirtualWAN to which the vpnSite belongs.
     */
    public val virtualWan: Output<SubResourceResponse>?
        get() = javaResource.virtualWan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of all vpn site links.
     */
    public val vpnSiteLinks: Output<List<VpnSiteLinkResponse>>?
        get() = javaResource.vpnSiteLinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> vpnSiteLinkResponseToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object VpnSiteMapper : ResourceMapper<VpnSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VpnSite::class == javaResource::class

    override fun map(javaResource: Resource): VpnSite = VpnSite(
        javaResource as
            com.pulumi.azurenative.network.VpnSite,
    )
}

/**
 * @see [VpnSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnSite].
 */
public suspend fun vpnSite(name: String, block: suspend VpnSiteResourceBuilder.() -> Unit):
    VpnSite {
    val builder = VpnSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnSite(name: String): VpnSite {
    val builder = VpnSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
