@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayResponse
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRulesDefinitionResponse
import com.pulumi.azurenative.network.kotlin.outputs.PolicySettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.WebApplicationFirewallCustomRuleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayResponse.Companion.toKotlin as applicationGatewayResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ManagedRulesDefinitionResponse.Companion.toKotlin as managedRulesDefinitionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PolicySettingsResponse.Companion.toKotlin as policySettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.WebApplicationFirewallCustomRuleResponse.Companion.toKotlin as webApplicationFirewallCustomRuleResponseToKotlin

/**
 * Builder for [WebApplicationFirewallPolicy].
 */
@PulumiTagMarker
public class WebApplicationFirewallPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebApplicationFirewallPolicyArgs = WebApplicationFirewallPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebApplicationFirewallPolicyArgsBuilder.() -> Unit) {
        val builder = WebApplicationFirewallPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebApplicationFirewallPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.network.WebApplicationFirewallPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebApplicationFirewallPolicy(builtJavaResource)
    }
}

/**
 * Defines web application firewall policy.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01.
 * ## Example Usage
 * ### Creates or updates a WAF policy within a resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webApplicationFirewallPolicy = new AzureNative.Network.WebApplicationFirewallPolicy("webApplicationFirewallPolicy", new()
 *     {
 *         CustomRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = "Block",
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = "RemoteAddr",
 *                             },
 *                         },
 *                         Operator = "IPMatch",
 *                     },
 *                 },
 *                 Name = "Rule1",
 *                 Priority = 1,
 *                 RuleType = "MatchRule",
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = "Block",
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = "RemoteAddr",
 *                             },
 *                         },
 *                         Operator = "IPMatch",
 *                     },
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "Windows",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 Selector = "UserAgent",
 *                                 VariableName = "RequestHeaders",
 *                             },
 *                         },
 *                         Operator = "Contains",
 *                     },
 *                 },
 *                 Name = "Rule2",
 *                 Priority = 2,
 *                 RuleType = "MatchRule",
 *             },
 *             new AzureNative.Network.Inputs.WebApplicationFirewallCustomRuleArgs
 *             {
 *                 Action = "Block",
 *                 GroupByUserSession = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GroupByUserSessionArgs
 *                     {
 *                         GroupByVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.GroupByVariableArgs
 *                             {
 *                                 VariableName = "ClientAddr",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 MatchConditions = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.MatchConditionArgs
 *                     {
 *                         MatchValues = new[]
 *                         {
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24",
 *                         },
 *                         MatchVariables = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.MatchVariableArgs
 *                             {
 *                                 VariableName = "RemoteAddr",
 *                             },
 *                         },
 *                         NegationConditon = true,
 *                         Operator = "IPMatch",
 *                     },
 *                 },
 *                 Name = "RateLimitRule3",
 *                 Priority = 3,
 *                 RateLimitDuration = "OneMin",
 *                 RateLimitThreshold = 10,
 *                 RuleType = "RateLimitRule",
 *             },
 *         },
 *         Location = "WestUs",
 *         ManagedRules = new AzureNative.Network.Inputs.ManagedRulesDefinitionArgs
 *         {
 *             Exclusions = new[]
 *             {
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-930-APPLICATION-ATTACK-LFI",
 *                                     Rules = new[]
 *                                     {
 *                                         new AzureNative.Network.Inputs.ExclusionManagedRuleArgs
 *                                         {
 *                                             RuleId = "930120",
 *                                         },
 *                                     },
 *                                 },
 *                                 new AzureNative.Network.Inputs.ExclusionManagedRuleGroupArgs
 *                                 {
 *                                     RuleGroupName = "REQUEST-932-APPLICATION-ATTACK-RCE",
 *                                 },
 *                             },
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.2",
 *                         },
 *                     },
 *                     MatchVariable = "RequestArgNames",
 *                     Selector = "hello",
 *                     SelectorMatchOperator = "StartsWith",
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     ExclusionManagedRuleSets = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ExclusionManagedRuleSetArgs
 *                         {
 *                             RuleGroups = new[] {},
 *                             RuleSetType = "OWASP",
 *                             RuleSetVersion = "3.1",
 *                         },
 *                     },
 *                     MatchVariable = "RequestArgNames",
 *                     Selector = "hello",
 *                     SelectorMatchOperator = "EndsWith",
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = "RequestArgNames",
 *                     Selector = "test",
 *                     SelectorMatchOperator = "StartsWith",
 *                 },
 *                 new AzureNative.Network.Inputs.OwaspCrsExclusionEntryArgs
 *                 {
 *                     MatchVariable = "RequestArgValues",
 *                     Selector = "test",
 *                     SelectorMatchOperator = "StartsWith",
 *                 },
 *             },
 *             ManagedRuleSets = new[]
 *             {
 *                 new AzureNative.Network.Inputs.ManagedRuleSetArgs
 *                 {
 *                     RuleGroupOverrides = new[]
 *                     {
 *                         new AzureNative.Network.Inputs.ManagedRuleGroupOverrideArgs
 *                         {
 *                             RuleGroupName = "REQUEST-931-APPLICATION-ATTACK-RFI",
 *                             Rules = new[]
 *                             {
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "Log",
 *                                     RuleId = "931120",
 *                                     State = "Enabled",
 *                                 },
 *                                 new AzureNative.Network.Inputs.ManagedRuleOverrideArgs
 *                                 {
 *                                     Action = "AnomalyScoring",
 *                                     RuleId = "931130",
 *                                     State = "Disabled",
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     RuleSetType = "OWASP",
 *                     RuleSetVersion = "3.2",
 *                 },
 *             },
 *         },
 *         PolicyName = "Policy1",
 *         PolicySettings = new AzureNative.Network.Inputs.PolicySettingsArgs
 *         {
 *             LogScrubbing = new AzureNative.Network.Inputs.PolicySettingsLogScrubbingArgs
 *             {
 *                 ScrubbingRules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = "RequestArgNames",
 *                         Selector = "test",
 *                         SelectorMatchOperator = "Equals",
 *                         State = "Enabled",
 *                     },
 *                     new AzureNative.Network.Inputs.WebApplicationFirewallScrubbingRulesArgs
 *                     {
 *                         MatchVariable = "RequestIPAddress",
 *                         SelectorMatchOperator = "EqualsAny",
 *                         State = "Enabled",
 *                     },
 *                 },
 *                 State = "Enabled",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewWebApplicationFirewallPolicy(ctx, "webApplicationFirewallPolicy", &network.WebApplicationFirewallPolicyArgs{
 * CustomRules: []network.WebApplicationFirewallCustomRuleArgs{
 * {
 * Action: pulumi.String("Block"),
 * MatchConditions: network.MatchConditionArray{
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * VariableName: pulumi.String("RemoteAddr"),
 * },
 * },
 * Operator: pulumi.String("IPMatch"),
 * },
 * },
 * Name: pulumi.String("Rule1"),
 * Priority: pulumi.Int(1),
 * RuleType: pulumi.String("MatchRule"),
 * },
 * {
 * Action: pulumi.String("Block"),
 * MatchConditions: network.MatchConditionArray{
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * VariableName: pulumi.String("RemoteAddr"),
 * },
 * },
 * Operator: pulumi.String("IPMatch"),
 * },
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("Windows"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * Selector: pulumi.String("UserAgent"),
 * VariableName: pulumi.String("RequestHeaders"),
 * },
 * },
 * Operator: pulumi.String("Contains"),
 * },
 * },
 * Name: pulumi.String("Rule2"),
 * Priority: pulumi.Int(2),
 * RuleType: pulumi.String("MatchRule"),
 * },
 * {
 * Action: pulumi.String("Block"),
 * GroupByUserSession: network.GroupByUserSessionArray{
 * {
 * GroupByVariables: network.GroupByVariableArray{
 * {
 * VariableName: pulumi.String("ClientAddr"),
 * },
 * },
 * },
 * },
 * MatchConditions: network.MatchConditionArray{
 * {
 * MatchValues: pulumi.StringArray{
 * pulumi.String("192.168.1.0/24"),
 * pulumi.String("10.0.0.0/24"),
 * },
 * MatchVariables: network.MatchVariableArray{
 * {
 * VariableName: pulumi.String("RemoteAddr"),
 * },
 * },
 * NegationConditon: pulumi.Bool(true),
 * Operator: pulumi.String("IPMatch"),
 * },
 * },
 * Name: pulumi.String("RateLimitRule3"),
 * Priority: pulumi.Int(3),
 * RateLimitDuration: pulumi.String("OneMin"),
 * RateLimitThreshold: pulumi.Int(10),
 * RuleType: pulumi.String("RateLimitRule"),
 * },
 * },
 * Location: pulumi.String("WestUs"),
 * ManagedRules: network.ManagedRulesDefinitionResponse{
 * Exclusions: network.OwaspCrsExclusionEntryArray{
 * interface{}{
 * ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * interface{}{
 * RuleGroups: network.ExclusionManagedRuleGroupArray{
 * interface{}{
 * RuleGroupName: pulumi.String("REQUEST-930-APPLICATION-ATTACK-LFI"),
 * Rules: network.ExclusionManagedRuleArray{
 * &network.ExclusionManagedRuleArgs{
 * RuleId: pulumi.String("930120"),
 * },
 * },
 * },
 * &network.ExclusionManagedRuleGroupArgs{
 * RuleGroupName: pulumi.String("REQUEST-932-APPLICATION-ATTACK-RCE"),
 * },
 * },
 * RuleSetType: pulumi.String("OWASP"),
 * RuleSetVersion: pulumi.String("3.2"),
 * },
 * },
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("hello"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * interface{}{
 * ExclusionManagedRuleSets: network.ExclusionManagedRuleSetArray{
 * interface{}{
 * RuleGroups: network.ExclusionManagedRuleGroupArray{
 * },
 * RuleSetType: pulumi.String("OWASP"),
 * RuleSetVersion: pulumi.String("3.1"),
 * },
 * },
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("hello"),
 * SelectorMatchOperator: pulumi.String("EndsWith"),
 * },
 * &network.OwaspCrsExclusionEntryArgs{
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("test"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * &network.OwaspCrsExclusionEntryArgs{
 * MatchVariable: pulumi.String("RequestArgValues"),
 * Selector: pulumi.String("test"),
 * SelectorMatchOperator: pulumi.String("StartsWith"),
 * },
 * },
 * ManagedRuleSets: network.ManagedRuleSetArray{
 * interface{}{
 * RuleGroupOverrides: network.ManagedRuleGroupOverrideArray{
 * interface{}{
 * RuleGroupName: pulumi.String("REQUEST-931-APPLICATION-ATTACK-RFI"),
 * Rules: network.ManagedRuleOverrideArray{
 * &network.ManagedRuleOverrideArgs{
 * Action: pulumi.String("Log"),
 * RuleId: pulumi.String("931120"),
 * State: pulumi.String("Enabled"),
 * },
 * &network.ManagedRuleOverrideArgs{
 * Action: pulumi.String("AnomalyScoring"),
 * RuleId: pulumi.String("931130"),
 * State: pulumi.String("Disabled"),
 * },
 * },
 * },
 * },
 * RuleSetType: pulumi.String("OWASP"),
 * RuleSetVersion: pulumi.String("3.2"),
 * },
 * },
 * },
 * PolicyName: pulumi.String("Policy1"),
 * PolicySettings: network.PolicySettingsResponse{
 * LogScrubbing: interface{}{
 * ScrubbingRules: network.WebApplicationFirewallScrubbingRulesArray{
 * &network.WebApplicationFirewallScrubbingRulesArgs{
 * MatchVariable: pulumi.String("RequestArgNames"),
 * Selector: pulumi.String("test"),
 * SelectorMatchOperator: pulumi.String("Equals"),
 * State: pulumi.String("Enabled"),
 * },
 * &network.WebApplicationFirewallScrubbingRulesArgs{
 * MatchVariable: pulumi.String("RequestIPAddress"),
 * SelectorMatchOperator: pulumi.String("EqualsAny"),
 * State: pulumi.String("Enabled"),
 * },
 * },
 * State: pulumi.String("Enabled"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicy;
 * import com.pulumi.azurenative.network.WebApplicationFirewallPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webApplicationFirewallPolicy = new WebApplicationFirewallPolicy("webApplicationFirewallPolicy", WebApplicationFirewallPolicyArgs.builder()
 *             .customRules(
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("matchValues",
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24"),
 *                         Map.entry("matchVariables", Map.of("variableName", "RemoteAddr")),
 *                         Map.entry("operator", "IPMatch")
 *                     )),
 *                     Map.entry("name", "Rule1"),
 *                     Map.entry("priority", 1),
 *                     Map.entry("ruleType", "MatchRule")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("matchConditions",
 *                         Map.ofEntries(
 *                             Map.entry("matchValues", "192.168.1.0/24"),
 *                             Map.entry("matchVariables", Map.of("variableName", "RemoteAddr")),
 *                             Map.entry("operator", "IPMatch")
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("matchValues", "Windows"),
 *                             Map.entry("matchVariables", Map.ofEntries(
 *                                 Map.entry("selector", "UserAgent"),
 *                                 Map.entry("variableName", "RequestHeaders")
 *                             )),
 *                             Map.entry("operator", "Contains")
 *                         )),
 *                     Map.entry("name", "Rule2"),
 *                     Map.entry("priority", 2),
 *                     Map.entry("ruleType", "MatchRule")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Block"),
 *                     Map.entry("groupByUserSession", Map.of("groupByVariables", Map.of("variableName", "ClientAddr"))),
 *                     Map.entry("matchConditions", Map.ofEntries(
 *                         Map.entry("matchValues",
 *                             "192.168.1.0/24",
 *                             "10.0.0.0/24"),
 *                         Map.entry("matchVariables", Map.of("variableName", "RemoteAddr")),
 *                         Map.entry("negationConditon", true),
 *                         Map.entry("operator", "IPMatch")
 *                     )),
 *                     Map.entry("name", "RateLimitRule3"),
 *                     Map.entry("priority", 3),
 *                     Map.entry("rateLimitDuration", "OneMin"),
 *                     Map.entry("rateLimitThreshold", 10),
 *                     Map.entry("ruleType", "RateLimitRule")
 *                 ))
 *             .location("WestUs")
 *             .managedRules(Map.ofEntries(
 *                 Map.entry("exclusions",
 *                     Map.ofEntries(
 *                         Map.entry("exclusionManagedRuleSets", Map.ofEntries(
 *                             Map.entry("ruleGroups",
 *                                 Map.ofEntries(
 *                                     Map.entry("ruleGroupName", "REQUEST-930-APPLICATION-ATTACK-LFI"),
 *                                     Map.entry("rules", Map.of("ruleId", "930120"))
 *                                 ),
 *                                 Map.of("ruleGroupName", "REQUEST-932-APPLICATION-ATTACK-RCE")),
 *                             Map.entry("ruleSetType", "OWASP"),
 *                             Map.entry("ruleSetVersion", "3.2")
 *                         )),
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "hello"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("exclusionManagedRuleSets", Map.ofEntries(
 *                             Map.entry("ruleGroups", ),
 *                             Map.entry("ruleSetType", "OWASP"),
 *                             Map.entry("ruleSetVersion", "3.1")
 *                         )),
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "hello"),
 *                         Map.entry("selectorMatchOperator", "EndsWith")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "test"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestArgValues"),
 *                         Map.entry("selector", "test"),
 *                         Map.entry("selectorMatchOperator", "StartsWith")
 *                     )),
 *                 Map.entry("managedRuleSets", Map.ofEntries(
 *                     Map.entry("ruleGroupOverrides", Map.ofEntries(
 *                         Map.entry("ruleGroupName", "REQUEST-931-APPLICATION-ATTACK-RFI"),
 *                         Map.entry("rules",
 *                             Map.ofEntries(
 *                                 Map.entry("action", "Log"),
 *                                 Map.entry("ruleId", "931120"),
 *                                 Map.entry("state", "Enabled")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("action", "AnomalyScoring"),
 *                                 Map.entry("ruleId", "931130"),
 *                                 Map.entry("state", "Disabled")
 *                             ))
 *                     )),
 *                     Map.entry("ruleSetType", "OWASP"),
 *                     Map.entry("ruleSetVersion", "3.2")
 *                 ))
 *             ))
 *             .policyName("Policy1")
 *             .policySettings(Map.of("logScrubbing", Map.ofEntries(
 *                 Map.entry("scrubbingRules",
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestArgNames"),
 *                         Map.entry("selector", "test"),
 *                         Map.entry("selectorMatchOperator", "Equals"),
 *                         Map.entry("state", "Enabled")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("matchVariable", "RequestIPAddress"),
 *                         Map.entry("selectorMatchOperator", "EqualsAny"),
 *                         Map.entry("state", "Enabled")
 *                     )),
 *                 Map.entry("state", "Enabled")
 *             )))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:WebApplicationFirewallPolicy Policy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies/{policyName}
 * ```
 */
public class WebApplicationFirewallPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.network.WebApplicationFirewallPolicy,
) : KotlinCustomResource(javaResource, WebApplicationFirewallPolicyMapper) {
    /**
     * A collection of references to application gateways.
     */
    public val applicationGateways: Output<List<ApplicationGatewayResponse>>
        get() = javaResource.applicationGateways().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationGatewayResponseToKotlin(args0) })
            })
        })

    /**
     * The custom rules inside the policy.
     */
    public val customRules: Output<List<WebApplicationFirewallCustomRuleResponse>>?
        get() = javaResource.customRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        webApplicationFirewallCustomRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * A collection of references to application gateway http listeners.
     */
    public val httpListeners: Output<List<SubResourceResponse>>
        get() = javaResource.httpListeners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Describes the managedRules structure.
     */
    public val managedRules: Output<ManagedRulesDefinitionResponse>
        get() = javaResource.managedRules().applyValue({ args0 ->
            args0.let({ args0 ->
                managedRulesDefinitionResponseToKotlin(args0)
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A collection of references to application gateway path rules.
     */
    public val pathBasedRules: Output<List<SubResourceResponse>>
        get() = javaResource.pathBasedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The PolicySettings for policy.
     */
    public val policySettings: Output<PolicySettingsResponse>?
        get() = javaResource.policySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the web application firewall policy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource status of the policy.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebApplicationFirewallPolicyMapper : ResourceMapper<WebApplicationFirewallPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.WebApplicationFirewallPolicy::class == javaResource::class

    override fun map(javaResource: Resource): WebApplicationFirewallPolicy =
        WebApplicationFirewallPolicy(
            javaResource as
                com.pulumi.azurenative.network.WebApplicationFirewallPolicy,
        )
}

/**
 * @see [WebApplicationFirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebApplicationFirewallPolicy].
 */
public suspend fun webApplicationFirewallPolicy(
    name: String,
    block: suspend WebApplicationFirewallPolicyResourceBuilder.() -> Unit,
):
    WebApplicationFirewallPolicy {
    val builder = WebApplicationFirewallPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebApplicationFirewallPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webApplicationFirewallPolicy(name: String): WebApplicationFirewallPolicy {
    val builder = WebApplicationFirewallPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
