@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
 */
public enum class AdminState(
    public val javaValue: com.pulumi.azurenative.network.enums.AdminState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.AdminState> {
    Enabled(com.pulumi.azurenative.network.enums.AdminState.Enabled),
    Disabled(com.pulumi.azurenative.network.enums.AdminState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.AdminState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.AdminState): AdminState =
            AdminState.values().first { it.javaValue == javaType }
    }
}
