@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The endpoint type.
 */
public enum class EndpointType(
    public val javaValue: com.pulumi.azurenative.network.enums.EndpointType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.EndpointType> {
    AzureVM(com.pulumi.azurenative.network.enums.EndpointType.AzureVM),
    AzureVNet(com.pulumi.azurenative.network.enums.EndpointType.AzureVNet),
    AzureSubnet(com.pulumi.azurenative.network.enums.EndpointType.AzureSubnet),
    ExternalAddress(com.pulumi.azurenative.network.enums.EndpointType.ExternalAddress),
    MMAWorkspaceMachine(com.pulumi.azurenative.network.enums.EndpointType.MMAWorkspaceMachine),
    MMAWorkspaceNetwork(com.pulumi.azurenative.network.enums.EndpointType.MMAWorkspaceNetwork),
    AzureArcVM(com.pulumi.azurenative.network.enums.EndpointType.AzureArcVM),
    AzureVMSS(com.pulumi.azurenative.network.enums.EndpointType.AzureVMSS),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.EndpointType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.EndpointType): EndpointType =
            EndpointType.values().first { it.javaValue == javaType }
    }
}
