@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Comparison type to use for matching with the variable value.
 */
public enum class Operator(
    public val javaValue: com.pulumi.azurenative.network.enums.Operator,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.Operator> {
    Any(com.pulumi.azurenative.network.enums.Operator.Any),
    IPMatch(com.pulumi.azurenative.network.enums.Operator.IPMatch),
    GeoMatch(com.pulumi.azurenative.network.enums.Operator.GeoMatch),
    Equal(com.pulumi.azurenative.network.enums.Operator.Equal),
    Contains(com.pulumi.azurenative.network.enums.Operator.Contains),
    LessThan(com.pulumi.azurenative.network.enums.Operator.LessThan),
    GreaterThan(com.pulumi.azurenative.network.enums.Operator.GreaterThan),
    LessThanOrEqual(com.pulumi.azurenative.network.enums.Operator.LessThanOrEqual),
    GreaterThanOrEqual(com.pulumi.azurenative.network.enums.Operator.GreaterThanOrEqual),
    BeginsWith(com.pulumi.azurenative.network.enums.Operator.BeginsWith),
    EndsWith(com.pulumi.azurenative.network.enums.Operator.EndsWith),
    RegEx(com.pulumi.azurenative.network.enums.Operator.RegEx),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.Operator = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.Operator): Operator =
            Operator.values().first { it.javaValue == javaType }
    }
}
