@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes if it is in detection mode or prevention mode at policy level.
 */
public enum class PolicyMode(
    public val javaValue: com.pulumi.azurenative.network.enums.PolicyMode,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.PolicyMode> {
    Prevention(com.pulumi.azurenative.network.enums.PolicyMode.Prevention),
    Detection(com.pulumi.azurenative.network.enums.PolicyMode.Detection),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.PolicyMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.PolicyMode): PolicyMode =
            PolicyMode.values().first { it.javaValue == javaType }
    }
}
